/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.comm.snmp;

import com.sanrad.log.LogMgr;
import com.sanrad.nms.server.comm.snmp.DefaultSnmpMgr;
import com.sanrad.nms.server.comm.snmp.MibNameToSrType;
import com.sanrad.nms.server.comm.snmp.SnmpVersion;
import com.sanrad.nms.server.comm.snmp.SrOid;
import com.sanrad.nms.server.comm.snmp.SrSnmpVarBind;
import com.sanrad.nms.server.comm.snmp.SrSnmpVarBindList;
import com.sanrad.nms.server.comm.snmp.exception.SnmpOidFormatErrorException;
import com.sanrad.nms.server.comm.snmp.exception.SnmpUnknownValueTypeException;
import com.sanrad.nms.server.comm.snmp.exception.SrSnmpConversionException;
import com.sanrad.nms.server.comm.snmp.exception.SrSnmpException;
import com.sanrad.nms.server.comm.snmp.trap.SrTrapType;
import com.sanrad.nms.server.util.types.SrCounter32;
import com.sanrad.nms.server.util.types.SrCounter64;
import com.sanrad.nms.server.util.types.SrDateAndTime;
import com.sanrad.nms.server.util.types.SrGauge;
import com.sanrad.nms.server.util.types.SrInteger;
import com.sanrad.nms.server.util.types.SrIpAddress;
import com.sanrad.nms.server.util.types.SrOidType;
import com.sanrad.nms.server.util.types.SrString;
import com.sanrad.nms.server.util.types.SrTimeTicks;
import com.sanrad.nms.server.util.types.SrType;
import com.sanrad.nms.server.util.types.constants.MibItemConstant;
import com.sanrad.nms.server.util.types.constants.SrBITSConstant;
import monfox.toolkit.snmp.NoSuchObjectException;
import monfox.toolkit.snmp.SnmpCounter;
import monfox.toolkit.snmp.SnmpCounter64;
import monfox.toolkit.snmp.SnmpGauge;
import monfox.toolkit.snmp.SnmpInt;
import monfox.toolkit.snmp.SnmpIpAddress;
import monfox.toolkit.snmp.SnmpNull;
import monfox.toolkit.snmp.SnmpOid;
import monfox.toolkit.snmp.SnmpString;
import monfox.toolkit.snmp.SnmpTimeTicks;
import monfox.toolkit.snmp.SnmpValue;
import monfox.toolkit.snmp.SnmpValueException;
import monfox.toolkit.snmp.SnmpVarBind;
import monfox.toolkit.snmp.SnmpVarBindList;
import monfox.toolkit.snmp.ext.SnmpRow;
import monfox.toolkit.snmp.metadata.SnmpMetadataException;
import monfox.toolkit.snmp.metadata.SnmpTypeInfo;

public class DsnmpUtil {
    private DsnmpUtil() {
    }

    public static SrSnmpVarBindList convertDSnmpVarBindListToSrSnmpVarBindList(SnmpVarBindList dList) throws SrSnmpConversionException {
        if (dList == null) {
            return null;
        }
        SrSnmpVarBindList srList = new SrSnmpVarBindList();
        for (int i = 0; i < dList.size(); ++i) {
            srList.add(DsnmpUtil.convertDSnmpVarBindToSrSnmpVarBind(dList.get(i)));
        }
        return srList;
    }

    public static SrSnmpVarBind convertDSnmpVarBindToSrSnmpVarBind(SnmpVarBind varBind) throws SrSnmpConversionException {
        SrSnmpVarBind srVarBind = null;
        String oid = "";
        try {
            String index = DsnmpUtil.getIndexStringFromOid(varBind.getOid());
            int dot = varBind.getOid().toString().indexOf(".");
            oid = varBind.getOid().toString().substring(0, dot);
            SrOid srOid = new SrOid(oid, index);
            SrType value = DsnmpUtil.convertDSnmpValueToSrType(varBind);
            srVarBind = new SrSnmpVarBind(srOid, value);
        }
        catch (SnmpOidFormatErrorException e) {
            LogMgr.getServerLog().error(e);
            throw new SrSnmpConversionException("SNMP Error - Oid Format Error for " + varBind);
        }
        catch (IndexOutOfBoundsException e) {
            LogMgr.getServerLog().error(e);
            throw new SrSnmpConversionException("SNMP Error - Index Out Of Bound for: " + varBind);
        }
        catch (SnmpUnknownValueTypeException e) {
            LogMgr.getServerLog().error(e);
            throw new SrSnmpConversionException("SNMP Error - Unknown Value Type for: " + varBind);
        }
        return srVarBind;
    }

    private static String getIndexStringFromOid(SnmpOid oid) {
        String oidByName = oid.toString();
        int first = oidByName.indexOf(".");
        switch (first) {
            case -1: 
            case 0: 
            case 1: {
                throw new SnmpOidFormatErrorException(oid.toString());
            }
        }
        return oid.getString().substring(first + 1);
    }

    private static SrType convertDSnmpValueToSrType(SnmpVarBind varBind) throws SrSnmpConversionException {
        SnmpValue value = varBind.getValue();
        if (value == null) {
            return null;
        }
        switch (value.getType()) {
            case 70: {
                return new SrCounter64(value.getBigInteger());
            }
            case 64: {
                return new SrIpAddress(value.getByteArray());
            }
            case 65: {
                return new SrCounter32(value.getBigInteger());
            }
            case 66: {
                return new SrGauge(value.longValue());
            }
            case 67: {
                return new SrTimeTicks(value.longValue());
            }
            case 2: {
                String name = varBind.getOid().getOidInfo().getName();
                try {
                    SnmpTypeInfo typeInfo = DefaultSnmpMgr.metaData.getObject(name).getTypeInfo();
                    if (typeInfo != null && typeInfo.getName() != null) {
                        name = typeInfo.getName();
                    }
                }
                catch (SnmpValueException e) {
                    LogMgr.getServerLog().warning((Exception)((Object)e));
                    throw new SrSnmpConversionException("Cannot get the oid type name for: " + varBind.toString());
                }
                return MibNameToSrType.get(name, ((SnmpInt)value).intValue());
            }
            case 6: {
                long[] str = value.toLongArray();
                return new SrOidType(str);
            }
            case 4: {
                String name = varBind.getOid().getOidInfo().getName();
                try {
                    SnmpTypeInfo typeInfo = DefaultSnmpMgr.metaData.getObject(name).getTypeInfo();
                    if (typeInfo != null && typeInfo.getName() != null) {
                        name = typeInfo.getName();
                    }
                }
                catch (SnmpValueException e) {
                    LogMgr.getServerLog().warning((Exception)((Object)e));
                    throw new SrSnmpConversionException("Cannot get the oid type name for: " + varBind.toString());
                }
                return MibNameToSrType.get(name, varBind.getFormattedString());
            }
            case 5: {
                return null;
            }
        }
        if (value instanceof SnmpNull) {
            return null;
        }
        throw new SrSnmpConversionException("Unknown Value in SnmpValue for: " + varBind.toString());
    }

    public static SrSnmpVarBindList convertDSnmpRowToSrSnmpRow(SnmpRow row) {
        if (row == null) {
            return null;
        }
        SrSnmpVarBindList srRow = new SrSnmpVarBindList();
        for (int i = 0; i < row.size(); ++i) {
            try {
                srRow.addElement(DsnmpUtil.convertDSnmpVarBindToSrSnmpVarBind(row.getVarBind(i)));
                continue;
            }
            catch (NoSuchObjectException e) {
                StringBuffer msg = new StringBuffer("DSNMP Error - cannot get a VarBind from a row at index: ");
                msg.append(i);
                msg.append(" in row: ");
                msg.append(row.toString());
                LogMgr.getServerLog().debug(msg.toString(), (Exception)((Object)e));
                throw new SrSnmpConversionException("DSNMP Error - cannot get a VarBind from row");
            }
        }
        return srRow;
    }

    public static SnmpVarBind convertSrSnmpVarBindToDSnmpVarBInd(SrSnmpVarBind varBind) throws SrSnmpConversionException {
        String oid = ((SrOid)varBind.getVarBindKey()).getFullOid();
        String oidName = ((SrOid)varBind.getVarBindKey()).getOid();
        SnmpValue val = null;
        val = DsnmpUtil.convertSrTypeToDSnmpValue(varBind.getValue(), oidName);
        SnmpVarBind newVarBind = null;
        try {
            newVarBind = new SnmpVarBind(oid, val);
        }
        catch (SnmpValueException e) {
            LogMgr.getServerLog().debug((Exception)((Object)e));
            throw new SrSnmpConversionException(e.getMessage() + " for varBind: " + varBind);
        }
        return newVarBind;
    }

    public static SnmpValue convertSrTypeToDSnmpValue(SrType val, String oidName) throws SrSnmpConversionException {
        if (val == null) {
            return null;
        }
        int typeNumber = val.getTypeNumber();
        String errorData = null;
        try {
            switch (typeNumber) {
                case 1: {
                    return new SnmpCounter(((SrCounter32)val).longValue());
                }
                case 2: {
                    return new SnmpGauge(((SrGauge)val).longValue());
                }
                case 5: {
                    return new SnmpTimeTicks(((SrTimeTicks)val).longValue());
                }
                case 4: {
                    return new SnmpInt(((SrInteger)val).intValue());
                }
                case 3: {
                    return new SnmpCounter64(((SrCounter64)val).longValue());
                }
                case 6: {
                    return new SnmpString(val.toString());
                }
                case 8: {
                    return new SnmpOid(((SrOidType)val).toDisplayString());
                }
                case 9: {
                    return new SnmpInt(((MibItemConstant)val).intValue());
                }
                case 10: {
                    return new SnmpString("'" + val.toString() + "'H");
                }
                case 11: {
                    return new SnmpString(((SrDateAndTime)val).getSnmpFormat());
                }
                case 7: {
                    errorData = oidName;
                    SnmpTypeInfo typeInfo = DefaultSnmpMgr.metaData.getObject(oidName).getTypeInfo();
                    if (typeInfo != null && typeInfo.getName().equals("InetAddress")) {
                        return new SnmpString(((SrIpAddress)val).toInetAddressSnmpString());
                    }
                    errorData = null;
                    return new SnmpIpAddress(((SrIpAddress)val).toString());
                }
                case 12: {
                    if (val instanceof SrBITSConstant) {
                        int bitNumber = ((SrBITSConstant)val).getBitNumber();
                        if (bitNumber >= 0) {
                            return new SnmpString("'" + bitNumber + "'H");
                        }
                        return new SnmpString("''H");
                    }
                    return new SnmpString("'" + val.toString() + "'H");
                }
                case 13: {
                    return new SnmpString(val.toString());
                }
                case 18: {
                    int boolValue = (Boolean)val.value() != false ? 1 : 2;
                    return new SnmpInt(boolValue);
                }
            }
            throw new SrSnmpConversionException("Cannot convert unknown type: " + val.toString());
        }
        catch (SnmpValueException e) {
            StringBuffer msg = new StringBuffer("Cannot convert ");
            msg.append(val.getTypeName());
            if (errorData == null) {
                errorData = val.toString();
            }
            msg.append(errorData);
            LogMgr.getServerLog().debug(msg.toString(), (Exception)((Object)e));
            throw new SrSnmpConversionException("Error converting " + val.getTypeName());
        }
    }

    public static int getdsnmpVsrsion(SnmpVersion ver) throws SrSnmpException {
        if (ver.equals(SnmpVersion.V1)) {
            return 0;
        }
        if (ver.equals(SnmpVersion.V2C)) {
            return 1;
        }
        if (ver.equals(SnmpVersion.V3)) {
            return 3;
        }
        throw new SrSnmpException("SnmpVersion Error - Unknown version");
    }

    public static int getdsnmpVsrsion(SrString ver) throws SrSnmpException {
        if (ver.equals(SnmpVersion.V1.toString())) {
            return 0;
        }
        if (ver.equals(SnmpVersion.V2C.toString())) {
            return 1;
        }
        if (ver.equals(SnmpVersion.V3.toString())) {
            return 3;
        }
        throw new SrSnmpException("SnmpVersion Error - Unknown version" + ver.toString());
    }

    public static SrTrapType convertDSnmpTrapTypeToSrTrapType(SnmpOid trapOid) {
        String strTrapOid = trapOid.getString();
        int pos = strTrapOid.indexOf(".");
        if (pos >= 0) {
            strTrapOid = strTrapOid.substring(0, pos);
        }
        return SrTrapType.getSrTrapType(strTrapOid);
    }

    public static String convertSrTableNameToDSnmpTableName(String tableName) {
        return tableName;
    }

    public static long[] convertMibNameToOidComponents(String mibName, String index) {
        try {
            SnmpOid snmpOid = new SnmpOid();
            StringBuffer buff = new StringBuffer();
            buff.append(mibName).append('.').append(index);
            snmpOid.fromString(buff.toString());
            return snmpOid.toLongArray();
        }
        catch (SnmpValueException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public static String getMIBNameFromOidComponents(long[] comps) {
        return new SnmpOid(comps).getOidInfo().getName();
    }

    public static String getRowIndexFromOidComponents(long[] comps) {
        try {
            return new SnmpOid(comps).getIndexOid().toString();
        }
        catch (SnmpValueException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        catch (SnmpMetadataException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }
}

