/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.comm.snmp;

import com.sanrad.log.DebugLevel;
import com.sanrad.log.LogMgr;
import com.sanrad.log.SrSNMPLogger;
import com.sanrad.nms.server.ServerPropertiesFetcher;
import com.sanrad.nms.server.comm.CommMgr;
import com.sanrad.nms.server.comm.CommVarBind;
import com.sanrad.nms.server.comm.CommVarBindList;
import com.sanrad.nms.server.comm.exception.SrCommunicationException;
import com.sanrad.nms.server.comm.exception.SrSnmpInitException;
import com.sanrad.nms.server.comm.snmp.AbstractSnmpMgr;
import com.sanrad.nms.server.comm.snmp.DsnmpUtil;
import com.sanrad.nms.server.comm.snmp.SnmpAgentParams;
import com.sanrad.nms.server.comm.snmp.SnmpErrorAnalyzer;
import com.sanrad.nms.server.comm.snmp.SnmpVersion;
import com.sanrad.nms.server.comm.snmp.SrOid;
import com.sanrad.nms.server.comm.snmp.SrSnmpTable;
import com.sanrad.nms.server.comm.snmp.SrSnmpVarBind;
import com.sanrad.nms.server.comm.snmp.SrSnmpVarBindList;
import com.sanrad.nms.server.comm.snmp.exception.SnmpInitializationException;
import com.sanrad.nms.server.comm.snmp.exception.SrSnmpConversionException;
import com.sanrad.nms.server.comm.snmp.exception.SrSnmpException;
import com.sanrad.nms.server.comm.snmp.exception.SrSnmpTimeoutException;
import com.sanrad.nms.server.util.CommKey;
import com.sanrad.nms.server.util.types.SrInteger;
import com.sanrad.nms.server.util.types.SrType;
import com.sanrad.util.NetUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;
import monfox.log.Logger;
import monfox.toolkit.snmp.NoSuchObjectException;
import monfox.toolkit.snmp.SnmpException;
import monfox.toolkit.snmp.SnmpFramework;
import monfox.toolkit.snmp.SnmpOid;
import monfox.toolkit.snmp.SnmpValue;
import monfox.toolkit.snmp.SnmpValueException;
import monfox.toolkit.snmp.SnmpVarBind;
import monfox.toolkit.snmp.SnmpVarBindList;
import monfox.toolkit.snmp.ext.SnmpRow;
import monfox.toolkit.snmp.ext.SnmpTable;
import monfox.toolkit.snmp.metadata.SnmpMetadata;
import monfox.toolkit.snmp.metadata.SnmpObjectInfo;
import monfox.toolkit.snmp.metadata.SnmpTableInfo;
import monfox.toolkit.snmp.metadata.SnmpTypeInfo;
import monfox.toolkit.snmp.mgr.SnmpErrorException;
import monfox.toolkit.snmp.mgr.SnmpPeer;
import monfox.toolkit.snmp.mgr.SnmpSession;
import monfox.toolkit.snmp.mgr.SnmpTimeoutException;

public class DefaultSnmpMgr
extends AbstractSnmpMgr {
    private static final int MAX_GET_BULK_REPETITION = 1000;
    protected SnmpSession session = null;
    private SnmpPeer peer = null;
    public static SnmpMetadata metaData = null;
    private InetAddress manager = null;

    public DefaultSnmpMgr(SnmpAgentParams agentParams, char agentIndex) throws SnmpInitializationException {
        super(agentParams, agentIndex);
        this.initPeer();
    }

    private void initPeer() throws SnmpInitializationException {
        try {
            this.peer = new SnmpPeer(this.mgrParams.getIpAddress().toString(), this.mgrParams.getSnmpPort().intValue());
            this.peer.setMaxRetries(this.mgrParams.getNumberOfRetries().intValue());
            this.peer.setTimeout(this.mgrParams.getTimeout().longValue());
            this.peer.setParameters(DsnmpUtil.getdsnmpVsrsion(this.mgrParams.getSnmpVersion()), this.mgrParams.getReadCommunity().toString(), this.mgrParams.getWriteCommunity().toString(), this.mgrParams.getInfoCommunity().toString());
            this.session = this.createDefaultSnmpSession();
        }
        catch (Exception e) {
            StringBuffer msg = new StringBuffer("Failed to init SNMP Manager ");
            msg.append(this.mgrParams.getIpAddress().toDisplayString());
            msg.append(" Error: ");
            msg.append(e.getMessage());
            LogMgr.getServerLog().error(msg.toString(), e);
            throw new SnmpInitializationException(msg.toString());
        }
    }

    public Object getSnmpPeer() {
        return this.peer;
    }

    public String getAgentIpAddress() {
        return this.peer.getAddress().getHostAddress();
    }

    public String getAgentHostname() {
        return this.peer.getHostName();
    }

    public int getSnmpPort() {
        return this.peer.getPort();
    }

    public String getReadCommunity() {
        return this.peer.getParameters().getReadProfile().getSecurityName();
    }

    public String getWriteCommunity() {
        return this.peer.getParameters().getWriteProfile().getSecurityName();
    }

    public String getInfoCommunity() {
        return this.peer.getParameters().getInformProfile().getSecurityName();
    }

    public int getRetries() {
        return this.peer.getMaxRetries();
    }

    public long getTimeout() {
        return this.peer.getTimeout();
    }

    public SnmpVersion getSnmpVersion() {
        return SnmpVersion.getVersion(String.valueOf(this.peer.getParameters().getDefaultProfile().getSnmpVersion()));
    }

    public void setAgentHostname(String hostname) {
        throw new UnsupportedOperationException("Cannot set new Host Name to the agent");
    }

    public void setSnmpPort(int port) throws SnmpInitializationException {
        SrInteger oldPort = this.mgrParams.getSnmpPort();
        this.mgrParams.setSnmpPort(new SrInteger(port));
        try {
            this.initPeer();
        }
        catch (Exception ex) {
            this.mgrParams.setSnmpPort(oldPort);
            LogMgr.getServerLog().debug(ex);
            throw new SnmpInitializationException("Failed to change SNMP Management port of " + this.mgrParams.getIpAddress().toDisplayString() + " to Port: " + port);
        }
    }

    public void setReadCommunity(String community) throws SrSnmpException {
        this.peer.setParameters(this.peer.getParameters().getDefaultProfile().getSnmpVersion(), community, this.getWriteCommunity(), this.getInfoCommunity());
    }

    public void setWriteCommunity(String community) throws SrSnmpException {
        this.peer.setParameters(this.peer.getParameters().getDefaultProfile().getSnmpVersion(), this.getReadCommunity(), community, this.getInfoCommunity());
    }

    public void setInfoCommunity(String community) throws SrSnmpException {
        this.peer.setParameters(this.peer.getParameters().getDefaultProfile().getSnmpVersion(), this.getReadCommunity(), this.getWriteCommunity(), community);
    }

    public void setRetries(int retries) throws SrSnmpException {
        this.peer.setMaxRetries(retries);
    }

    public void setSnmpVersion(SnmpVersion version) throws SrSnmpException {
        this.peer.setParameters(DsnmpUtil.getdsnmpVsrsion(version), this.getReadCommunity(), this.getWriteCommunity(), this.getInfoCommunity());
    }

    public void setTimeout(long timeout) throws SrSnmpException {
        this.peer.setTimeout(timeout);
    }

    public CommVarBindList[] snmpGetBulkList() {
        return null;
    }

    public CommVarBind snmpGetNext() {
        return null;
    }

    public CommVarBindList snmpGetNextList() {
        return null;
    }

    public void snmpSendTrap(String enterprise, String Mgrhost, int genericType, int specificType, long uptime, String[] values) {
    }

    public void snmpSetList(CommVarBindList values) throws SrSnmpException {
        SnmpVarBind varBind;
        int i;
        SnmpVarBindList snmpList = new SnmpVarBindList();
        for (i = 0; i < values.size(); ++i) {
            if (!(values.elementAt(i) instanceof SrSnmpVarBind)) continue;
            varBind = DsnmpUtil.convertSrSnmpVarBindToDSnmpVarBInd((SrSnmpVarBind)values.elementAt(i));
            snmpList.add(varBind);
        }
        if (snmpList.size() == 0) {
            return;
        }
        try {
            for (i = 0; i < snmpList.size(); ++i) {
                varBind = snmpList.get(i);
                String oid = varBind.getOid().getString();
                if (!varBind.getValueString().equals("") || !oid.startsWith("srManagerWriteCommunity") && !oid.startsWith("srManagerReadCommunity")) continue;
                String debugMsg = varBind.getValueString() + " is empty!!!! (class: " + this.getClass() + ")";
                System.err.println(debugMsg);
                Thread.dumpStack();
            }
            this.session.performSet(this.peer, snmpList);
        }
        catch (SnmpTimeoutException e) {
            throw new SrSnmpTimeoutException(e.getMessage() + " SNMP Set Operation failed after Timeout IP:" + this.peer.getAddress().getHostAddress(), this.snmpAgentIndex);
        }
        catch (SnmpErrorException e) {
            SnmpErrorAnalyzer.getInstance().analyzeSNMPException(e, snmpList, this);
        }
        catch (SnmpException e) {
            SnmpErrorAnalyzer.getInstance().analyzeSNMPException(e, snmpList, this);
        }
        LogMgr.getServerLog().debug("SNMP: " + this.getAgentIpAddress() + " set list: " + snmpList.toString());
    }

    public void snmpSet(CommVarBind value) throws SrSnmpException {
        CommVarBindList list = new CommVarBindList();
        list.add(value);
        this.snmpSetList(list);
    }

    public SrSnmpVarBind snmpGet(CommVarBind val) throws SrSnmpException {
        CommVarBindList list = new CommVarBindList();
        list.add(val);
        SrSnmpVarBindList newList = this.snmpGetList(list);
        return (SrSnmpVarBind)newList.get(0);
    }

    public SrSnmpVarBindList snmpGetList(CommVarBindList list) throws SrSnmpException {
        SrSnmpVarBindList newList = null;
        SnmpVarBindList snmpList = new SnmpVarBindList();
        for (int i = 0; i < list.size(); ++i) {
            if (!(list.elementAt(i) instanceof SrSnmpVarBind)) continue;
            SnmpVarBind varBind = DsnmpUtil.convertSrSnmpVarBindToDSnmpVarBInd((SrSnmpVarBind)list.elementAt(i));
            snmpList.add(varBind);
        }
        SnmpVarBindList result = null;
        try {
            result = this.session.performGet(this.peer, snmpList);
        }
        catch (SnmpTimeoutException e) {
            LogMgr.getServerLog().error(e.getMessage() + " - " + list.toString() + "IP: " + this.peer.getAddress().getHostAddress());
            throw new SrSnmpTimeoutException("SNMP GetList Operation failed after Timeout IP:" + this.peer.getAddress().getHostAddress(), this.snmpAgentIndex);
        }
        catch (SnmpErrorException e) {
            LogMgr.getServerLog().debug((Exception)((Object)e));
            SnmpErrorAnalyzer.getInstance().analyzeSNMPException(e, snmpList, this);
        }
        catch (SnmpException e) {
            LogMgr.getServerLog().debug((Exception)((Object)e));
            SnmpErrorAnalyzer.getInstance().analyzeSNMPException(e, snmpList, this);
        }
        newList = DsnmpUtil.convertDSnmpVarBindListToSrSnmpVarBindList(result);
        LogMgr.getServerLog().debug("SNMP: " + this.getAgentIpAddress() + " get list: " + snmpList.toString());
        return newList;
    }

    public CommVarBindList[] snmpGetBulk(CommVarBindList vbList) throws SrSnmpException {
        String msg;
        String[] oidList = new String[vbList.size()];
        CommVarBind vb = null;
        int i = 0;
        Enumeration e = vbList.elements();
        while (e.hasMoreElements()) {
            vb = (CommVarBind)e.nextElement();
            if (!(vb instanceof SrSnmpVarBind)) continue;
            oidList[i++] = ((SrOid)vb.getVarBindKey()).getOid();
        }
        if (i == 0) {
            return null;
        }
        SnmpVarBindList[] tableRowsFromGetBulk = new SnmpVarBindList[]{};
        try {
            SnmpVarBindList getBulkOidList = new SnmpVarBindList(oidList);
            tableRowsFromGetBulk = this.session.performBulkGetAllInstances(this.peer, getBulkOidList, 1000);
        }
        catch (SnmpTimeoutException e2) {
            String msg2 = "SNMP Get Bulk Operation failed after Timeout IP:" + this.peer.getAddress().getHostAddress();
            throw new SrSnmpTimeoutException(msg2, this.snmpAgentIndex);
        }
        catch (SnmpErrorException e3) {
            msg = "SNMP Get Bulk Operation failed. IP: " + this.peer.getAddress().getHostAddress();
            LogMgr.getServerLog().debug(msg, (Exception)((Object)e3));
        }
        catch (SnmpException e4) {
            msg = "SNMP Get Bulk Operation failed. IP: " + this.peer.getAddress().getHostAddress();
            LogMgr.getServerLog().debug(msg, (Exception)((Object)e4));
        }
        int len = tableRowsFromGetBulk.length;
        CommVarBindList[] srTable = new SrSnmpVarBindList[len];
        for (i = 0; i < len; ++i) {
            SnmpVarBindList thisRow = tableRowsFromGetBulk[i];
            SrSnmpVarBindList srList = DsnmpUtil.convertDSnmpVarBindListToSrSnmpVarBindList(thisRow);
            srTable[i] = srList;
        }
        return srTable;
    }

    public CommVarBindList[] snmpGetBulkByKeyPrefix(CommVarBindList vbList, String keyPrefix) throws SrSnmpException {
        CommVarBindList[] getBulkAllEntries = this.snmpGetBulk(vbList);
        Vector<CommVarBindList> getBulkByPrefix = new Vector<CommVarBindList>();
        for (int index = 0; index < getBulkAllEntries.length; ++index) {
            CommVarBindList currVarBindList = getBulkAllEntries[index];
            CommVarBind firstVarBind = (CommVarBind)currVarBindList.elementAt(0);
            String varBindOid = firstVarBind.getVarBindKey().getIndex();
            if (!(varBindOid + ".").startsWith(keyPrefix + ".")) continue;
            getBulkByPrefix.add(currVarBindList);
        }
        CommVarBindList[] getBulkPrefixEntries = new CommVarBindList[getBulkByPrefix.size()];
        for (int index = 0; index < getBulkByPrefix.size(); ++index) {
            getBulkPrefixEntries[index] = (CommVarBindList)getBulkByPrefix.elementAt(index);
        }
        return getBulkPrefixEntries;
    }

    public CommVarBindList[] snmpGetTable(CommVarBindList vbList) throws SrSnmpException {
        String msg;
        String[] oidList = new String[vbList.size()];
        CommVarBind vb = null;
        int i = 0;
        Enumeration e = vbList.elements();
        while (e.hasMoreElements()) {
            vb = (CommVarBind)e.nextElement();
            if (!(vb instanceof SrSnmpVarBind)) continue;
            oidList[i++] = ((SrOid)vb.getVarBindKey()).getOid();
        }
        if (i == 0) {
            return null;
        }
        SnmpVarBindList[] tableRows = new SnmpVarBindList[]{};
        Object retVal = null;
        try {
            SnmpVarBindList tableOidList = new SnmpVarBindList(oidList);
            tableRows = this.session.performBulkGetAllInstances(tableOidList, 1000);
        }
        catch (SnmpTimeoutException e2) {
            LogMgr.getServerLog().error(e2.getMessage());
            String msg2 = "SNMP Get Table Operation failed after Timeout IP:" + this.peer.getAddress().getHostAddress();
            throw new SrSnmpTimeoutException(msg2, this.snmpAgentIndex);
        }
        catch (SnmpErrorException e3) {
            msg = "SNMP Get Table Operation failed. IP: " + this.peer.getAddress().getHostAddress();
            LogMgr.getServerLog().debug(msg, (Exception)((Object)e3));
        }
        catch (SnmpException e4) {
            msg = "SNMP Get Table Operation failed. IP: " + this.peer.getAddress().getHostAddress();
            LogMgr.getServerLog().debug(msg, (Exception)((Object)e4));
        }
        int len = tableRows.length;
        CommVarBindList[] srTable = new SrSnmpVarBindList[len];
        for (i = 0; i < len; ++i) {
            SnmpVarBindList thisRow = tableRows[i];
            SrSnmpVarBindList srList = DsnmpUtil.convertDSnmpVarBindListToSrSnmpVarBindList(thisRow);
            srTable[i] = srList;
        }
        return srTable;
    }

    public SrSnmpTable getTableRef(String tableName) {
        try {
            String dSnmpTableName = DsnmpUtil.convertSrTableNameToDSnmpTableName(tableName);
            SnmpTable table = new SnmpTable(this.peer, dSnmpTableName);
            return new SrSnmpTable(table, table.getName());
        }
        catch (SnmpValueException e) {
            LogMgr.getServerLog().debug((Exception)((Object)e));
            throw new SrSnmpConversionException("Cannot get Table reference for table: " + tableName + "IP:" + this.peer.getAddress().getHostAddress());
        }
    }

    public void snmpRefreshTable(SrSnmpTable table) throws SrSnmpException {
        try {
            ((SnmpTable)table.getTable()).performUpdate(this.session);
        }
        catch (SnmpTimeoutException e) {
            LogMgr.getServerLog().error(e.getMessage());
            throw new SrSnmpTimeoutException("SNMP Get Operation failed after Timeout IP:" + this.peer.getAddress().getHostAddress(), this.snmpAgentIndex);
        }
        catch (SnmpErrorException e) {
            LogMgr.getServerLog().debug((Exception)((Object)e));
            SnmpErrorAnalyzer.getInstance().analyzeTableException(e, table.getName(), this);
        }
        catch (SnmpException e) {
            LogMgr.getServerLog().debug((Exception)((Object)e));
            SnmpErrorAnalyzer.getInstance().analyzeTableException(e, table.getName(), this);
        }
    }

    private CommVarBindList[] convertSnmpTable(SnmpTable table) throws SrSnmpException {
        CommVarBindList[] srTable = null;
        try {
            table.performUpdate(this.session);
            LogMgr.getServerLog().debug("Get table: " + table.getName() + " Agent is: " + this.peer.getAddress().getHostAddress() + " Number of Rows: " + table.getRowCount());
        }
        catch (SnmpTimeoutException e) {
            LogMgr.getServerLog().error(e.getMessage());
            throw new SrSnmpTimeoutException("SNMP Get Operation failed after Timeout IP:" + this.peer.getAddress().getHostAddress(), this.snmpAgentIndex);
        }
        catch (SnmpErrorException e) {
            if (e.getMessage().indexOf("Snmp Error(status=tooBig") == -1) {
                LogMgr.getServerLog().debug((Exception)((Object)e));
            }
            SnmpErrorAnalyzer.getInstance().analyzeTableException(e, table.getName(), this);
        }
        catch (SnmpException e) {
            LogMgr.getServerLog().debug((Exception)((Object)e));
            SnmpErrorAnalyzer.getInstance().analyzeTableException(e, table.getName(), this);
        }
        int len = table.getRowCount();
        srTable = new CommVarBindList[len];
        for (int i = 0; i < len; ++i) {
            SnmpRow row = table.getRow(i);
            srTable[i] = DsnmpUtil.convertDSnmpRowToSrSnmpRow(row);
            row.setNotificationMask(0);
            srTable[i].setSnmpAgentIndex(this.snmpAgentIndex);
        }
        return srTable;
    }

    public CommVarBindList snmpGetTableRow(SrSnmpTable table, CommKey rowIndex) {
        SrSnmpVarBindList varBindList = null;
        SnmpOid index = null;
        try {
            index = new SnmpOid(rowIndex.getKey());
        }
        catch (SnmpValueException e) {
            LogMgr.getServerLog().debug((Exception)((Object)e));
            throw new SrSnmpConversionException("Failed to get row " + index + " from table " + table.getName());
        }
        SnmpRow row = ((SnmpTable)table.getTable()).getRow(index);
        varBindList = DsnmpUtil.convertDSnmpRowToSrSnmpRow(row);
        return varBindList;
    }

    public CommVarBindList[] filterTableRowsByValue(SrSnmpTable table, String columnName, SrType value) {
        CommVarBindList[] srRows = null;
        try {
            SnmpValue val = DsnmpUtil.convertSrTypeToDSnmpValue(value, columnName);
            SnmpRow row = ((SnmpTable)table.getTable()).getRow(columnName, val);
            Vector<SnmpRow> rows = new Vector<SnmpRow>(1);
            if (row != null) {
                rows.addElement(row);
            }
            srRows = new CommVarBindList[rows.size()];
            for (int i = 0; i < srRows.length; ++i) {
                srRows[i] = DsnmpUtil.convertDSnmpRowToSrSnmpRow((SnmpRow)rows.get(i));
            }
        }
        catch (NoSuchObjectException e) {
            LogMgr.getServerLog().debug((Exception)((Object)e));
        }
        catch (SnmpValueException e) {
            LogMgr.getServerLog().debug((Exception)((Object)e));
        }
        return srRows;
    }

    public CommVarBindList[] snmpGetTableRowsByFilter(String tableName, String columnName, SrType value, char agentIndex) throws SrCommunicationException {
        SrSnmpTable table = this.getTableRef(tableName);
        table.setAgentIndex(agentIndex);
        CommMgr.getInstance(agentIndex).refreshTable(table);
        return this.filterTableRowsByValue(table, columnName, value);
    }

    public SrSnmpVarBindList snmpGetOneRow(String[] tableNames, CommKey index) throws SrSnmpException {
        String rowIndex = index.getKey();
        try {
            SnmpVarBindList vbList = new SnmpVarBindList();
            for (int j = 0; j < tableNames.length; ++j) {
                SnmpTableInfo tableInfo = metaData.getTable(tableNames[j]);
                SnmpObjectInfo[] columns = tableInfo.getColumns();
                for (int i = 0; i < columns.length; ++i) {
                    SnmpOid oid = new SnmpOid(columns[i].getName() + "." + rowIndex);
                    vbList.add(new SnmpVarBind(oid, null));
                }
            }
            SnmpVarBindList newList = this.session.performGet(vbList);
            SrSnmpVarBindList list = DsnmpUtil.convertDSnmpVarBindListToSrSnmpVarBindList(newList);
            list.setSnmpAgentIndex(this.snmpAgentIndex);
            LogMgr.getServerLog().debug("SNMP: " + this.getAgentIpAddress() + " get one row: " + newList.toString());
            return list;
        }
        catch (SnmpException e) {
            LogMgr.getServerLog().debug((Exception)((Object)e));
            throw new SrSnmpException("Failed to get single row: " + rowIndex + " Table/s: " + tableNames.toString());
        }
    }

    public CommVarBindList[] snmpGetTable(String tableName) throws SrSnmpException {
        SnmpTable table;
        CommVarBindList[] srTable = null;
        String dSnmpTableName = DsnmpUtil.convertSrTableNameToDSnmpTableName(tableName);
        try {
            table = new SnmpTable(this.peer, dSnmpTableName);
        }
        catch (SnmpValueException e) {
            LogMgr.getServerLog().debug((Exception)((Object)e));
            throw new SrSnmpConversionException("Failed to create SNMP Table instance for " + tableName);
        }
        srTable = this.convertSnmpTable(table);
        return srTable;
    }

    public boolean equals(Object otherMgr) {
        if (otherMgr instanceof DefaultSnmpMgr) {
            return this.getSnmpPeer().equals(((DefaultSnmpMgr)otherMgr).getSnmpPeer());
        }
        return false;
    }

    private void setSnmpSession() {
        if (this.manager == null) {
            int port = -1;
            try {
                port = NetUtil.getRandomFreePort();
            }
            catch (IOException ioe) {
                LogMgr.getServerLog().fatal("No free port found to bind snmp session due to: " + ioe.getMessage(), ioe);
            }
            if (port > -1) {
                SnmpSession tempSession = null;
                InetAddress[] addrs = ServerPropertiesFetcher.getHostAddressList();
                for (int i = 0; i < addrs.length; ++i) {
                    tempSession = this.createSnmpSession(port, addrs[i]);
                    if (tempSession == null || !this.checkConnectivity(tempSession, addrs[i])) continue;
                    this.manager = addrs[i];
                    break;
                }
                if (tempSession != null) {
                    tempSession.shutdown();
                }
            }
        }
    }

    private boolean checkConnectivity(SnmpSession session, InetAddress addr) {
        try {
            String[] snmpList = new String[]{"sysUpTime.0"};
            session.performGet(this.peer, snmpList);
            return true;
        }
        catch (SnmpTimeoutException ste) {
            String hostAddr = addr == null ? "[Default Snmp Session]" : addr.getHostAddress();
            LogMgr.getServerLog().debug("Failed to connect to " + this.getAgentHostname() + " with snmp session ip " + hostAddr);
        }
        catch (SnmpException se) {
            LogMgr.getServerLog().debug((Exception)((Object)se));
        }
        return false;
    }

    private SnmpSession createDefaultSnmpSession() {
        SnmpSession session = null;
        try {
            LogMgr.getServerLog().debug("Trying to open a default SnmpSession");
            session = new SnmpSession(this.peer);
            SnmpSession.getDefaultConfig().setReuseRequestIds(true);
            LogMgr.getServerLog().debug("Opening a default SnmpSession succeeded");
        }
        catch (SnmpException se) {
            LogMgr.getServerLog().debug("Failed to create SnmpSession. Due to: " + se.getMessage(), (Exception)((Object)se));
        }
        return session;
    }

    private SnmpSession createSnmpSession(int port, InetAddress addr) {
        SnmpSession session = null;
        try {
            LogMgr.getServerLog().debug("Trying to bind SnmpSession to " + addr + ":" + port);
            session = new SnmpSession(this.peer, port, addr);
            LogMgr.getServerLog().debug("Bind SnmpSession to " + addr + ":" + port + " succeeded");
        }
        catch (SnmpException se) {
            LogMgr.getServerLog().debug("Failed to bind SnmpSession to " + addr + ":" + port + ". Due to: " + se.getMessage(), (Exception)((Object)se));
        }
        return session;
    }

    public String getManagerIpAddress() {
        if (this.manager == null) {
            this.setSnmpSession();
        }
        return this.manager == null ? null : this.manager.getHostAddress();
    }

    static {
        try {
            URL url = SnmpAgentParams.getMibDataFileURL();
            if (url == null) {
                // empty if block
            }
            InputStream is = url.openStream();
            metaData = SnmpMetadata.loadXML((InputStream)is, null);
            SnmpFramework.setMetadata((SnmpMetadata)metaData);
            SnmpTypeInfo iNetAddressInfo = metaData.getType("InetAddress");
            iNetAddressInfo.setDisplayHint("1d.1d.1d.1d");
        }
        catch (IOException e) {
            LogMgr.getServerLog().debug(e);
            throw new SrSnmpInitException("Mibs File not found!!!");
        }
        catch (SnmpException e) {
            LogMgr.getServerLog().debug((Exception)((Object)e));
            throw new SrSnmpInitException("Error occured while trying to load metadata files");
        }
        if (LogMgr.getServerLog().getLowestDebugLevel().equals(DebugLevel.DEBUG) || LogMgr.getServerLog().getLowestDebugLevel().equals(DebugLevel.INFO)) {
            try {
                SrSNMPLogger.SrProvider p = new SrSNMPLogger.SrProvider("log/snmp.log");
                p.enableAll();
                Logger.setProvider((Logger.Provider)p);
            }
            catch (IOException ioe) {
                LogMgr.getServerLog().warning(ioe);
            }
        }
    }
}

