/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.comm.database;

import com.sanrad.log.LogMgr;
import com.sanrad.nms.server.comm.CommVarBind;
import com.sanrad.nms.server.comm.CommVarBindList;
import com.sanrad.nms.server.comm.database.DBConnection;
import com.sanrad.nms.server.comm.database.DBItem;
import com.sanrad.nms.server.comm.database.DBVarBindList;
import com.sanrad.nms.server.comm.database.XmlDBConnection;
import com.sanrad.nms.server.comm.database.exception.SrDatabaseException;
import com.sanrad.nms.server.util.ParameterCode;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Properties;
import java.util.StringTokenizer;

public class DatabaseManager {
    private static DatabaseManager theInstance = new DatabaseManager();
    public static final String dbIpDelimiter = ";";
    private static final String VSWITCH_PROPERTIES_FILE = "vSwitch.properties";
    public static final String USER_PSW = "users.dat";
    private DBConnection dbConnection = this.getDBConnection();

    private DatabaseManager() {
    }

    public static DatabaseManager getInstance() {
        return theInstance;
    }

    private DBConnection getDBConnection() {
        return new XmlDBConnection();
    }

    public void setObjectToFile(String fileName, Serializable obj) throws SrDatabaseException {
        FileOutputStream file = null;
        try {
            file = new FileOutputStream(fileName);
        }
        catch (FileNotFoundException e) {
            LogMgr.getServerLog().debug(e);
            throw new SrDatabaseException("Failed to open DBFile " + fileName + ". File may be in use by other application");
        }
        ObjectOutputStream out = null;
        try {
            out = new ObjectOutputStream(file);
            out.writeObject(obj);
            out.flush();
            out.close();
        }
        catch (IOException ioe) {
            LogMgr.getServerLog().debug(ioe);
            try {
                out.close();
            }
            catch (Exception e) {
                LogMgr.getServerLog().warning("Cannot close file: " + fileName, e);
            }
            throw new SrDatabaseException("Failed to save data to DBFile " + fileName + "Error: " + ioe.getMessage());
        }
    }

    public Object getObjectFromFile(String fileName) throws SrDatabaseException, InvalidClassException {
        FileInputStream file = null;
        try {
            file = new FileInputStream(fileName);
        }
        catch (FileNotFoundException e) {
            LogMgr.getServerLog().debug("Failed to open DBFile " + fileName + "Error message: " + e.getMessage());
        }
        Object obj = null;
        if (file != null) {
            try {
                ObjectInputStream in = new ObjectInputStream(file);
                obj = in.readObject();
                in.close();
            }
            catch (InvalidClassException e) {
                LogMgr.getServerLog().debug(e);
                throw e;
            }
            catch (IOException e) {
                LogMgr.getServerLog().debug(e);
                throw new SrDatabaseException("Failed to read object from DB file: " + fileName);
            }
            catch (ClassNotFoundException e) {
                LogMgr.getServerLog().debug(e);
                throw new SrDatabaseException("Failed to read from file. Date corrupted: " + fileName);
            }
        }
        return obj;
    }

    public CommVarBindList[] readAlarmEmailContact(Integer clusterId) throws SrDatabaseException {
        return this.dbConnection.readAlarmEmailContact(clusterId);
    }

    public CommVarBindList[] readAlarmTypesFromDb(Integer clusterId) throws SrDatabaseException {
        return this.dbConnection.readAlarmTypesFromDb(clusterId);
    }

    public CommVarBindList[] readClustersDataFromDb() throws SrDatabaseException {
        return this.dbConnection.readClustersDataFromDb();
    }

    public CommVarBindList[] readSitesDataFromDb() throws SrDatabaseException {
        return this.dbConnection.readSitesDataFromDb();
    }

    public CommVarBindList[] readVSwitchDataFromDb() throws SrDatabaseException {
        return this.dbConnection.readVSwitchDataFromDb();
    }

    public void writeClusterDataToDb(CommVarBindList values) throws SrDatabaseException {
        this.dbConnection.writeClusterDataToDb(values);
    }

    public void writeSiteDataToDb(CommVarBindList values) throws SrDatabaseException {
        this.dbConnection.writeSiteDataToDb(values);
    }

    public CommVarBindList[] readVSwitchDataFromDb(Integer clusterId) throws SrDatabaseException {
        return this.dbConnection.readVSwitchDataFromDb(clusterId);
    }

    public void addCluster(CommVarBindList values) throws SrDatabaseException {
        this.dbConnection.addCluster(values);
    }

    public void addSite(CommVarBindList values) throws SrDatabaseException {
        this.dbConnection.addSite(values);
    }

    public void setAlarmTypeData(CommVarBindList values) throws SrDatabaseException {
        String typeName = (String)values.getValue(ParameterCode.ALARM_TYPE_NAME).value();
        Boolean emailEnabled = (Boolean)values.getValue(ParameterCode.ALARM_TYPE_EMAIL).value();
        this.dbConnection.writeAlarmTypeDataToDb(null, typeName, emailEnabled);
    }

    public void setContactData(CommVarBindList values) throws SrDatabaseException {
        String fromAddress = (String)values.getValue(ParameterCode.EMAIL_CONTACT_FROM_ADDRESS).value();
        String toAddresses = (String)values.getValue(ParameterCode.EMAIL_CONTACT_TO_ADDRESS).value();
        String smtpHost = (String)values.getValue(ParameterCode.EMAIL_CONTACT_SMTP_HOST).value();
        String smtpUser = (String)values.getValue(ParameterCode.EMAIL_CONTACT_SMTP_USER).value();
        String smtpPassword = (String)values.getValue(ParameterCode.EMAIL_CONTACT_SMTP_PASSWORD).value();
        this.dbConnection.writeContactDataToDb(null, fromAddress, toAddresses, smtpHost, smtpUser, smtpPassword);
    }

    public void addVSwitch(CommVarBindList values) throws SrDatabaseException {
        this.dbConnection.addVSwitch(values);
    }

    public void removeVSwitch(String ipToRemove) throws SrDatabaseException {
        this.dbConnection.removeVSwitch(ipToRemove);
    }

    public void removeCluster(Integer vSwitchGroupId) throws SrDatabaseException {
        this.dbConnection.removeCluster(vSwitchGroupId);
    }

    public void removeSite(Integer vSwitchGroupId) throws SrDatabaseException {
        this.dbConnection.removeSite(vSwitchGroupId);
    }

    public void dbSetList(CommVarBindList values) throws SrDatabaseException {
        this.dbConnection.writeVSwitchDataToDb(values);
    }

    public void dbSet(CommVarBind value) throws SrDatabaseException {
        CommVarBindList list = new CommVarBindList();
        list.add(value);
        this.dbSetList(list);
    }

    public DBVarBindList dbGetList(CommVarBindList list) throws SrDatabaseException {
        return this.dbConnection.dbGetList(list);
    }

    private void putValueFromOldDatabase(HashMap values, DBItem key, String ip, Properties oldDBValues) {
        String value = oldDBValues.getProperty(key.toString() + "." + ip);
        values.put(key, value);
    }

    private HashMap getVlauesOfVSwitchFromOldDatabase(String ip, Properties oldDBValues) {
        HashMap values = new HashMap();
        this.putValueFromOldDatabase(values, DBItem.VSWITCH_READ_COMMUNITY, ip, oldDBValues);
        this.putValueFromOldDatabase(values, DBItem.VSWITCH_IP_MASK, ip, oldDBValues);
        this.putValueFromOldDatabase(values, DBItem.VSWITCH_SNMP_PORT, ip, oldDBValues);
        this.putValueFromOldDatabase(values, DBItem.VSWITCH_TRAP_PORT, ip, oldDBValues);
        this.putValueFromOldDatabase(values, DBItem.VSWITCH_SNMP_VERSION, ip, oldDBValues);
        this.putValueFromOldDatabase(values, DBItem.VSWITCH_TIMEOUT, ip, oldDBValues);
        this.putValueFromOldDatabase(values, DBItem.VSWITCH_RETRIES, ip, oldDBValues);
        this.putValueFromOldDatabase(values, DBItem.VSWITCH_WRITE_COMMUNITY, ip, oldDBValues);
        return values;
    }

    private void convertOldDatabaseToNewDatabase(Properties oldDBValues) throws SrDatabaseException {
        String ip = oldDBValues.getProperty(DBItem.VSWITCH_IP_ADDRESS.toString());
        StringTokenizer tokens = new StringTokenizer(ip, dbIpDelimiter);
        String[] ips = new String[tokens.countTokens()];
        HashMap[] newDBValues = new HashMap[ips.length];
        int i = 0;
        while (tokens.hasMoreTokens()) {
            ips[i] = tokens.nextToken();
            newDBValues[i] = new HashMap();
            newDBValues[i].put(DBItem.VSWITCH_IP_ADDRESS, ips[i]);
            ++i;
        }
        for (i = 0; i < ips.length; ++i) {
            HashMap values = this.getVlauesOfVSwitchFromOldDatabase(ips[i], oldDBValues);
            newDBValues[i].putAll(values);
        }
        this.dbConnection.writeToNewDatabase(newDBValues);
    }

    public void convertOldDatabaseToNewDatabaseAndDeleteOldFile() {
        String oldFileName = VSWITCH_PROPERTIES_FILE;
        Properties oldDBValues = new Properties();
        try {
            File oldFile = new File(oldFileName);
            FileInputStream fis = new FileInputStream(oldFile);
            oldDBValues.load(fis);
            this.convertOldDatabaseToNewDatabase(oldDBValues);
            LogMgr.getServerLog().debug("Old database file converted to new database file successfully");
            fis.close();
            if (oldFile.delete()) {
                LogMgr.getServerLog().debug("Old database file was deleted successfully");
            } else {
                LogMgr.getServerLog().debug("Old database file couldn't be deleted");
            }
        }
        catch (FileNotFoundException fne) {
            return;
        }
        catch (IOException e) {
            LogMgr.getServerLog().warning(e);
        }
        catch (SrDatabaseException sde) {
            LogMgr.getServerLog().warning(sde);
        }
    }
}

