/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.comm;

import com.sanrad.log.LogMgr;
import com.sanrad.nms.server.comm.CommVarBind;
import com.sanrad.nms.server.comm.CommVarBindList;
import com.sanrad.nms.server.comm.database.DBItem;
import com.sanrad.nms.server.comm.database.DBVarBind;
import com.sanrad.nms.server.comm.database.DBVarBindList;
import com.sanrad.nms.server.comm.database.DatabaseManager;
import com.sanrad.nms.server.comm.database.exception.SrDatabaseException;
import com.sanrad.nms.server.comm.exception.SrCommunicationException;
import com.sanrad.nms.server.comm.snmp.DefaultSnmpMgr;
import com.sanrad.nms.server.comm.snmp.SnmpAgentParams;
import com.sanrad.nms.server.comm.snmp.SnmpVersion;
import com.sanrad.nms.server.comm.snmp.SrOid;
import com.sanrad.nms.server.comm.snmp.SrSnmpTable;
import com.sanrad.nms.server.comm.snmp.SrSnmpVarBindList;
import com.sanrad.nms.server.comm.snmp.exception.SnmpInitializationException;
import com.sanrad.nms.server.comm.snmp.exception.SrSnmpException;
import com.sanrad.nms.server.comm.snmp.exception.SrSnmpTrapPortIsBusyException;
import com.sanrad.nms.server.comm.snmp.trap.TrapListener;
import com.sanrad.nms.server.comm.snmp.trap.TrapManager;
import com.sanrad.nms.server.mgr.VSwitchConfigurator;
import com.sanrad.nms.server.util.CommKey;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.SnmpCommKey;
import com.sanrad.nms.server.util.types.SrInteger;
import com.sanrad.nms.server.util.types.SrIpAddress;
import com.sanrad.nms.server.util.types.SrLong;
import com.sanrad.nms.server.util.types.SrString;
import com.sanrad.nms.server.util.types.SrType;
import java.io.InvalidClassException;
import java.io.Serializable;
import java.util.HashMap;

public class CommMgr {
    private static CommMgr theInstance = new CommMgr();
    private static DefaultSnmpMgr[] snmpMgrs = null;
    private static HashMap commMgrs = new HashMap();
    public static final char DB_COMM_MGR_KEY = 'z';
    private static DatabaseManager dbMgr = DatabaseManager.getInstance();

    private CommMgr() {
    }

    public static synchronized CommMgr getInstance(char index) {
        CommMgr commMgr = (CommMgr)commMgrs.get(new Character(index));
        if (commMgr == null) {
            commMgrs.put(new Character(index), new CommMgr());
        }
        commMgr = (CommMgr)commMgrs.get(new Character(index));
        return commMgr;
    }

    public synchronized void setList(CommVarBindList varBindsToSet, char snmpAgentIndex) throws SrCommunicationException {
        snmpMgrs[snmpAgentIndex].snmpSetList(varBindsToSet);
        dbMgr.dbSetList(varBindsToSet);
    }

    public synchronized void setSnmpList(CommVarBindList varBindsToSet, char snmpAgentIndex) throws SrCommunicationException {
        snmpMgrs[snmpAgentIndex].snmpSetList(varBindsToSet);
    }

    public synchronized void set(CommVarBind varBind, char snmpAgentIndex) throws SrCommunicationException {
        snmpMgrs[snmpAgentIndex].snmpSet(varBind);
    }

    public synchronized void getList(CommVarBindList list, char snmpAgentIndex) throws SrCommunicationException {
        try {
            DBVarBindList dbList = dbMgr.dbGetList(list);
            list.copyValues(dbList);
        }
        catch (SrDatabaseException e) {
            LogMgr.getServerLog().debug(e);
        }
        if (snmpMgrs[snmpAgentIndex] != null) {
            SrSnmpVarBindList snmpList = snmpMgrs[snmpAgentIndex].snmpGetList(list);
            list.copyValues(snmpList);
            list.setSnmpAgentIndex(snmpAgentIndex);
        }
    }

    public synchronized CommVarBindList[] getListsByKeyPrefix(CommVarBindList list, String keyPrefix, char snmpAgentIndex) throws SrCommunicationException {
        if (list.size() > 0 && snmpMgrs[snmpAgentIndex] != null) {
            return snmpMgrs[snmpAgentIndex].snmpGetBulkByKeyPrefix(list, keyPrefix);
        }
        return null;
    }

    public synchronized void refreshTable(SrSnmpTable tableRef) throws SrCommunicationException {
        char agentIndex = tableRef.getAgentIndex();
        if (snmpMgrs[agentIndex] != null) {
            snmpMgrs[agentIndex].snmpRefreshTable(tableRef);
        }
    }

    public synchronized CommVarBindList[] getAll(String tableName, char snmpAgentIndex) throws SrCommunicationException {
        if (snmpMgrs[snmpAgentIndex] != null) {
            return snmpMgrs[snmpAgentIndex].snmpGetTable(tableName);
        }
        return null;
    }

    public synchronized SrSnmpTable createTableRef(String tableName, char snmpAgentIndex) {
        if (snmpMgrs[snmpAgentIndex] != null) {
            SrSnmpTable table = snmpMgrs[snmpAgentIndex].getTableRef(tableName);
            table.setAgentIndex(snmpAgentIndex);
            return table;
        }
        return null;
    }

    public synchronized CommVarBindList getTableRow(SrSnmpTable table, CommKey rowIndex) throws SrCommunicationException {
        char agentIndex = table.getAgentIndex();
        if (snmpMgrs[agentIndex] != null) {
            CommVarBindList row = snmpMgrs[agentIndex].snmpGetTableRow(table, rowIndex);
            if (row != null) {
                row.setSnmpAgentIndex(agentIndex);
            }
            return row;
        }
        return null;
    }

    public synchronized CommVarBindList getOneRow(String[] tableNames, CommKey index) throws SrCommunicationException {
        char agentIndex = ((SnmpCommKey)index).getSnmpAgentIndex();
        if (snmpMgrs[agentIndex] != null) {
            return snmpMgrs[agentIndex].snmpGetOneRow(tableNames, index);
        }
        return null;
    }

    public synchronized CommVarBindList[] filterTableRowsByValue(SrSnmpTable table, CommVarBind columnValue) throws SrCommunicationException {
        String columnName = ((SrOid)columnValue.getVarBindKey()).getOid();
        SrType value = columnValue.getValue();
        char agentIndex = table.getAgentIndex();
        if (snmpMgrs[agentIndex] != null) {
            CommVarBindList[] rows = snmpMgrs[agentIndex].filterTableRowsByValue(table, columnName, value);
            if (rows != null) {
                for (int i = 0; i < rows.length; ++i) {
                    rows[i].setSnmpAgentIndex(agentIndex);
                }
            }
            return rows;
        }
        return null;
    }

    public synchronized CommVarBindList[] getTableRowsByValue(String tableName, String columnName, SrType value, char agentIndex) throws SrCommunicationException {
        if (snmpMgrs[agentIndex] != null) {
            return snmpMgrs[agentIndex].snmpGetTableRowsByFilter(tableName, columnName, value, agentIndex);
        }
        return null;
    }

    public synchronized void addSite(CommVarBindList newSiteData) {
        try {
            dbMgr.addSite(newSiteData);
        }
        catch (SrDatabaseException e) {
            StringBuffer msg = new StringBuffer("Failed to create new Site ");
            msg.append(" In DB. Error is: ");
            msg.append(e.getMessage());
            LogMgr.getServerLog().debug(msg.toString(), e);
        }
    }

    public synchronized void addCluster(CommVarBindList newClusterData) {
        try {
            dbMgr.addCluster(newClusterData);
        }
        catch (SrDatabaseException e) {
            StringBuffer msg = new StringBuffer("Failed to create new Cluster ");
            msg.append(" In DB. Error is: ");
            msg.append(e.getMessage());
            LogMgr.getServerLog().debug(msg.toString(), e);
        }
    }

    public static synchronized void addSnmpAgent(CommVarBindList newAgentData) throws SnmpInitializationException, SrSnmpException {
        SnmpAgentParams newAgentParams = CommMgr.createSnmpParamsFromCommVarBindList(newAgentData);
        try {
            dbMgr.addVSwitch(newAgentData);
        }
        catch (SrDatabaseException e) {
            StringBuffer msg = new StringBuffer("Failed to create new Snmp Agent ");
            msg.append(newAgentParams.getIpAddress().toDisplayString());
            msg.append(" In DB. Error is: ");
            msg.append(e.getMessage());
            LogMgr.getServerLog().debug(msg.toString(), e);
            throw new SnmpInitializationException("Failed to create new Snmp Agent ");
        }
        int indexForNewAgent = -1;
        if (snmpMgrs == null) {
            snmpMgrs = new DefaultSnmpMgr[1];
            indexForNewAgent = 0;
        } else {
            for (int i = 0; i < snmpMgrs.length; ++i) {
                if (snmpMgrs[i] != null) continue;
                indexForNewAgent = i;
            }
        }
        if (indexForNewAgent == -1) {
            DefaultSnmpMgr[] newArray = new DefaultSnmpMgr[snmpMgrs.length + 1];
            System.arraycopy(snmpMgrs, 0, newArray, 0, snmpMgrs.length);
            indexForNewAgent = snmpMgrs.length;
            snmpMgrs = newArray;
        }
        CommMgr.snmpMgrs[indexForNewAgent] = new DefaultSnmpMgr(newAgentParams, (char)indexForNewAgent);
        newAgentData.setSnmpAgentIndex((char)indexForNewAgent);
        TrapManager.getInstance().createTrapMonitorIfNeeded(newAgentParams.getTrapPort().intValue(), (char)indexForNewAgent, newAgentParams.getIpAddress());
    }

    public synchronized void removeSnmpAgent(char snmpAgentIndex) throws SrCommunicationException {
        DefaultSnmpMgr mgr = snmpMgrs[snmpAgentIndex];
        String ip = mgr.getAgentIpAddress();
        dbMgr.removeVSwitch(ip);
        try {
            commMgrs.remove(new Character(snmpAgentIndex));
            TrapManager.getInstance().removeTrapMonitorIfNeeded(snmpAgentIndex);
            CommMgr.snmpMgrs[snmpAgentIndex] = null;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            LogMgr.getServerLog().debug("Array Error while removing SNMP agent - keep working", e);
        }
    }

    public synchronized void removeSite(Integer vSwitchGroupId) throws SrCommunicationException {
        dbMgr.removeSite(vSwitchGroupId);
    }

    public synchronized void removeCluster(Integer vSwitchGroupId) throws SrCommunicationException {
        dbMgr.removeCluster(vSwitchGroupId);
    }

    public synchronized void changeClusterParams(CommVarBindList params) throws SrCommunicationException {
        dbMgr.writeClusterDataToDb(params);
    }

    public synchronized void changeSiteParams(CommVarBindList params) throws SrCommunicationException {
        dbMgr.writeSiteDataToDb(params);
    }

    public synchronized void changeSnmpAgentParams(CommVarBindList agentNewParams, char agentIndex) throws SrCommunicationException {
        boolean portChangeError = false;
        for (int i = 0; i < agentNewParams.size(); ++i) {
            CommVarBind vb = (CommVarBind)agentNewParams.get(i);
            if (!(vb instanceof DBVarBind)) continue;
            String key = vb.getVarBindKey().getVarBindName();
            SrType value = vb.getValue();
            if (key.equals("Timeout")) {
                snmpMgrs[agentIndex].setTimeout((Long)value.value());
                continue;
            }
            if (key.equals("MaxRetries")) {
                snmpMgrs[agentIndex].setRetries((Integer)value.value());
                continue;
            }
            if (key.equals("SnmpPort")) {
                try {
                    snmpMgrs[agentIndex].setSnmpPort((Integer)value.value());
                }
                catch (SnmpInitializationException e) {
                    LogMgr.getServerLog().debug(e);
                }
                continue;
            }
            if (key.equals("ReadCommunity")) {
                snmpMgrs[agentIndex].setReadCommunity((String)value.value());
                continue;
            }
            if (key.equals("WriteCommunity")) {
                snmpMgrs[agentIndex].setWriteCommunity((String)value.value());
                continue;
            }
            if (key.equals("SnmpVersion")) {
                snmpMgrs[agentIndex].setSnmpVersion((SnmpVersion)value.value());
                continue;
            }
            if (!key.equals("TrapPort")) continue;
            try {
                String ipAddress = snmpMgrs[agentIndex].getAgentIpAddress();
                TrapManager.getInstance().changeTrapPort(agentIndex, (Integer)value.value(), ipAddress);
                continue;
            }
            catch (SrSnmpTrapPortIsBusyException e) {
                LogMgr.getServerLog().debug(e);
                portChangeError = true;
            }
        }
        if (portChangeError) {
            throw new SrSnmpTrapPortIsBusyException("Could not change trap port because trap port is busy");
        }
        dbMgr.dbSetList(agentNewParams);
    }

    public synchronized CommVarBindList[] getAllClustersData() throws SrDatabaseException, SrSnmpTrapPortIsBusyException {
        return dbMgr.readClustersDataFromDb();
    }

    public synchronized CommVarBindList[] getAllSitesData() throws SrDatabaseException, SrSnmpTrapPortIsBusyException {
        return dbMgr.readSitesDataFromDb();
    }

    public synchronized CommVarBindList[] getEmailContactData() throws SrDatabaseException {
        return dbMgr.readAlarmEmailContact(new Integer(0));
    }

    public synchronized CommVarBindList[] getEmailContactData(Integer clusterId) throws SrDatabaseException {
        return dbMgr.readAlarmEmailContact(clusterId);
    }

    public synchronized void setAlarmTypeData(CommVarBindList varBindList) {
        try {
            dbMgr.setAlarmTypeData(varBindList);
        }
        catch (SrDatabaseException dbe) {
            StringBuffer msg = new StringBuffer("Failed to set AlarmType Data ");
            msg.append(" In DB. Error is: ");
            msg.append(dbe.getMessage());
            LogMgr.getServerLog().debug(msg.toString(), dbe);
        }
    }

    public synchronized void setContactData(CommVarBindList varBindList) {
        try {
            dbMgr.setContactData(varBindList);
        }
        catch (SrDatabaseException dbe) {
            StringBuffer msg = new StringBuffer("Failed to set contact Data ");
            msg.append(" In DB. Error is: ");
            msg.append(dbe.getMessage());
            LogMgr.getServerLog().debug(msg.toString(), dbe);
        }
    }

    public synchronized CommVarBindList[] getAllAlarmTypesData() throws SrDatabaseException {
        return dbMgr.readAlarmTypesFromDb(new Integer(0));
    }

    public synchronized CommVarBindList[] getAllAlarmTypesData(Integer clusterId) throws SrDatabaseException {
        return dbMgr.readAlarmTypesFromDb(clusterId);
    }

    public static synchronized void getAllvSwitchesData(VSwitchConfigurator.VSwitchDataContainer data) throws SrDatabaseException, SrSnmpTrapPortIsBusyException {
        CommMgr.getAllvSwitchesData((String)null, data);
    }

    private static void initVSwitchList(CommVarBindList[] vSwitchList, VSwitchConfigurator.VSwitchDataContainer data) throws SrDatabaseException, SrSnmpTrapPortIsBusyException {
        data.setVSwitchesData(vSwitchList);
        HashMap<SrIpAddress, SrInteger> trapPortErrorData = new HashMap<SrIpAddress, SrInteger>();
        snmpMgrs = new DefaultSnmpMgr[vSwitchList.length];
        for (int i = 0; i < vSwitchList.length; ++i) {
            SnmpAgentParams snmpParams = CommMgr.createSnmpParamsFromCommVarBindList(vSwitchList[i]);
            try {
                CommMgr.snmpMgrs[i] = new DefaultSnmpMgr(snmpParams, (char)i);
                vSwitchList[i].setSnmpAgentIndex((char)i);
            }
            catch (SnmpInitializationException initE) {
                LogMgr.getServerLog().debug(initE);
                data.setVSwitchDataNull(i);
                continue;
            }
            try {
                int trapPort = TrapManager.getInstance().createTrapMonitorIfNeeded(snmpParams.getTrapPort().intValue(), (char)i, snmpParams.getIpAddress());
                vSwitchList[i].setValue(ParameterCode.VSWITCH_TRAP_UDP_PORT, new SrInteger(trapPort));
                continue;
            }
            catch (SrSnmpException stpibe) {
                LogMgr.getServerLog().debug(new StringBuffer(stpibe.getMessage()));
                trapPortErrorData.put(snmpParams.getIpAddress(), snmpParams.getTrapPort());
            }
        }
        if (trapPortErrorData.size() > 0) {
            throw new SrSnmpTrapPortIsBusyException(trapPortErrorData);
        }
    }

    public static synchronized void getAllvSwitchesData(Integer clusterId, VSwitchConfigurator.VSwitchDataContainer data) throws SrDatabaseException, SrSnmpTrapPortIsBusyException {
        CommVarBindList[] vSwitchesList = dbMgr.readVSwitchDataFromDb(clusterId);
        CommMgr.initVSwitchList(vSwitchesList, data);
    }

    private static void getAllvSwitchesData(String dbFileName, VSwitchConfigurator.VSwitchDataContainer data) throws SrDatabaseException, SrSnmpTrapPortIsBusyException {
        CommVarBindList[] vSwitchesList = dbMgr.readVSwitchDataFromDb();
        CommMgr.initVSwitchList(vSwitchesList, data);
    }

    private static SnmpAgentParams createSnmpParamsFromCommVarBindList(CommVarBindList vbs) {
        int dataIndex = vbs.indexOf(DBItem.VSWITCH_IP_ADDRESS);
        SrIpAddress ip = (SrIpAddress)((DBVarBind)vbs.get(dataIndex)).getValue();
        SnmpAgentParams newAgentParams = new SnmpAgentParams(ip);
        dataIndex = vbs.indexOf(DBItem.VSWITCH_IP_MASK);
        newAgentParams.setIpMask((SrIpAddress)((DBVarBind)vbs.get(dataIndex)).getValue());
        dataIndex = vbs.indexOf(DBItem.VSWITCH_READ_COMMUNITY);
        newAgentParams.setReadCommunity((SrString)((DBVarBind)vbs.get(dataIndex)).getValue());
        dataIndex = vbs.indexOf(DBItem.VSWITCH_RETRIES);
        newAgentParams.setNumberOfRetries((SrInteger)((DBVarBind)vbs.get(dataIndex)).getValue());
        dataIndex = vbs.indexOf(DBItem.VSWITCH_SNMP_PORT);
        newAgentParams.setSnmpPort((SrInteger)((DBVarBind)vbs.get(dataIndex)).getValue());
        dataIndex = vbs.indexOf(DBItem.VSWITCH_SNMP_VERSION);
        newAgentParams.setSnmpVersion((SnmpVersion)((DBVarBind)vbs.get(dataIndex)).getValue());
        dataIndex = vbs.indexOf(DBItem.VSWITCH_TIMEOUT);
        newAgentParams.setTimeout((SrLong)((DBVarBind)vbs.get(dataIndex)).getValue());
        dataIndex = vbs.indexOf(DBItem.VSWITCH_TRAP_PORT);
        newAgentParams.setTrapPort((SrInteger)((DBVarBind)vbs.get(dataIndex)).getValue());
        dataIndex = vbs.indexOf(DBItem.VSWITCH_WRITE_COMMUNITY);
        newAgentParams.setWriteCommunity((SrString)((DBVarBind)vbs.get(dataIndex)).getValue());
        return newAgentParams;
    }

    public synchronized void setToFile(String fileName, Serializable obj) throws SrCommunicationException {
        dbMgr.setObjectToFile(fileName, obj);
    }

    public static synchronized void addTrapListenerToAllMonitors(TrapListener listener) {
        TrapManager.getInstance().addTrapListenerToAllMonitors(listener);
    }

    public synchronized Object loadFromFile(String fileName) throws SrCommunicationException, InvalidClassException {
        return dbMgr.getObjectFromFile(fileName);
    }

    public static synchronized char getSnmpMgrIndex(DefaultSnmpMgr mngr) {
        for (int i = 0; i < snmpMgrs.length; ++i) {
            if (snmpMgrs[i] != mngr) continue;
            return (char)i;
        }
        return '\u0100';
    }

    public synchronized CommVarBindList[] snmpGetTable(CommVarBindList varBindsList, char snmpAgentIndex) throws SrSnmpException {
        if (snmpMgrs[snmpAgentIndex] != null) {
            return snmpMgrs[snmpAgentIndex].snmpGetTable(varBindsList);
        }
        return null;
    }

    public synchronized CommVarBindList[] snmpGetBulk(CommVarBindList varBindsList, char snmpAgentIndex) throws SrSnmpException {
        if (snmpMgrs[snmpAgentIndex] != null) {
            return snmpMgrs[snmpAgentIndex].snmpGetBulk(varBindsList);
        }
        return null;
    }

    public synchronized String getManagerIpAddress(int snmpAgentIndex) {
        return snmpMgrs == null || snmpMgrs[snmpAgentIndex] == null ? null : snmpMgrs[snmpAgentIndex].getManagerIpAddress();
    }
}

