/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.alarm.vswitch;

import com.sanrad.nms.server.alarm.Alarm;
import com.sanrad.nms.server.alarm.AlarmGenerator;
import com.sanrad.nms.server.alarm.AlarmType;
import com.sanrad.nms.server.logic.GeneralLogicObject;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.hardware.HardwareImpl;
import com.sanrad.nms.server.logic.vswitch.InterfaceTableRow;
import com.sanrad.nms.server.logic.vswitch.SFPConnectedInterfaceImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.Parameter;
import com.sanrad.nms.server.util.ParameterCode;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Vector;

public class VSwitchAlarmGenerator
extends AlarmGenerator {
    private static VSwitchAlarmGenerator theInstance = new VSwitchAlarmGenerator();

    private VSwitchAlarmGenerator() {
    }

    public static VSwitchAlarmGenerator getInstance() {
        return theInstance;
    }

    public Vector checkForAlarmsToOpen(GeneralLogicObject source, VSwitch vSwitch) throws RemoteException {
        HardwareImpl hardware;
        VSwitch otherVSwitch;
        VSwitchImpl vSwitchSource = (VSwitchImpl)source;
        Vector openAlarms = super.checkForAlarmsToOpen(source, vSwitch);
        if (!vSwitchSource.isConnected()) {
            StringBuffer msg = new StringBuffer(vSwitchSource.getClassId().toString());
            msg.append(" ");
            msg.append(vSwitchSource.getName());
            msg.append(" is disconnected");
            this.addAlarm(openAlarms, AlarmType.VSWITCH_DISCONNECTED, source, vSwitchSource, msg.toString());
        }
        if (vSwitchSource.isUnderTakeover() && (otherVSwitch = ((ClusterImpl)vSwitchSource.getCluster()).getOtherVSwitch(vSwitchSource)) != null) {
            StringBuffer msg = new StringBuffer(vSwitchSource.getClassId().toString());
            msg.append(" ");
            msg.append(vSwitchSource.getName());
            msg.append(" has taken over the volumes of the ");
            msg.append(otherVSwitch.getClassId());
            msg.append(" ");
            msg.append(otherVSwitch.getName());
            this.addAlarm(openAlarms, AlarmType.VSWITCH_TAKEOVER, source, vSwitchSource, msg.toString());
        }
        Vector linkDownInterfaces = vSwitchSource.getLinkDownInterfaces();
        Enumeration e = linkDownInterfaces.elements();
        while (e.hasMoreElements()) {
            InterfaceTableRow inter = (InterfaceTableRow)e.nextElement();
            StringBuffer msg = new StringBuffer(vSwitchSource.getClassId().toString());
            msg.append(" ");
            msg.append(vSwitchSource.getName());
            msg.append(".  The ");
            msg.append(inter.getClassId());
            msg.append(" ");
            msg.append(inter.getAlias());
            msg.append(" is down");
            this.addAlarm(openAlarms, AlarmType.LINK_DOWN, source, vSwitchSource, msg.toString(), inter);
        }
        if (vSwitchSource.is3800() || vSwitchSource.is3400()) {
            Vector mismatchSpeedSFPInterfaces = vSwitchSource.getMismatchSpeedSFPInterfaces();
            Enumeration e2 = mismatchSpeedSFPInterfaces.elements();
            while (e2.hasMoreElements()) {
                SFPConnectedInterfaceImpl sfpConnectedInterface = (SFPConnectedInterfaceImpl)e2.nextElement();
                BigInteger interfaceSpeed = sfpConnectedInterface.getHighSpeed();
                Integer connectorSpeed = sfpConnectedInterface.getConnectedSFPSpeed();
                StringBuffer msg = new StringBuffer(vSwitchSource.getClassId().toString());
                msg.append(" ");
                msg.append(vSwitchSource.getName());
                msg.append(". The SFP connector bit rate of ");
                msg.append(sfpConnectedInterface.getClassId());
                msg.append(sfpConnectedInterface.getAlias());
                msg.append(" (");
                msg.append(connectorSpeed * 100);
                msg.append(" Mbit) is different then the interface bit rate (");
                msg.append(interfaceSpeed);
                msg.append(" Mbit)");
                this.addAlarm(openAlarms, AlarmType.SFP_SPEED_MISMATCH, source, vSwitchSource, msg.toString(), sfpConnectedInterface);
            }
        }
        if (vSwitchSource.isConnected() && (hardware = (HardwareImpl)vSwitchSource.getHardware()) != null) {
            StringBuffer msg;
            if (hardware.isFanFaulty()) {
                msg = new StringBuffer(ClassID.VSWITCH.toString());
                msg.append(" ");
                msg.append(vSwitchSource.getName());
                msg.append(". Only two fans are working");
                this.addAlarm(openAlarms, AlarmType.HARDWARE_FAN_FAULTY, source, msg.toString());
            }
            if (hardware.isFanCritical()) {
                msg = new StringBuffer(ClassID.VSWITCH.toString());
                msg.append(" ");
                msg.append(vSwitchSource.getName());
                msg.append(". Only one fan is working");
                this.addAlarm(openAlarms, AlarmType.HARDWARE_FAN_CRITICAL, source, msg.toString());
            }
            if (hardware.isPowerSupplyFaulty()) {
                msg = new StringBuffer(ClassID.VSWITCH.toString());
                msg.append(" ");
                msg.append(vSwitchSource.getName());
                msg.append(". Only one power supply is working");
                this.addAlarm(openAlarms, AlarmType.HARDWARE_POWER_SUPPLY_FAULTY, source, msg.toString());
            }
            if (hardware.isCPUTempWarning()) {
                msg = new StringBuffer(ClassID.VSWITCH.toString());
                msg.append(" ");
                msg.append(vSwitchSource.getName());
                msg.append(". The CPU temperature ");
                msg.append(hardware.getCPUTemp().toString());
                msg.append(vSwitchSource.getTempUnits().toString());
                msg.append(" crossed the threshold of acceptable temperature (above ");
                msg.append(hardware.getCPUWarningTempThresh().toString());
                msg.append(vSwitchSource.getTempUnits());
                msg.append(")");
                this.addAlarm(openAlarms, AlarmType.HARDWARE_CPU_TEMP_WARNING, source, msg.toString());
            }
            if (hardware.isOnBoardTempWarning()) {
                msg = new StringBuffer(ClassID.VSWITCH.toString());
                msg.append(" ");
                msg.append(vSwitchSource.getName());
                msg.append(". The on-board temperature ");
                msg.append(hardware.getOnBoardTemp().toString());
                msg.append(vSwitchSource.getTempUnits().toString());
                msg.append(" crossed the threshold of acceptable temperature (above ");
                msg.append(hardware.getOnBoardWarningTempThresh().toString());
                msg.append(vSwitchSource.getTempUnits());
                msg.append(")");
                this.addAlarm(openAlarms, AlarmType.HARDWARE_ON_BOARD_TEMP_WARNING, source, msg.toString());
            }
            if (hardware.isCPUTempCritical()) {
                msg = new StringBuffer(ClassID.VSWITCH.toString());
                msg.append(" ");
                msg.append(vSwitchSource.getName());
                msg.append(". The CPU temperature ");
                msg.append(hardware.getCPUTemp().toString());
                msg.append(vSwitchSource.getTempUnits().toString());
                msg.append(" crossed the threshold of acceptable temperature (above ");
                msg.append(hardware.getCPUFactoryTempThresh().toString());
                msg.append(vSwitchSource.getTempUnits());
                msg.append(")");
                this.addAlarm(openAlarms, AlarmType.HARDWARE_CPU_TEMP_CRITICAL, source, msg.toString());
            }
            if (hardware.isOnBoardTempCritical()) {
                msg = new StringBuffer(ClassID.VSWITCH.toString());
                msg.append(" ");
                msg.append(vSwitchSource.getName());
                msg.append(", the on-board temperature ");
                msg.append(hardware.getOnBoardTemp().toString());
                msg.append(vSwitchSource.getTempUnits().toString());
                msg.append(" crossed the threshold of acceptable temperature (above ");
                msg.append(hardware.getOnBoardFactoryTempThresh().toString());
                msg.append(vSwitchSource.getTempUnits());
                msg.append(")");
                this.addAlarm(openAlarms, AlarmType.HARDWARE_ON_BOARD_TEMP_CRITICAL, source, msg.toString());
            }
            if (hardware.isNoFan()) {
                msg = new StringBuffer(ClassID.VSWITCH.toString());
                msg.append(" ");
                msg.append(vSwitchSource.getName());
                msg.append(". No fan is working");
                this.addAlarm(openAlarms, AlarmType.HARDWARE_NO_FAN, source, msg.toString());
            }
        }
        openAlarms = this.hasBadValues(openAlarms, source, vSwitch);
        return openAlarms;
    }

    protected Vector hasBadValues(Vector openAlarms, GeneralLogicObject source, VSwitch vSwitch) throws RemoteException {
        openAlarms = super.hasBadValues(openAlarms, source, vSwitch);
        VSwitchImpl vSwitchSource = (VSwitchImpl)source;
        Vector badValues = vSwitchSource.getParametersBadValue(vSwitchSource);
        if (badValues != null) {
            Enumeration e = badValues.elements();
            while (e.hasMoreElements()) {
                Parameter parameter = (Parameter)e.nextElement();
                if (!parameter.getCode().equals(ParameterCode.VSWITCH_TRAP_UDP_PORT)) continue;
                StringBuffer msg = new StringBuffer(vSwitchSource.getClassId().toString());
                msg.append(" ");
                msg.append(vSwitchSource.getName());
                msg.append(" trap port ");
                msg.append(vSwitchSource.getTrapPort());
                msg.append(" is already in use.  Change the trap port in ");
                msg.append(ClassID.VSWITCH);
                msg.append(" -> Properties -> SNMP to receive traps from this ");
                msg.append(vSwitchSource.getClassId());
                this.addAlarm(openAlarms, AlarmType.VSWITCH_TRAP_PORT_IS_IN_USE, source, vSwitchSource, msg.toString());
            }
        }
        return openAlarms;
    }

    public Vector checkForAlarmsToClose(GeneralLogicObject source, VSwitch vSwitch, Vector openAlarms) throws RemoteException {
        VSwitchImpl vSwitchSource = (VSwitchImpl)source;
        Vector closeAlarms = super.checkForAlarmsToClose(source, vSwitch, openAlarms);
        Enumeration e = openAlarms.elements();
        while (e.hasMoreElements()) {
            HardwareImpl hardware;
            Alarm alarm = (Alarm)e.nextElement();
            if (alarm.getType().equals(AlarmType.VSWITCH_DISCONNECTED)) {
                if (!vSwitchSource.isConnected()) continue;
                closeAlarms.addElement(alarm);
                continue;
            }
            if (alarm.getType().equals(AlarmType.VSWITCH_TAKEOVER)) {
                if (vSwitchSource.isUnderTakeover()) continue;
                closeAlarms.addElement(alarm);
                continue;
            }
            if (alarm.getType().equals(AlarmType.LINK_DOWN)) {
                Vector linkDownInterfaces = vSwitchSource.getLinkDownInterfaces();
                if (linkDownInterfaces.contains(alarm.getAdditionalKeyObject())) continue;
                closeAlarms.addElement(alarm);
                continue;
            }
            if ((vSwitchSource.is3800() || vSwitchSource.is3400()) && alarm.getType().equals(AlarmType.SFP_SPEED_MISMATCH)) {
                Vector interfaces = vSwitchSource.getMismatchSpeedSFPInterfaces();
                if (interfaces.contains(alarm.getAdditionalKeyObject())) continue;
                closeAlarms.addElement(alarm);
                continue;
            }
            if (alarm.getType().equals(AlarmType.VSWITCH_TRAP_PORT_IS_IN_USE)) {
                Vector badValues = vSwitchSource.getParametersBadValue(vSwitchSource);
                boolean close = true;
                if (badValues != null) {
                    Enumeration iter = badValues.elements();
                    while (iter.hasMoreElements()) {
                        Parameter parameter = (Parameter)iter.nextElement();
                        if (!parameter.getCode().equals(ParameterCode.VSWITCH_TRAP_UDP_PORT)) continue;
                        close = false;
                        break;
                    }
                }
                if (!close) continue;
                closeAlarms.addElement(alarm);
                continue;
            }
            if (alarm.getType().equals(AlarmType.HARDWARE_CPU_TEMP_WARNING)) {
                hardware = (HardwareImpl)vSwitchSource.getHardware();
                if (hardware == null || hardware.isCPUTempWarning()) continue;
                closeAlarms.addElement(alarm);
                continue;
            }
            if (alarm.getType().equals(AlarmType.HARDWARE_CPU_TEMP_CRITICAL)) {
                hardware = (HardwareImpl)vSwitchSource.getHardware();
                if (hardware == null || hardware.isCPUTempCritical()) continue;
                closeAlarms.addElement(alarm);
                continue;
            }
            if (alarm.getType().equals(AlarmType.HARDWARE_FAN_FAULTY)) {
                hardware = (HardwareImpl)vSwitchSource.getHardware();
                if (hardware == null || hardware.isFanFaulty()) continue;
                closeAlarms.addElement(alarm);
                continue;
            }
            if (alarm.getType().equals(AlarmType.HARDWARE_FAN_CRITICAL)) {
                hardware = (HardwareImpl)vSwitchSource.getHardware();
                if (hardware == null || hardware.isFanCritical()) continue;
                closeAlarms.addElement(alarm);
                continue;
            }
            if (alarm.getType().equals(AlarmType.HARDWARE_ON_BOARD_TEMP_WARNING)) {
                hardware = (HardwareImpl)vSwitchSource.getHardware();
                if (hardware == null || hardware.isOnBoardTempWarning()) continue;
                closeAlarms.addElement(alarm);
                continue;
            }
            if (alarm.getType().equals(AlarmType.HARDWARE_ON_BOARD_TEMP_CRITICAL)) {
                hardware = (HardwareImpl)vSwitchSource.getHardware();
                if (hardware == null || hardware.isOnBoardTempCritical()) continue;
                closeAlarms.addElement(alarm);
                continue;
            }
            if (alarm.getType().equals(AlarmType.HARDWARE_POWER_SUPPLY_FAULTY)) {
                hardware = (HardwareImpl)vSwitchSource.getHardware();
                if (hardware == null || hardware.isPowerSupplyFaulty()) continue;
                closeAlarms.addElement(alarm);
                continue;
            }
            if (!alarm.getType().equals(AlarmType.HARDWARE_NO_FAN) || (hardware = (HardwareImpl)vSwitchSource.getHardware()) == null || hardware.isNoFan()) continue;
            closeAlarms.addElement(alarm);
        }
        return closeAlarms;
    }

    protected boolean isRedundant(GeneralLogicObject source) throws RemoteException {
        return true;
    }
}

