/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.alarm.vswitch;

import com.sanrad.nms.server.alarm.Alarm;
import com.sanrad.nms.server.alarm.AlarmGenerator;
import com.sanrad.nms.server.alarm.AlarmType;
import com.sanrad.nms.server.logic.GeneralLogicObject;
import com.sanrad.nms.server.logic.vswitch.NeighborImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Vector;

public class NeighborAlarmGenerator
extends AlarmGenerator {
    private static NeighborAlarmGenerator theInstance = new NeighborAlarmGenerator();

    private NeighborAlarmGenerator() {
    }

    public static NeighborAlarmGenerator getInstance() {
        return theInstance;
    }

    public Vector checkForAlarmsToOpen(GeneralLogicObject source, VSwitch vSwitch) throws RemoteException {
        StringBuffer msg;
        NeighborImpl neighbor = (NeighborImpl)source;
        Vector openAlarms = super.checkForAlarmsToOpen(source, vSwitch);
        if (neighbor.isDead()) {
            msg = new StringBuffer(vSwitch.getClassId().toString());
            msg.append(" ");
            msg.append(vSwitch.getName());
            msg.append(" lost connection with neighbor ");
            msg.append(source.toString());
            this.addAlarm(openAlarms, AlarmType.NEIGH_DEAD, source, msg.toString());
        }
        if (neighbor.isSuspicious()) {
            msg = new StringBuffer(vSwitch.getClassId().toString());
            msg.append(" ");
            msg.append(vSwitch.getName());
            msg.append(" suspects a lost connection with neighbor ");
            msg.append(source.toString());
            this.addAlarm(openAlarms, AlarmType.NEIGH_SUSP, source, msg.toString());
        }
        if (neighbor.isUnknown()) {
            msg = new StringBuffer(vSwitch.getClassId().toString());
            msg.append(" ");
            msg.append(vSwitch.getName());
            msg.append(".  State of the neighbor ");
            msg.append(source.toString());
            msg.append(" is unknown");
            this.addAlarm(openAlarms, AlarmType.NEIGH_UNK, source, msg.toString());
        }
        return openAlarms;
    }

    public Vector checkForAlarmsToClose(GeneralLogicObject source, VSwitch vSwitch, Vector openAlarms) throws RemoteException {
        NeighborImpl neighbor = (NeighborImpl)source;
        Vector closeAlarms = super.checkForAlarmsToClose(source, vSwitch, openAlarms);
        Enumeration e = openAlarms.elements();
        while (e.hasMoreElements()) {
            Alarm alarm = (Alarm)e.nextElement();
            if (alarm.getType().equals(AlarmType.NEIGH_DEAD)) {
                if (neighbor.isDead()) continue;
                closeAlarms.addElement(alarm);
                continue;
            }
            if (alarm.getType().equals(AlarmType.NEIGH_SUSP)) {
                if (neighbor.isSuspicious()) continue;
                closeAlarms.addElement(alarm);
                continue;
            }
            if (!alarm.getType().equals(AlarmType.NEIGH_UNK) || neighbor.isUnknown()) continue;
            closeAlarms.addElement(alarm);
        }
        return closeAlarms;
    }

    protected boolean isRedundant(GeneralLogicObject source) throws RemoteException {
        return true;
    }
}

