/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.alarm.volume;

import com.sanrad.nms.server.alarm.Alarm;
import com.sanrad.nms.server.alarm.AlarmType;
import com.sanrad.nms.server.alarm.AliasObjectAlarmGenerator;
import com.sanrad.nms.server.logic.GeneralLogicObject;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.volume.SnapshotVolumeImpl;
import com.sanrad.nms.server.logic.volume.VolumeImpl;
import com.sanrad.nms.server.logic.volume.copy.CopyOperationManagerImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.util.ClassID;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Vector;

public abstract class VolumeAlarmGenerator
extends AliasObjectAlarmGenerator {
    protected VolumeAlarmGenerator() {
    }

    public Vector checkForAlarmsToOpen(GeneralLogicObject source, VSwitch vSwitch) throws RemoteException {
        StringBuffer msg;
        VolumeImpl volume = (VolumeImpl)source;
        Vector openAlarms = super.checkForAlarmsToOpen(source, vSwitch);
        if (volume.isInternal(vSwitch)) {
            this.msg = this.getDefaultMessage(source, vSwitch);
            this.msg.append(" is not exposed");
            this.addAlarm(openAlarms, AlarmType.VOLUME_INTERNAL, source, vSwitch, this.msg.toString());
        }
        if (volume.isNeedSync(vSwitch)) {
            msg = new StringBuffer(vSwitch.getClassId().toString());
            msg.append(" ");
            msg.append(vSwitch.getName());
            msg.append(". Mirror child ");
            msg.append(source.getClassId());
            msg.append(" ");
            msg.append(source.toString());
            msg = this.getDefaultMessage(source, vSwitch);
            msg.append(" needs to be synchronized with one of its siblings.");
            this.addAlarm(openAlarms, AlarmType.VOLUME_NEED_SYNC, source, vSwitch, msg.toString());
        }
        if (volume.isMismatch(vSwitch)) {
            msg = new StringBuffer(vSwitch.getClassId().toString());
            msg.append(" ");
            msg.append(vSwitch.getName());
            msg.append(source.getClassId());
            msg.append(" ");
            msg.append(source.toString());
            msg = this.getDefaultMessage(source, vSwitch);
            msg.append(" is mismatch .");
            this.addAlarm(openAlarms, AlarmType.MISMATCH, source, vSwitch, msg.toString());
        }
        if (volume.isNonValidate(vSwitch)) {
            msg = new StringBuffer(vSwitch.getClassId().toString());
            msg.append(" ");
            msg.append(vSwitch.getName());
            msg.append(source.getClassId());
            msg.append(" ");
            msg.append(source.toString());
            msg = this.getDefaultMessage(source, vSwitch);
            msg.append(" is non validated .");
            this.addAlarm(openAlarms, AlarmType.NON_VALIDATE, source, vSwitch, msg.toString());
        }
        if (volume.isNonFunctional(vSwitch) && !volume.isDROfflineLocalCopy()) {
            this.msg = this.getDefaultMessage(source, vSwitch);
            this.msg.append(" is not functioning");
            this.addAlarm(openAlarms, AlarmType.VOLUME_NON_FUNC, source, vSwitch, this.msg.toString());
        }
        if (volume.isIllegal()) {
            this.msg = this.getDefaultMessage(source, vSwitch);
            this.msg.append(" is configured inconsistently in the cluster");
            this.addAlarm(openAlarms, AlarmType.VOLUME_ILLEGAL, source, this.msg.toString());
        }
        if (volume.isInconsistent()) {
            msg = new StringBuffer(source.getClassId().toString());
            msg.append(" ");
            msg.append(volume);
            msg.append(" number of children is inconsistent in the cluster.  Synchronize the cluster");
            this.addAlarm(openAlarms, AlarmType.VOLUME_INCONSISTENT, source, msg.toString());
        }
        if (volume.isSnapshotSource() && volume.isExposed()) {
            if (volume.isExposed()) {
                Vector snapshots;
                VSwitch exposedOnVSwitch = volume.getExposedOnVSwitch();
                String exposedOn = null;
                if (exposedOnVSwitch != null) {
                    exposedOn = exposedOnVSwitch.getName();
                }
                if ((snapshots = volume.getSnapshotsIfSource()) != null) {
                    Enumeration e = snapshots.elements();
                    while (e.hasMoreElements()) {
                        String snapshotExposedOn;
                        SnapshotVolumeImpl snapshot = (SnapshotVolumeImpl)e.nextElement();
                        if (!snapshot.isExposed() || (snapshotExposedOn = snapshot.getExposedOnVSwitch().getName()).equals(exposedOn)) continue;
                        this.msg = this.getDefaultMessage(volume, vSwitch);
                        this.msg.append(" is exposed on a different ");
                        this.msg.append(ClassID.VSWITCH);
                        this.msg.append(" than its ");
                        this.msg.append(snapshot.getClassId());
                        this.msg.append(" ");
                        this.msg.append(snapshot);
                        this.msg.append(" (");
                        this.msg.append(exposedOn);
                        this.msg.append(", ");
                        this.msg.append(snapshotExposedOn);
                        this.msg.append(")");
                        this.addAlarm(openAlarms, AlarmType.SNAPSHOT_EXPOSED_INCONSISTENT, source, this.msg.toString(), snapshot);
                    }
                }
            }
            if (((CopyOperationManagerImpl)((ClusterImpl)volume.getCluster()).getCopyOperManager()).isInvolvedInActiveRestoreOperation(volume)) {
                this.msg = this.getDefaultMessage(vSwitch);
                this.msg.append("Roll back operation for ");
                this.msg.append(volume.getClassId());
                this.msg.append(" ");
                this.msg.append(volume.getAlias(vSwitch));
                this.msg.append(" in progress.");
                this.addAlarm(openAlarms, AlarmType.VOLUME_OPER, (GeneralLogicObject)volume, vSwitch, this.msg.toString());
            }
        }
        return openAlarms;
    }

    public Vector checkForAlarmsToClose(GeneralLogicObject source, VSwitch vSwitch, Vector openAlarms) throws RemoteException {
        VolumeImpl volume = (VolumeImpl)source;
        Vector closeAlarms = super.checkForAlarmsToClose(source, vSwitch, openAlarms);
        Enumeration e = openAlarms.elements();
        while (e.hasMoreElements()) {
            Alarm alarm = (Alarm)e.nextElement();
            if (alarm.getType().equals(AlarmType.VOLUME_INTERNAL)) {
                if (volume.isInternal(vSwitch)) continue;
                closeAlarms.addElement(alarm);
                continue;
            }
            if (alarm.getType().equals(AlarmType.VOLUME_NEED_SYNC)) {
                if (volume.isNeedSync(vSwitch)) continue;
                closeAlarms.addElement(alarm);
                continue;
            }
            if (alarm.getType().equals(AlarmType.MISMATCH)) {
                if (volume.isMismatch(vSwitch)) continue;
                closeAlarms.addElement(alarm);
                continue;
            }
            if (alarm.getType().equals(AlarmType.NON_VALIDATE)) {
                if (volume.isNonValidate(vSwitch)) continue;
                closeAlarms.addElement(alarm);
                continue;
            }
            if (alarm.getType().equals(AlarmType.VOLUME_NON_FUNC)) {
                if (volume.isNonFunctional(vSwitch)) continue;
                closeAlarms.addElement(alarm);
                continue;
            }
            if (alarm.getType().equals(AlarmType.VOLUME_ILLEGAL)) {
                if (volume.isIllegal()) continue;
                closeAlarms.addElement(alarm);
                continue;
            }
            if (alarm.getType().equals(AlarmType.VOLUME_INCONSISTENT)) {
                if (volume.isInconsistent()) continue;
                closeAlarms.addElement(alarm);
                continue;
            }
            if (alarm.getType().equals(AlarmType.SNAPSHOT_EXPOSED_INCONSISTENT)) {
                Vector snapshots = volume.getSnapshotsIfSource();
                if (snapshots == null) continue;
                Enumeration iter = snapshots.elements();
                while (iter.hasMoreElements()) {
                    SnapshotVolumeImpl snapshot = (SnapshotVolumeImpl)iter.nextElement();
                    if (!snapshot.equals(alarm.getAdditionalKeyObject())) continue;
                    closeAlarms.addElement(alarm);
                }
                continue;
            }
            if (!alarm.getType().equals(AlarmType.VOLUME_OPER) || ((CopyOperationManagerImpl)((ClusterImpl)volume.getCluster()).getCopyOperManager()).isInvolvedInActiveRestoreOperation(volume)) continue;
            closeAlarms.addElement(alarm);
        }
        return closeAlarms;
    }
}

