/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.alarm.volume;

import com.sanrad.nms.server.alarm.Alarm;
import com.sanrad.nms.server.alarm.AlarmType;
import com.sanrad.nms.server.alarm.volume.VirtualVolumeAlarmGenerator;
import com.sanrad.nms.server.logic.GeneralLogicObject;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.volume.SnapshotVolumeImpl;
import com.sanrad.nms.server.logic.volume.VolumeNode;
import com.sanrad.nms.server.logic.volume.copy.CopyOperationManagerImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Vector;

public class SnapshotAlarmGenerator
extends VirtualVolumeAlarmGenerator {
    private static SnapshotAlarmGenerator theInstance = new SnapshotAlarmGenerator();

    private SnapshotAlarmGenerator() {
    }

    public static SnapshotAlarmGenerator getInstance() {
        return theInstance;
    }

    public Vector checkForAlarmsToOpen(GeneralLogicObject source, VSwitch vSwitch) throws RemoteException {
        SnapshotVolumeImpl volume = (SnapshotVolumeImpl)source;
        Vector openAlarms = super.checkForAlarmsToOpen(source, vSwitch);
        if (volume.isFull(vSwitch)) {
            VolumeNode snapSource = volume.getSourceVolume();
            this.msg = this.getDefaultMessage(source, vSwitch);
            this.msg.append(" is not synchronized with its source ");
            this.msg.append(snapSource.getClassId());
            this.msg.append(" ");
            this.msg.append(snapSource.getAlias());
            this.msg.append(" because it is full");
            this.addAlarm(openAlarms, AlarmType.SNAPSHOT_IS_FULL, source, vSwitch, this.msg.toString());
        } else if (volume.isOutOfSync()) {
            VolumeNode snapSource = volume.getSourceVolume();
            this.msg = this.getDefaultMessage(source, vSwitch);
            this.msg.append(" is not synchronized with its source ");
            this.msg.append(snapSource.getClassId());
            this.msg.append(" ");
            this.msg.append(snapSource.getAlias());
            this.addAlarm(openAlarms, AlarmType.SNAPSHOT_VOLUME_OUT_OF_SYNC, source, vSwitch, this.msg.toString());
        } else if (volume.isOverUsed(vSwitch)) {
            int thresh = volume.getPercentageThreshold(vSwitch);
            this.msg = this.getDefaultMessage(source, vSwitch);
            this.msg.append(" has exceeded its threshold [");
            this.msg.append(thresh);
            this.msg.append("%]");
            this.addAlarm(openAlarms, AlarmType.OVER_USED_SNAPSHOT, source, vSwitch, this.msg.toString());
        } else if (((CopyOperationManagerImpl)((ClusterImpl)volume.getCluster()).getCopyOperManager()).isInvolvedInActiveRestoreOperation(volume)) {
            this.msg = this.getDefaultMessage(vSwitch);
            this.msg.append("Roll back operation for ");
            this.msg.append(volume.getClassId());
            this.msg.append(" ");
            this.msg.append(volume.getAlias(vSwitch));
            this.msg.append(" in progress.");
            this.addAlarm(openAlarms, AlarmType.VOLUME_OPER, (GeneralLogicObject)volume, vSwitch, this.msg.toString());
        }
        if (volume.isModified(vSwitch)) {
            this.msg = this.getDefaultMessage(source, vSwitch);
            this.msg.append(" has been modified");
            this.addAlarm(openAlarms, AlarmType.SNAPSHOT_VOLUME_MODIFIED, source, vSwitch, this.msg.toString());
        }
        return openAlarms;
    }

    public Vector checkForAlarmsToClose(GeneralLogicObject source, VSwitch vSwitch, Vector openAlarms) throws RemoteException {
        SnapshotVolumeImpl volume = (SnapshotVolumeImpl)source;
        Vector closeAlarms = super.checkForAlarmsToClose(source, vSwitch, openAlarms);
        Enumeration e = openAlarms.elements();
        while (e.hasMoreElements()) {
            Alarm alarm = (Alarm)e.nextElement();
            if (alarm.getType().equals(AlarmType.OVER_USED_SNAPSHOT)) {
                if (volume.isOverUsed(vSwitch) && !volume.isFull(vSwitch)) continue;
                closeAlarms.addElement(alarm);
                continue;
            }
            if (alarm.getType().equals(AlarmType.SNAPSHOT_VOLUME_OUT_OF_SYNC)) {
                if (volume.isOutOfSync(vSwitch) && !volume.isFull(vSwitch)) continue;
                closeAlarms.addElement(alarm);
                continue;
            }
            if (alarm.getType().equals(AlarmType.SNAPSHOT_VOLUME_MODIFIED)) {
                if (volume.isModified(vSwitch)) continue;
                closeAlarms.addElement(alarm);
                continue;
            }
            if (alarm.getType().equals(AlarmType.SNAPSHOT_IS_FULL)) {
                if (volume.isFull(vSwitch)) continue;
                closeAlarms.addElement(alarm);
                continue;
            }
            if (!alarm.getType().equals(AlarmType.VOLUME_OPER) || ((CopyOperationManagerImpl)((ClusterImpl)volume.getCluster()).getCopyOperManager()).isInvolvedInActiveRestoreOperation(volume)) continue;
            closeAlarms.addElement(alarm);
        }
        return closeAlarms;
    }
}

