/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.alarm.volume;

import com.sanrad.nms.server.alarm.Alarm;
import com.sanrad.nms.server.alarm.AlarmType;
import com.sanrad.nms.server.alarm.volume.VirtualVolumeAlarmGenerator;
import com.sanrad.nms.server.logic.GeneralLogicObject;
import com.sanrad.nms.server.logic.volume.MirrorVolumeImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Vector;

public class MirrorVolumeAlarmGenerator
extends VirtualVolumeAlarmGenerator {
    private static MirrorVolumeAlarmGenerator theInstance = new MirrorVolumeAlarmGenerator();

    private MirrorVolumeAlarmGenerator() {
    }

    public static MirrorVolumeAlarmGenerator getInstance() {
        return theInstance;
    }

    public Vector checkForAlarmsToOpen(GeneralLogicObject source, VSwitch vSwitch) throws RemoteException {
        MirrorVolumeImpl volume = (MirrorVolumeImpl)source;
        Vector openAlarms = super.checkForAlarmsToOpen(source, vSwitch);
        if (!volume.isMirrorMirroring(vSwitch)) {
            this.msg = this.getDefaultMessage(source, vSwitch);
            this.msg.append(" is not mirroring the data");
            this.addAlarm(openAlarms, AlarmType.MIR_NOT_MIR, source, vSwitch, this.msg.toString());
        }
        return openAlarms;
    }

    public Vector checkForAlarmsToClose(GeneralLogicObject source, VSwitch vSwitch, Vector openAlarms) throws RemoteException {
        MirrorVolumeImpl volume = (MirrorVolumeImpl)source;
        Vector closeAlarms = super.checkForAlarmsToClose(source, vSwitch, openAlarms);
        Enumeration e = openAlarms.elements();
        while (e.hasMoreElements()) {
            Alarm alarm = (Alarm)e.nextElement();
            if (!alarm.getType().equals(AlarmType.MIR_NOT_MIR) || !volume.isMirrorMirroring(vSwitch)) continue;
            closeAlarms.addElement(alarm);
        }
        return closeAlarms;
    }
}

