/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.alarm.volume;

import com.sanrad.nms.server.alarm.Alarm;
import com.sanrad.nms.server.alarm.AlarmType;
import com.sanrad.nms.server.alarm.volume.VirtualVolumeAlarmGenerator;
import com.sanrad.nms.server.logic.GeneralLogicObject;
import com.sanrad.nms.server.logic.volume.JournalVolumeImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Vector;

public class JournalAlarmGenerator
extends VirtualVolumeAlarmGenerator {
    private static JournalAlarmGenerator s_theInstance = new JournalAlarmGenerator();

    private JournalAlarmGenerator() {
    }

    public static JournalAlarmGenerator getInstance() {
        return s_theInstance;
    }

    public Vector checkForAlarmsToOpen(GeneralLogicObject source, VSwitch vSwitch) throws RemoteException {
        JournalVolumeImpl volume = (JournalVolumeImpl)source;
        Vector openAlarms = super.checkForAlarmsToOpen(source, vSwitch);
        VSwitch vswitchActiveOn = volume.getActiveOnVSwitch();
        if (vSwitch.equals(vswitchActiveOn)) {
            if (!this.alarmAlreadyIncluded(volume, AlarmType.JOURNAL_NO_PAIR_CONNECTED) && !volume.isConnectedToPairs()) {
                this.msg = this.getDefaultMessage(volume, vSwitch);
                this.msg.append(" is not connected to any pair");
                this.addAlarm(openAlarms, AlarmType.JOURNAL_NO_PAIR_CONNECTED, (GeneralLogicObject)volume, vSwitch, this.msg.toString());
            }
            if (volume.isOverUsed(vSwitch)) {
                Integer thresh = volume.getPercentageThreshold(vSwitch);
                this.msg = this.getDefaultMessage(source, vSwitch);
                this.msg.append(" has exceeded its threshold [");
                this.msg.append(thresh.toString());
                this.msg.append("%]");
                this.addAlarm(openAlarms, AlarmType.JOURNAL_OVER_USED, (GeneralLogicObject)volume, vSwitch, this.msg.toString());
            }
            if (volume.isOutOfSync(vSwitch)) {
                this.msg = this.getDefaultMessage(volume, vSwitch);
                this.msg.append(" data is not updated");
                this.addAlarm(openAlarms, AlarmType.JOURNAL_OUT_OF_SYNC, (GeneralLogicObject)volume, vSwitch, this.msg.toString());
            }
            if (volume.isFull(vSwitch)) {
                this.msg = this.getDefaultMessage(volume, vSwitch);
                this.msg.append(" is full");
                this.addAlarm(openAlarms, AlarmType.JOURNAL_FULL, (GeneralLogicObject)volume, vSwitch, this.msg.toString());
            }
        }
        return openAlarms;
    }

    public Vector checkForAlarmsToClose(GeneralLogicObject source, VSwitch vSwitch, Vector openAlarms) throws RemoteException {
        JournalVolumeImpl volume = (JournalVolumeImpl)source;
        Vector closeAlarms = super.checkForAlarmsToClose(source, vSwitch, openAlarms);
        Enumeration e = openAlarms.elements();
        while (e.hasMoreElements()) {
            Alarm alarm = (Alarm)e.nextElement();
            if (alarm.getType().equals(AlarmType.JOURNAL_NO_PAIR_CONNECTED)) {
                if (!volume.isConnectedToPairs()) continue;
                closeAlarms.addElement(alarm);
                continue;
            }
            if (alarm.getType().equals(AlarmType.JOURNAL_OVER_USED)) {
                if (volume.isOverUsed(vSwitch)) continue;
                closeAlarms.addElement(alarm);
                continue;
            }
            if (!alarm.getType().equals(AlarmType.JOURNAL_FULL) && !alarm.getType().equals(AlarmType.JOURNAL_OUT_OF_SYNC) || volume.isOutOfSync(vSwitch)) continue;
            closeAlarms.addElement(alarm);
        }
        return closeAlarms;
    }
}

