/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.alarm.volume;

import com.sanrad.nms.server.alarm.Alarm;
import com.sanrad.nms.server.alarm.AlarmGenerator;
import com.sanrad.nms.server.alarm.AlarmMgrImpl;
import com.sanrad.nms.server.alarm.AlarmType;
import com.sanrad.nms.server.logic.GeneralLogicObject;
import com.sanrad.nms.server.logic.volume.VolumeNodeImpl;
import com.sanrad.nms.server.logic.volume.copy.CopyOperationImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.util.types.constants.VolumeOperationOperStatusConstant;
import com.sanrad.nms.server.util.types.constants.VolumeOperationType;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Vector;

public class CopyOperationAlarmGenerator
extends AlarmGenerator {
    private static CopyOperationAlarmGenerator theInstance = new CopyOperationAlarmGenerator();

    private CopyOperationAlarmGenerator() {
    }

    public static CopyOperationAlarmGenerator getInstance() {
        return theInstance;
    }

    public Vector checkForAlarmsToOpen(GeneralLogicObject source, VSwitch vSwitch) throws RemoteException {
        Vector openAlarms = super.checkForAlarmsToOpen(source, vSwitch);
        CopyOperationImpl copyOper = (CopyOperationImpl)source;
        VolumeNodeImpl srcVol = (VolumeNodeImpl)copyOper.getCopySrcNode();
        VolumeNodeImpl dstVol = (VolumeNodeImpl)copyOper.getCopyDstNode();
        VolumeOperationOperStatusConstant operStat = copyOper.getCopyStatus();
        VolumeOperationType operType = copyOper.getCopyType();
        if (operStat.isActive()) {
            this.msg = this.getDefaultMessage(vSwitch);
            this.msg.append(operType.toString());
            this.msg.append(" is performed from source ");
            this.msg.append(srcVol.getClassId());
            this.msg.append(" ");
            this.msg.append(srcVol.getAlias(vSwitch));
            this.msg.append(" to destination ");
            this.msg.append(dstVol.getClassId());
            this.msg.append(" ");
            this.msg.append(dstVol.getAlias(vSwitch));
            this.addAlarm(openAlarms, AlarmType.VOLUME_OPER, (GeneralLogicObject)srcVol, vSwitch, this.msg.toString());
        } else if (operStat.equals(VolumeOperationOperStatusConstant.VOLUME_OPERATION_OPER_END_OK)) {
            if (operType.equals(copyOper.getAbortType())) {
                this.msg = this.getDefaultMessage(vSwitch);
                this.msg.append(operType.toString());
                this.msg.append(" aborted for source ");
                this.msg.append(srcVol.getClassId());
                this.msg.append(" ");
                this.msg.append(srcVol.getAlias(vSwitch));
                this.msg.append(" and destination ");
                this.msg.append(dstVol.getClassId());
                this.msg.append(" ");
                this.msg.append(dstVol.getAlias(vSwitch));
                this.addAlarm(openAlarms, AlarmType.VOLUME_OPER_ABORTED, source, vSwitch, this.msg.toString());
            }
        } else if (operStat.equals(VolumeOperationOperStatusConstant.VOLUME_OPERATION_OPER_END_ERROR)) {
            this.msg = this.getDefaultMessage(vSwitch);
            this.msg.append(operType.toString());
            this.msg.append(" ended with error for source ");
            this.msg.append(srcVol.getClassId());
            this.msg.append(" ");
            this.msg.append(srcVol.getAlias(vSwitch));
            this.msg.append(" and destination ");
            this.msg.append(dstVol.getClassId());
            this.msg.append(" ");
            this.msg.append(dstVol.getAlias(vSwitch));
            this.addAlarm(openAlarms, AlarmType.VOLUME_OPER_ER, (GeneralLogicObject)srcVol, vSwitch, this.msg.toString());
        } else if (operStat.equals(VolumeOperationOperStatusConstant.VOLUME_OPERATION_WAITING)) {
            this.msg = this.getDefaultMessage(vSwitch);
            this.msg.append(operType.toString());
            this.msg.append(" from source ");
            this.msg.append(srcVol.getClassId());
            this.msg.append(" ");
            this.msg.append(srcVol.getAlias(vSwitch));
            this.msg.append(" to destination ");
            this.msg.append(dstVol.getClassId());
            this.msg.append(" ");
            this.msg.append(dstVol.getAlias(vSwitch));
            this.msg.append(" is waiting to be performed");
            this.addAlarm(openAlarms, AlarmType.VOLUME_OPER_WAITING, source, vSwitch, this.msg.toString());
        }
        return openAlarms;
    }

    protected StringBuffer getDefaultMessage(VSwitch vSwitch) throws RemoteException {
        StringBuffer msg = new StringBuffer(vSwitch.getClassId().toString());
        msg.append(" ");
        msg.append(vSwitch.getName());
        msg.append(". ");
        return msg;
    }

    public Vector checkForAlarmsToClose(GeneralLogicObject source, VSwitch vSwitch, Vector openAlarmsForCopyOper) throws RemoteException {
        Alarm alarm;
        Vector closeAlarms = super.checkForAlarmsToClose(source, vSwitch, openAlarmsForCopyOper);
        CopyOperationImpl copyOper = (CopyOperationImpl)source;
        VolumeNodeImpl srcVol = (VolumeNodeImpl)copyOper.getCopySrcNode();
        VolumeOperationOperStatusConstant operStat = copyOper.getCopyStatus();
        Vector openAlarmsForSrcVol = AlarmMgrImpl.getInstance().getAlarms(srcVol);
        Enumeration e = openAlarmsForSrcVol.elements();
        while (e.hasMoreElements()) {
            alarm = (Alarm)e.nextElement();
            if (alarm.getType().equals(AlarmType.VOLUME_OPER)) {
                if (!operStat.equals(VolumeOperationOperStatusConstant.VOLUME_OPERATION_OPER_END_ERROR) && !operStat.equals(VolumeOperationOperStatusConstant.VOLUME_OPERATION_OPER_END_OK) && !operStat.equals(VolumeOperationOperStatusConstant.VOLUME_OPERATION_OPER_STATUS_IDLE)) continue;
                closeAlarms.addElement(alarm);
                continue;
            }
            if (!alarm.getType().equals(AlarmType.VOLUME_OPER_ER) || !operStat.isActive() && !operStat.equals(VolumeOperationOperStatusConstant.VOLUME_OPERATION_OPER_END_OK) && !operStat.equals(VolumeOperationOperStatusConstant.VOLUME_OPERATION_OPER_STATUS_IDLE)) continue;
            closeAlarms.addElement(alarm);
        }
        e = openAlarmsForCopyOper.elements();
        while (e.hasMoreElements()) {
            alarm = (Alarm)e.nextElement();
            if (alarm.getType().equals(AlarmType.VOLUME_OPER_ABORTED)) {
                if (!operStat.isActive() && !operStat.equals(VolumeOperationOperStatusConstant.VOLUME_OPERATION_OPER_STATUS_IDLE)) continue;
                closeAlarms.addElement(alarm);
                continue;
            }
            if (!alarm.getType().equals(AlarmType.VOLUME_OPER_WAITING) || operStat.equals(VolumeOperationOperStatusConstant.VOLUME_OPERATION_WAITING)) continue;
            closeAlarms.addElement(alarm);
        }
        return closeAlarms;
    }

    protected Vector hasBadValues(Vector openAlarms, GeneralLogicObject source, VSwitch vSwitch) throws RemoteException {
        return openAlarms;
    }
}

