/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.alarm.volume;

import com.sanrad.nms.server.alarm.Alarm;
import com.sanrad.nms.server.alarm.AlarmType;
import com.sanrad.nms.server.alarm.volume.VirtualVolumeAlarmGenerator;
import com.sanrad.nms.server.logic.GeneralLogicObject;
import com.sanrad.nms.server.logic.volume.ConcatinationVolumeImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Vector;

public class ConcatenationVolumeAlarmGenerator
extends VirtualVolumeAlarmGenerator {
    private static ConcatenationVolumeAlarmGenerator theInstance = new ConcatenationVolumeAlarmGenerator();

    protected ConcatenationVolumeAlarmGenerator() {
    }

    public static ConcatenationVolumeAlarmGenerator getInstance() {
        return theInstance;
    }

    public Vector checkForAlarmsToOpen(GeneralLogicObject source, VSwitch vSwitch) throws RemoteException {
        ConcatinationVolumeImpl volume = (ConcatinationVolumeImpl)source;
        Vector openAlarms = super.checkForAlarmsToOpen(source, vSwitch);
        if (volume.isExpandable(vSwitch)) {
            this.msg = this.getDefaultMessage(source, vSwitch);
            this.msg.append(" is expandable");
            this.addAlarm(openAlarms, AlarmType.VOLUME_EXPANDABLE, source, vSwitch, this.msg.toString());
        }
        return openAlarms;
    }

    public Vector checkForAlarmsToClose(GeneralLogicObject source, VSwitch vSwitch, Vector openAlarms) throws RemoteException {
        ConcatinationVolumeImpl volume = (ConcatinationVolumeImpl)source;
        Vector closeAlarms = super.checkForAlarmsToClose(source, vSwitch, openAlarms);
        Enumeration e = openAlarms.elements();
        while (e.hasMoreElements()) {
            Alarm alarm = (Alarm)e.nextElement();
            if (!alarm.getType().equals(AlarmType.VOLUME_EXPANDABLE) || volume.isExpandable(vSwitch)) continue;
            closeAlarms.addElement(alarm);
        }
        return closeAlarms;
    }
}

