/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.alarm.target;

import com.sanrad.nms.server.alarm.Alarm;
import com.sanrad.nms.server.alarm.AlarmGenerator;
import com.sanrad.nms.server.alarm.AlarmType;
import com.sanrad.nms.server.logic.GeneralLogicObject;
import com.sanrad.nms.server.logic.target.ISCSIRemoteTargetPortalImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Vector;

public class ISCSIRemoteTargetPortalAlarmGenerator
extends AlarmGenerator {
    private static ISCSIRemoteTargetPortalAlarmGenerator s_theInstance = new ISCSIRemoteTargetPortalAlarmGenerator();

    protected ISCSIRemoteTargetPortalAlarmGenerator() {
    }

    public static ISCSIRemoteTargetPortalAlarmGenerator getInstance() {
        return s_theInstance;
    }

    public Vector checkForAlarmsToOpen(GeneralLogicObject source, VSwitch vSwitch) throws RemoteException {
        ISCSIRemoteTargetPortalImpl remoteTargetPortal = (ISCSIRemoteTargetPortalImpl)source;
        Vector openAlarms = super.checkForAlarmsToOpen(source, vSwitch);
        if (!remoteTargetPortal.isSynchronizedBetweenVSwitches(vSwitch)) {
            String remoteTargetName = remoteTargetPortal.getRemoteTarget().getName();
            VSwitch[] vswitches = remoteTargetPortal.getConnectedVSwitches();
            VSwitch otherVswitch = vswitches[0].equals(vSwitch) ? vswitches[1] : vswitches[0];
            this.msg = this.getDefaultMessage(remoteTargetPortal, vSwitch, vSwitch.getCluster());
            this.msg.append(" of the iSCSI remote target ");
            this.msg.append(remoteTargetName);
            this.msg.append(" is not configured at ");
            this.msg.append(vSwitch.getClassId().toString());
            this.msg.append(" ");
            this.msg.append(otherVswitch.getName());
            this.addAlarm(openAlarms, AlarmType.PORTAL_INCONSISTENCY, (GeneralLogicObject)remoteTargetPortal.getRemoteTarget(), vSwitch, this.msg.toString());
        }
        return openAlarms;
    }

    public Vector checkForAlarmsToClose(GeneralLogicObject source, VSwitch vSwitch, Vector openAlarms) throws RemoteException {
        Vector closeAlarms = super.checkForAlarmsToClose(source, vSwitch, openAlarms);
        ISCSIRemoteTargetPortalImpl remoteTargetPortal = (ISCSIRemoteTargetPortalImpl)source;
        Enumeration e = openAlarms.elements();
        while (e.hasMoreElements()) {
            Alarm alarm = (Alarm)e.nextElement();
            AlarmType alarmType = alarm.getType();
            if (!alarmType.equals(AlarmType.PORTAL_INCONSISTENCY) || !remoteTargetPortal.isSynchronizedBetweenVSwitches(vSwitch)) continue;
            closeAlarms.addElement(alarm);
        }
        return closeAlarms;
    }
}

