/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.alarm.target;

import com.sanrad.nms.server.alarm.Alarm;
import com.sanrad.nms.server.alarm.AlarmImpl;
import com.sanrad.nms.server.alarm.AlarmType;
import com.sanrad.nms.server.alarm.AliasObjectAlarmGenerator;
import com.sanrad.nms.server.logic.GeneralLogicObject;
import com.sanrad.nms.server.logic.target.ISCSIRemoteTargetImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Vector;

public class ISCSIRemoteTargetAlarmGenerator
extends AliasObjectAlarmGenerator {
    private static ISCSIRemoteTargetAlarmGenerator s_theInstance = new ISCSIRemoteTargetAlarmGenerator();

    protected ISCSIRemoteTargetAlarmGenerator() {
    }

    public static ISCSIRemoteTargetAlarmGenerator getInstance() {
        return s_theInstance;
    }

    public Vector checkForAlarmsToOpen(GeneralLogicObject source, VSwitch vSwitch) throws RemoteException {
        ISCSIRemoteTargetImpl remoteTarget = (ISCSIRemoteTargetImpl)source;
        Vector openAlarms = super.checkForAlarmsToOpen(source, vSwitch);
        if (remoteTarget.getConfiguredAsLocalTargetOnSameCluster() != null) {
            return openAlarms;
        }
        if (!remoteTarget.anyPortalsDefined(vSwitch)) {
            this.msg = this.getDefaultMessage(source, vSwitch);
            this.msg.append(" has no portals defined yet");
            this.addAlarm(openAlarms, AlarmType.UNCOMPLETED_DEFINITION, source, vSwitch, this.msg.toString());
        }
        if (!remoteTarget.isConnected(vSwitch)) {
            this.msg = this.getDefaultMessage(source, vSwitch);
            this.msg.append(" is not connected");
            this.addAlarm(openAlarms, AlarmType.TARGET_NOT_CONNECTED, source, vSwitch, this.msg.toString());
        }
        return openAlarms;
    }

    public Vector checkForAlarmsToClose(GeneralLogicObject source, VSwitch vSwitch, Vector openAlarms) throws RemoteException {
        Vector closeAlarms = super.checkForAlarmsToClose(source, vSwitch, openAlarms);
        ISCSIRemoteTargetImpl remoteTarget = (ISCSIRemoteTargetImpl)source;
        this.changeRemoteTargetAliasInAlarms(remoteTarget, vSwitch, closeAlarms, openAlarms);
        Enumeration e = openAlarms.elements();
        while (e.hasMoreElements()) {
            Alarm alarm = (Alarm)e.nextElement();
            AlarmType alarmType = alarm.getType();
            if (alarmType.equals(AlarmType.UNCOMPLETED_DEFINITION)) {
                if (!((AlarmImpl)alarm).isReplacedByANewAlarm() && !remoteTarget.anyPortalsDefined(vSwitch)) continue;
                closeAlarms.addElement(alarm);
                continue;
            }
            if (!alarmType.equals(AlarmType.TARGET_NOT_CONNECTED) || !((AlarmImpl)alarm).isReplacedByANewAlarm() && !remoteTarget.isConnected(vSwitch)) continue;
            closeAlarms.addElement(alarm);
        }
        return closeAlarms;
    }

    private void changeRemoteTargetAliasInAlarms(ISCSIRemoteTargetImpl remoteTarget, VSwitch vSwitch, Vector closeAlarms, Vector openAlarms) throws RemoteException {
        String remoteTargetAlias = remoteTarget.getAlias();
        boolean isAliasWithX = remoteTargetAlias.startsWith("X");
        if (!isAliasWithX) {
            String aliasToCheck = "X" + remoteTarget.getName();
            Enumeration e = openAlarms.elements();
            while (e.hasMoreElements()) {
                StringBuffer sb;
                Alarm alarm = (Alarm)e.nextElement();
                AlarmType alarmType = alarm.getType();
                String msg = ((AlarmImpl)alarm).getMessage();
                int indexOfAlias = msg.indexOf(aliasToCheck);
                if (alarmType.equals(AlarmType.UNCOMPLETED_DEFINITION)) {
                    if (indexOfAlias <= 0) continue;
                    sb = new StringBuffer();
                    sb.append(msg.substring(0, indexOfAlias));
                    sb.append(remoteTargetAlias);
                    sb.append(" ");
                    sb.append(msg.substring(indexOfAlias + 1 + remoteTarget.getName().length() + 1));
                    this.addAlarm(openAlarms, AlarmType.UNCOMPLETED_DEFINITION, (GeneralLogicObject)remoteTarget, vSwitch, sb.toString());
                    ((AlarmImpl)alarm).setReplacedByANewAlarm(true);
                    closeAlarms.add(alarm);
                    continue;
                }
                if (!alarmType.equals(AlarmType.TARGET_NOT_CONNECTED) || indexOfAlias <= 0) continue;
                sb = new StringBuffer();
                sb.append(msg.substring(0, indexOfAlias));
                sb.append(remoteTargetAlias);
                sb.append(" ");
                sb.append(msg.substring(indexOfAlias + 1 + remoteTarget.getName().length() + 1));
                this.addAlarm(openAlarms, AlarmType.TARGET_NOT_CONNECTED, (GeneralLogicObject)remoteTarget, vSwitch, sb.toString());
                ((AlarmImpl)alarm).setReplacedByANewAlarm(true);
                closeAlarms.add(alarm);
            }
        }
    }
}

