/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.alarm.physstorage;

import com.sanrad.nms.server.alarm.Alarm;
import com.sanrad.nms.server.alarm.AlarmType;
import com.sanrad.nms.server.alarm.AliasObjectAlarmGenerator;
import com.sanrad.nms.server.logic.GeneralLogicObject;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.physstorage.SubDirectAccessDeviceImpl;
import com.sanrad.nms.server.logic.volume.copy.CopyOperationManagerImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Vector;

public class SubDirectAccessDeviceAlarmGenerator
extends AliasObjectAlarmGenerator {
    private static SubDirectAccessDeviceAlarmGenerator theInstance = new SubDirectAccessDeviceAlarmGenerator();

    private SubDirectAccessDeviceAlarmGenerator() {
    }

    public static SubDirectAccessDeviceAlarmGenerator getInstance() {
        return theInstance;
    }

    public Vector checkForAlarmsToOpen(GeneralLogicObject source, VSwitch vSwitch) throws RemoteException {
        StringBuffer msg;
        SubDirectAccessDeviceImpl subDirectAccessDevice = (SubDirectAccessDeviceImpl)source;
        Vector openAlarms = super.checkForAlarmsToOpen(source, vSwitch);
        if (subDirectAccessDevice.isNeedSync(vSwitch)) {
            this.msg = this.getDefaultMessage(source, vSwitch);
            this.msg.append(" needs to be synchronized");
            this.addAlarm(openAlarms, AlarmType.VOLUME_NEED_SYNC, source, vSwitch, this.msg.toString());
        }
        if (subDirectAccessDevice.isNonFunctional(vSwitch) && !subDirectAccessDevice.isDROfflineLocalCopy()) {
            this.msg = this.getDefaultMessage(source, vSwitch);
            this.msg.append(" is not functioning");
            this.addAlarm(openAlarms, AlarmType.VOLUME_NON_FUNC, source, vSwitch, this.msg.toString());
        }
        if (((CopyOperationManagerImpl)((ClusterImpl)subDirectAccessDevice.getCluster()).getCopyOperManager()).isInvolvedInActiveRestoreOperation(subDirectAccessDevice)) {
            this.msg = this.getDefaultMessage(vSwitch);
            this.msg.append("Roll back operation on ");
            this.msg.append(subDirectAccessDevice.getClassId());
            this.msg.append(" ");
            this.msg.append(subDirectAccessDevice.getAlias(vSwitch));
            this.msg.append(" in progress");
            this.addAlarm(openAlarms, AlarmType.VOLUME_OPER, (GeneralLogicObject)subDirectAccessDevice, vSwitch, this.msg.toString());
        }
        if (subDirectAccessDevice.isMismatch(vSwitch)) {
            msg = new StringBuffer(vSwitch.getClassId().toString());
            msg.append(" ");
            msg.append(vSwitch.getName());
            msg.append(source.getClassId());
            msg.append(" ");
            msg.append(source.toString());
            msg = this.getDefaultMessage(source, vSwitch);
            msg.append(" is mismatch");
            this.addAlarm(openAlarms, AlarmType.MISMATCH, source, vSwitch, msg.toString());
        }
        if (subDirectAccessDevice.isNonValidate(vSwitch)) {
            msg = new StringBuffer(vSwitch.getClassId().toString());
            msg.append(" ");
            msg.append(vSwitch.getName());
            msg.append(source.getClassId());
            msg.append(" ");
            msg.append(source.toString());
            msg = this.getDefaultMessage(source, vSwitch);
            msg.append(" is non validated");
            this.addAlarm(openAlarms, AlarmType.NON_VALIDATE, source, vSwitch, msg.toString());
        }
        return openAlarms;
    }

    public Vector checkForAlarmsToClose(GeneralLogicObject source, VSwitch vSwitch, Vector openAlarms) throws RemoteException {
        SubDirectAccessDeviceImpl subDirectAccessDevice = (SubDirectAccessDeviceImpl)source;
        Vector closeAlarms = super.checkForAlarmsToClose(source, vSwitch, openAlarms);
        Enumeration e = openAlarms.elements();
        while (e.hasMoreElements()) {
            Alarm alarm = (Alarm)e.nextElement();
            if (alarm.getType().equals(AlarmType.VOLUME_INTERNAL)) {
                if (subDirectAccessDevice.isInternal(vSwitch)) continue;
                closeAlarms.addElement(alarm);
                continue;
            }
            if (alarm.getType().equals(AlarmType.VOLUME_NEED_SYNC)) {
                if (subDirectAccessDevice.isNeedSync(vSwitch)) continue;
                closeAlarms.addElement(alarm);
                continue;
            }
            if (alarm.getType().equals(AlarmType.MISMATCH)) {
                if (subDirectAccessDevice.isMismatch(vSwitch)) continue;
                closeAlarms.addElement(alarm);
                continue;
            }
            if (alarm.getType().equals(AlarmType.NON_VALIDATE)) {
                if (subDirectAccessDevice.isNonValidate(vSwitch)) continue;
                closeAlarms.addElement(alarm);
                continue;
            }
            if (alarm.getType().equals(AlarmType.VOLUME_NON_FUNC)) {
                if (subDirectAccessDevice.isNonFunctional(vSwitch)) continue;
                closeAlarms.addElement(alarm);
                continue;
            }
            if (!alarm.getType().equals(AlarmType.VOLUME_OPER) || ((CopyOperationManagerImpl)((ClusterImpl)subDirectAccessDevice.getCluster()).getCopyOperManager()).isInvolvedInActiveRestoreOperation(subDirectAccessDevice)) continue;
            closeAlarms.addElement(alarm);
        }
        return closeAlarms;
    }
}

