/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.alarm.identity;

import com.sanrad.nms.server.alarm.Alarm;
import com.sanrad.nms.server.alarm.AlarmType;
import com.sanrad.nms.server.alarm.AliasObjectAlarmGenerator;
import com.sanrad.nms.server.logic.GeneralLogicObject;
import com.sanrad.nms.server.logic.identity.IdentityImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import java.rmi.RemoteException;
import java.util.Iterator;
import java.util.Vector;

public class IdentityAlarmGenerator
extends AliasObjectAlarmGenerator {
    private static IdentityAlarmGenerator instance;

    private IdentityAlarmGenerator() {
    }

    public static IdentityAlarmGenerator getInstance() {
        if (instance == null) {
            instance = new IdentityAlarmGenerator();
        }
        return instance;
    }

    public Vector checkForAlarmsToOpen(GeneralLogicObject source, VSwitch vSwitch) throws RemoteException {
        IdentityImpl identity = (IdentityImpl)source;
        if (identity.getAlias().startsWith("RemoteInitiator") || identity.isOfLocalInitiator() || identity.isOfRemoteInitiatorDR() || identity.isOfRemoteTarget() || identity.getAlias().startsWith("REMOTE_TARGET")) {
            return new Vector(0);
        }
        Vector alarms = super.checkForAlarmsToOpen(source, vSwitch);
        if (identity.isOfLocalTarget()) {
            Iterator iter = alarms.iterator();
            while (iter.hasNext()) {
                Alarm alarm = (Alarm)iter.next();
                AlarmType alarmType = alarm.getType();
                if (!alarmType.equals(AlarmType.OBJ_NOT_REDUNDANT)) continue;
                iter.remove();
            }
        }
        return alarms;
    }
}

