/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.alarm.event;

import com.sanrad.nms.server.RemoteEventImpl;
import com.sanrad.nms.server.alarm.Alarm;
import com.sanrad.nms.server.alarm.event.AlarmEvent;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.GeneralLogicObject;
import java.rmi.RemoteException;
import java.util.HashMap;

public class AlarmEventImpl
extends RemoteEventImpl
implements AlarmEvent {
    private Alarm alarm;
    private HashMap parameterList;

    public AlarmEventImpl(Object source, Alarm alarm) throws RemoteException {
        super(source);
        this.alarm = alarm;
        this.setParameterList();
    }

    private void setParameterList() throws RemoteException {
        this.parameterList = new HashMap();
        this.parameterList.put(ClientParameterCode.ALARM_ACKNOWLEDGED, new Boolean(this.alarm.isAcknowledged()));
        this.parameterList.put(ClientParameterCode.ALARM_DATE_AND_TIME, new Long(this.alarm.getDateAndTime()));
        this.parameterList.put(ClientParameterCode.ALARM_MESSAGE, this.alarm.getMessage());
        this.parameterList.put(ClientParameterCode.ALARM_SEVERITY, this.alarm.getSeverity());
        this.parameterList.put(ClientParameterCode.ALARM_SOURCE, this.alarm.getSource());
        this.parameterList.put(ClientParameterCode.ALARM_TYPE, this.alarm.getType());
        this.parameterList.put(ClientParameterCode.ALARM_VSWITCH, this.alarm.getVSwitch());
        this.parameterList.put(ClientParameterCode.ALARM_ACKNOWLEDGED_AT, new Long(this.alarm.getAckDateAndTime()));
        this.parameterList.put(ClientParameterCode.ALARM_ACKNOWLEDGED_BY, this.alarm.getAcknowledgedBy());
    }

    public GeneralLogicObject getSourceObject() throws RemoteException {
        return (GeneralLogicObject)this.getSource();
    }

    public Alarm getAlarm() throws RemoteException {
        return this.alarm;
    }

    public HashMap getParameterList() throws RemoteException {
        return this.parameterList;
    }
}

