/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.alarm.dr;

import com.sanrad.nms.server.alarm.Alarm;
import com.sanrad.nms.server.alarm.AlarmGenerator;
import com.sanrad.nms.server.alarm.AlarmType;
import com.sanrad.nms.server.logic.GeneralLogicObject;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterPairImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Vector;

public abstract class DrClusterPairAlarmGenerator
extends AlarmGenerator {
    protected DrClusterPairAlarmGenerator() {
    }

    public Vector checkForAlarmsToOpen(GeneralLogicObject source, VSwitch vSwitch) throws RemoteException {
        Vector openAlarms = super.checkForAlarmsToOpen(source, vSwitch);
        if (((DRClusterPairImpl)source).isIllegalVolPair()) {
            this.addAlarmAndMsg(source, vSwitch, openAlarms, " Illegal Volume ", AlarmType.ILLEAGAL_VOL_PAIR);
        }
        return openAlarms;
    }

    public Vector checkForAlarmsToClose(GeneralLogicObject source, VSwitch vSwitch, Vector openAlarms) throws RemoteException {
        Vector closeAlarms = super.checkForAlarmsToClose(source, vSwitch, openAlarms);
        Enumeration e = openAlarms.elements();
        while (e.hasMoreElements()) {
            Alarm alarm = (Alarm)e.nextElement();
            if (!alarm.getType().equals(AlarmType.ILLEAGAL_VOL_PAIR) || ((DRClusterPairImpl)source).isIllegalVolPair()) continue;
            closeAlarms.addElement(alarm);
        }
        return closeAlarms;
    }
}

