/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.alarm.dr;

import com.sanrad.nms.server.alarm.Alarm;
import com.sanrad.nms.server.alarm.AlarmGenerator;
import com.sanrad.nms.server.alarm.AlarmType;
import com.sanrad.nms.server.logic.GeneralLogicObject;
import com.sanrad.nms.server.logic.GeneralLogicObjectImpl;
import com.sanrad.nms.server.logic.dr.DRLogicObjectImpl;
import com.sanrad.nms.server.logic.validation.Validator;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Vector;

public class DrAlarmGenerator
extends AlarmGenerator {
    protected Class m_father = null;

    protected DrAlarmGenerator() {
    }

    protected Class returnFatherIfAlias() {
        return null;
    }

    public Vector checkForAlarmsToOpen(GeneralLogicObject source, VSwitch vSwitch) throws RemoteException {
        Vector openAlarms = new Vector();
        openAlarms = super.checkForAlarmsToOpen(source, vSwitch);
        openAlarms.addAll(this.checkForAlarmsToOpenInClusters((DRLogicObjectImpl)source, vSwitch, openAlarms));
        if (Boolean.TRUE.equals(Validator.getInstance().validAccordingToParameter((GeneralLogicObjectImpl)source, AlarmType.REPL_INACTIVE, vSwitch))) {
            this.addAlarmAndMsg(source, vSwitch, openAlarms, "  is inactive ", AlarmType.REPL_INACTIVE);
        }
        if (Boolean.TRUE.equals(Validator.getInstance().validAccordingToParameter((GeneralLogicObjectImpl)source, AlarmType.REPL_MERGE, vSwitch))) {
            this.addAlarmAndMsg(source, vSwitch, openAlarms, " is merging ", AlarmType.REPL_MERGE);
        }
        if (Boolean.TRUE.equals(Validator.getInstance().validAccordingToParameter((GeneralLogicObjectImpl)source, AlarmType.REPL_TRANSFER, vSwitch))) {
            this.addAlarmAndMsg(source, vSwitch, openAlarms, " is transferring", AlarmType.REPL_TRANSFER);
        }
        if (Boolean.TRUE.equals(Validator.getInstance().validAccordingToParameter((GeneralLogicObjectImpl)source, AlarmType.SWITCHED, vSwitch))) {
            this.addAlarmAndMsg(source, vSwitch, openAlarms, " is switched", AlarmType.SWITCHED);
        }
        if (Boolean.TRUE.equals(Validator.getInstance().validAccordingToParameter((GeneralLogicObjectImpl)source, AlarmType.DR_STATE_ERROR, vSwitch))) {
            this.addAlarmAndMsg(source, vSwitch, openAlarms, " has error ", AlarmType.DR_STATE_ERROR);
        }
        if (Boolean.TRUE.equals(Validator.getInstance().validAccordingToParameter((GeneralLogicObjectImpl)source, AlarmType.CF_FAIL, vSwitch))) {
            this.addAlarmAndMsg(source, vSwitch, openAlarms, " has failed because of networking problem ", AlarmType.CF_FAIL);
        }
        return openAlarms;
    }

    public Vector checkForAlarmsToClose(GeneralLogicObject source, VSwitch vSwitch, Vector openAlarms) throws RemoteException {
        Vector closeAlarms = new Vector();
        closeAlarms = super.checkForAlarmsToClose(source, vSwitch, openAlarms);
        closeAlarms.addAll(this.checkForAlarmsToCloseInClusters((DRLogicObjectImpl)source, vSwitch, openAlarms));
        Enumeration e = openAlarms.elements();
        while (e.hasMoreElements()) {
            Alarm alarm = (Alarm)e.nextElement();
            if (!Boolean.FALSE.equals(Validator.getInstance().validAccordingToParameter((GeneralLogicObjectImpl)source, alarm.getType(), vSwitch))) continue;
            closeAlarms.addElement(alarm);
        }
        return closeAlarms;
    }

    private Vector checkForAlarmsToOpenInClusters(DRLogicObjectImpl source, VSwitch vSwitch, Vector openAlarms) throws RemoteException {
        if (source.getLocalElement() != null && vSwitch != null && vSwitch.getCluster().equals(source.getLocalElement().getCluster())) {
            Vector openAlarmsLocal = source.getClusterAlarmGenerator().checkForAlarmsToOpen(source.getLocalElement(), vSwitch);
            openAlarms.addAll(openAlarmsLocal);
        }
        if (source.getRemoteElement() != null && vSwitch != null && vSwitch.getCluster().equals(source.getRemoteElement().getCluster())) {
            Vector openAlarmsRemote = source.getClusterAlarmGenerator().checkForAlarmsToOpen(source.getRemoteElement(), vSwitch);
            openAlarms.addAll(openAlarmsRemote);
        }
        return openAlarms;
    }

    private Vector checkForAlarmsToCloseInClusters(DRLogicObjectImpl source, VSwitch vSwitch, Vector openAlarms) throws RemoteException {
        Vector closeAlarms = new Vector();
        if (source.getLocalElement() != null && vSwitch != null && vSwitch.getCluster().equals(source.getLocalElement().getCluster())) {
            Vector closeAlarmsLocal = source.getClusterAlarmGenerator().checkForAlarmsToClose(source.getLocalElement(), vSwitch, openAlarms);
            closeAlarms.addAll(closeAlarmsLocal);
        }
        if (source.getRemoteElement() != null && vSwitch != null && vSwitch.getCluster().equals(source.getRemoteElement().getCluster())) {
            Vector closeAlarmsRemote = source.getClusterAlarmGenerator().checkForAlarmsToClose(source.getRemoteElement(), vSwitch, openAlarms);
            closeAlarms.addAll(closeAlarmsRemote);
        }
        return closeAlarms;
    }

    protected DrAlarmGenerator(Class father) {
        this.setFather(father);
    }

    private void setFather(Class father) {
        this.m_father = this.calculateAnacestor(father);
    }
}

