/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.alarm.dr;

import com.sanrad.nms.server.alarm.Alarm;
import com.sanrad.nms.server.alarm.AlarmType;
import com.sanrad.nms.server.alarm.dr.DrAlarmGenerator;
import com.sanrad.nms.server.logic.GeneralLogicObject;
import com.sanrad.nms.server.logic.GeneralLogicObjectImpl;
import com.sanrad.nms.server.logic.dr.DRAsyncPairImpl;
import com.sanrad.nms.server.logic.dr.DRPairImpl;
import com.sanrad.nms.server.logic.validation.Validator;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Vector;

public abstract class DRPairAlarmGenerator
extends DrAlarmGenerator {
    static /* synthetic */ Class class$com$sanrad$nms$server$alarm$dr$DrAlarmGenerator;

    protected DRPairAlarmGenerator() {
    }

    public Vector checkForAlarmsToOpen(GeneralLogicObject source, VSwitch vSwitch) throws RemoteException {
        Vector openAlarms = new Vector();
        if (this.m_father != (class$com$sanrad$nms$server$alarm$dr$DrAlarmGenerator == null ? (class$com$sanrad$nms$server$alarm$dr$DrAlarmGenerator = DRPairAlarmGenerator.class$("com.sanrad.nms.server.alarm.dr.DrAlarmGenerator")) : class$com$sanrad$nms$server$alarm$dr$DrAlarmGenerator)) {
            openAlarms = super.checkForAlarmsToOpen(source, vSwitch);
        }
        if (((DRPairImpl)source).isInvertedPair()) {
            this.addAlarmAndMsg(source, vSwitch, openAlarms, " Inverted Pair ", AlarmType.INVERTED_PAIR);
        }
        if (Boolean.TRUE.equals(Validator.getInstance().validAccordingToParameter((GeneralLogicObjectImpl)source, AlarmType.NEED_SYNC, vSwitch))) {
            this.addAlarmAndMsg(source, vSwitch, openAlarms, " is not synchronized ", AlarmType.NEED_SYNC);
        }
        if (Boolean.TRUE.equals(Validator.getInstance().validAccordingToParameter((GeneralLogicObjectImpl)source, AlarmType.INIT_SYNC_IN_PROGRESS, vSwitch))) {
            this.addAlarmAndMsg(source, vSwitch, openAlarms, " is synchronizing ", AlarmType.INIT_SYNC_IN_PROGRESS);
        }
        if (((DRPairImpl)source).isUnequivelentPair()) {
            this.addAlarmAndMsg(source, vSwitch, openAlarms, " Inconsistent  Pair ", AlarmType.UNEQUIVALENT_PAIR);
        }
        if (!(((DRPairImpl)source).getPrimaryVolume().getLocalVolume() == null || ((DRPairImpl)source).getSecondaryVolume().getRemoteVolume() == null || ((DRPairImpl)source).getPrimaryVolume().getLocalVolume().getAccessibleSpace().equals(((DRPairImpl)source).getSecondaryVolume().getRemoteVolume().getAccessibleSpace()) && ((DRPairImpl)source).getPrimaryVolume().getLocalVolume().getBlockSize() == ((DRPairImpl)source).getSecondaryVolume().getRemoteVolume().getBlockSize())) {
            if (source instanceof DRAsyncPairImpl && ((DRAsyncPairImpl)source).getVolumeLocalCopySize() != null) {
                if (!((DRPairImpl)source).getPrimaryVolume().getLocalVolume().getAccessibleSpace().equals(((DRAsyncPairImpl)source).getVolumeLocalCopySize())) {
                    this.addAlarmAndMsg(source, vSwitch, openAlarms, " Primary has a different size or block size than Secondary", AlarmType.DIFF_SIZE);
                }
            } else {
                this.addAlarmAndMsg(source, vSwitch, openAlarms, " Primary has a different size or block size than Secondary", AlarmType.DIFF_SIZE);
            }
        }
        return openAlarms;
    }

    public Vector checkForAlarmsToClose(GeneralLogicObject source, VSwitch vSwitch, Vector openAlarms) throws RemoteException {
        Vector closeAlarms = new Vector();
        if (this.m_father != (class$com$sanrad$nms$server$alarm$dr$DrAlarmGenerator == null ? (class$com$sanrad$nms$server$alarm$dr$DrAlarmGenerator = DRPairAlarmGenerator.class$("com.sanrad.nms.server.alarm.dr.DrAlarmGenerator")) : class$com$sanrad$nms$server$alarm$dr$DrAlarmGenerator)) {
            closeAlarms = super.checkForAlarmsToClose(source, vSwitch, openAlarms);
        }
        Enumeration e = openAlarms.elements();
        while (e.hasMoreElements()) {
            Alarm alarm = (Alarm)e.nextElement();
            if (alarm.getType().equals(AlarmType.INVERTED_PAIR) && !((DRPairImpl)source).isInvertedPair()) {
                closeAlarms.addElement(alarm);
                continue;
            }
            if (alarm.getType().equals(AlarmType.UNEQUIVALENT_PAIR) && !((DRPairImpl)source).isUnequivelentPair()) {
                closeAlarms.addElement(alarm);
                continue;
            }
            if (!alarm.getType().equals(AlarmType.DIFF_SIZE) || ((DRPairImpl)source).getPrimaryVolume().getLocalVolume() == null || ((DRPairImpl)source).getSecondaryVolume().getRemoteVolume() == null) continue;
            if (source instanceof DRAsyncPairImpl && ((DRAsyncPairImpl)source).getVolumeLocalCopySize() != null) {
                if (!((DRPairImpl)source).getPrimaryVolume().getLocalVolume().getAccessibleSpace().equals(((DRAsyncPairImpl)source).getVolumeLocalCopySize())) continue;
                closeAlarms.addElement(alarm);
                continue;
            }
            if (!((DRPairImpl)source).getPrimaryVolume().getLocalVolume().getAccessibleSpace().equals(((DRPairImpl)source).getSecondaryVolume().getRemoteVolume().getAccessibleSpace())) continue;
            closeAlarms.addElement(alarm);
        }
        return closeAlarms;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

