/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.alarm.cluster;

import com.sanrad.nms.server.alarm.Alarm;
import com.sanrad.nms.server.alarm.AlarmGenerator;
import com.sanrad.nms.server.alarm.AlarmImpl;
import com.sanrad.nms.server.alarm.AlarmType;
import com.sanrad.nms.server.logic.GeneralLogicObject;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.target.Target;
import com.sanrad.nms.server.logic.volume.VolumeNode;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.util.ClassID;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public class ClusterAlarmGenerator
extends AlarmGenerator {
    private static ClusterAlarmGenerator theInstance = new ClusterAlarmGenerator();

    public static ClusterAlarmGenerator getInstance() {
        return theInstance;
    }

    private ClusterAlarmGenerator() {
    }

    public Vector checkForAlarmsToOpen(GeneralLogicObject source, VSwitch vSwitch) throws RemoteException {
        ClusterImpl cluster = (ClusterImpl)source;
        Vector openAlarms = super.checkForAlarmsToOpen(source, vSwitch);
        if (!cluster.isRedundant()) {
            String msg = "A cluster must have two " + ClassID.VSWITCH + "es to support failover";
            this.addAlarm(openAlarms, AlarmType.CLUSTER_INC, source, msg);
        } else if (!cluster.areVSwitchesNeighbors()) {
            StringBuffer msgBuffer;
            String[] names = cluster.getVSwitchesNamesAndIPs();
            if (names.length > 1) {
                msgBuffer = new StringBuffer(ClassID.VSWITCH.toString());
                msgBuffer.append(" ");
                msgBuffer.append(names[0]);
                msgBuffer.append(" and ");
                msgBuffer.append(ClassID.VSWITCH);
                msgBuffer.append(" ");
                msgBuffer.append(names[1]);
                msgBuffer.append(" are not neighbors.  Failover is not supported");
            } else {
                msgBuffer = new StringBuffer("Only neighboring ");
                msgBuffer.append(ClassID.VSWITCH);
                msgBuffer.append("es can support failover.  To support failover, ");
                msgBuffer.append(ClassID.VSWITCH);
                msgBuffer.append("es must be neighbors");
            }
            this.addAlarm(openAlarms, AlarmType.VSWITCHES_NOT_NEIGHBORS, source, msgBuffer.toString());
        }
        HashMap targets = cluster.getTargetListMgr().getTargetsWithSameVolume();
        Iterator i = targets.keySet().iterator();
        while (i.hasNext()) {
            Target target2;
            Target target1;
            VolumeNode volume = (VolumeNode)i.next();
            Vector badTargets = (Vector)targets.get(volume);
            if (badTargets.size() <= 1 || (target1 = (Target)badTargets.elementAt(0)).equals(target2 = (Target)badTargets.elementAt(1))) continue;
            StringBuffer msg = new StringBuffer(target1.getClassId().toString());
            msg.append(" ");
            msg.append(target1);
            msg.append(" and ");
            msg.append(target2.getClassId());
            msg.append(" ");
            msg.append(target2);
            msg.append(" both expose ");
            msg.append(volume.getClassId());
            msg.append(" ");
            msg.append(volume);
            this.addAlarm(openAlarms, AlarmType.TARGET_VOLUME_INCONS, (GeneralLogicObject)cluster, msg.toString(), volume);
        }
        return openAlarms;
    }

    public Vector checkForAlarmsToClose(GeneralLogicObject source, VSwitch vSwitch, Vector openAlarms) throws RemoteException {
        ClusterImpl cluster = (ClusterImpl)source;
        Vector closeAlarms = super.checkForAlarmsToClose(source, vSwitch, openAlarms);
        Enumeration e = openAlarms.elements();
        while (e.hasMoreElements()) {
            HashMap targets;
            Alarm alarm = (Alarm)e.nextElement();
            if (alarm.getType().equals(AlarmType.CLUSTER_INC)) {
                if (!cluster.isRedundant()) continue;
                closeAlarms.addElement(alarm);
                continue;
            }
            if (alarm.getType().equals(AlarmType.VSWITCHES_NOT_NEIGHBORS)) {
                if (!cluster.areVSwitchesNeighbors()) continue;
                closeAlarms.addElement(alarm);
                continue;
            }
            if (!alarm.getType().equals(AlarmType.TARGET_VOLUME_INCONS) || (targets = cluster.getTargetListMgr().getTargetsWithSameVolume()).get(((AlarmImpl)alarm).getAdditionalKeyObject()) != null) continue;
            closeAlarms.addElement(alarm);
        }
        return closeAlarms;
    }

    protected boolean isRedundant(GeneralLogicObject source) throws RemoteException {
        return true;
    }
}

