/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.alarm;

import com.sanrad.nms.server.alarm.Alarm;
import com.sanrad.nms.server.alarm.AlarmImpl;
import com.sanrad.nms.server.alarm.AlarmList;
import com.sanrad.nms.server.alarm.AlarmType;
import com.sanrad.nms.server.logic.GeneralLogicObject;
import com.sanrad.nms.server.logic.GeneralLogicObjectImpl;
import com.sanrad.nms.server.logic.LogicObject;
import com.sanrad.nms.server.logic.LogicObjectImpl;
import com.sanrad.nms.server.logic.dr.DRLogicObject;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.util.types.constants.DrSiteConstant;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class PendingAlarmList
extends AlarmList {
    private Integer vSwitchGroupId;

    public PendingAlarmList(AlarmList alarmList, Integer vSwitchGroupId) throws RemoteException {
        super(alarmList);
        this.vSwitchGroupId = vSwitchGroupId;
    }

    public PendingAlarmList(Hashtable pendingAlarmLists) throws RemoteException {
        super(pendingAlarmLists);
        this.vSwitchGroupId = DrSiteConstant.DR_VSWITCH_GROUP_ID.getValue();
    }

    private Vector getClosedAlarms(AlarmList liveAlarmList, GeneralLogicObjectImpl source) throws RemoteException {
        Vector<Alarm> closedAlarms = new Vector<Alarm>();
        Vector liveAlarms = liveAlarmList.getAlarms(source);
        Vector pendingAlarms = this.getAlarms(source);
        if (liveAlarms != null) {
            Enumeration e = pendingAlarms.elements();
            while (e.hasMoreElements()) {
                Alarm pendingAlarm = (Alarm)e.nextElement();
                if (liveAlarms.contains(pendingAlarm)) continue;
                closedAlarms.addElement(pendingAlarm);
            }
        } else if (pendingAlarms != null) {
            closedAlarms.addAll(pendingAlarms);
        }
        return closedAlarms;
    }

    public Vector removePendingAlarms(AlarmList liveAlarmList) throws RemoteException {
        Hashtable pendingList = this.getAllAlarms();
        Vector allClosedAlarms = new Vector();
        if (pendingList == null) {
            return null;
        }
        Enumeration e = pendingList.keys();
        while (e.hasMoreElements()) {
            GeneralLogicObjectImpl source = (GeneralLogicObjectImpl)e.nextElement();
            if (source == null) continue;
            Vector closedAlarms = this.getClosedAlarms(liveAlarmList, source);
            allClosedAlarms.addAll(closedAlarms);
            this.addToHistory(closedAlarms, true);
        }
        return allClosedAlarms;
    }

    public int hashCode() {
        return this.vSwitchGroupId;
    }

    public boolean equals(Object list) {
        return list instanceof PendingAlarmList && ((PendingAlarmList)list).vSwitchGroupId.intValue() == this.vSwitchGroupId.intValue();
    }

    public Vector getPendingAlarms(LogicObjectImpl source, VSwitch vSwitch) throws RemoteException {
        return this.getAlarms(source, vSwitch);
    }

    public Vector getAcknowledgedPendingAlarms(LogicObjectImpl source, VSwitch vSwitch) throws RemoteException {
        Vector pendingAlarms = this.getPendingAlarms(source, vSwitch);
        Vector<Alarm> acknowledgedPendingAlarms = new Vector<Alarm>();
        Enumeration e = pendingAlarms.elements();
        while (e.hasMoreElements()) {
            Alarm alarm = (Alarm)e.nextElement();
            if (!alarm.isAcknowledged()) continue;
            acknowledgedPendingAlarms.addElement(alarm);
        }
        return acknowledgedPendingAlarms;
    }

    public Vector getAcknowledgedPendingAlarms() throws RemoteException {
        Vector<AlarmImpl> acknowledgedPendingAlarms = new Vector<AlarmImpl>();
        Hashtable pending = this.getAllAlarms();
        Enumeration e = pending.keys();
        while (e.hasMoreElements()) {
            GeneralLogicObjectImpl source = (GeneralLogicObjectImpl)e.nextElement();
            Vector alarms = (Vector)pending.get(source);
            if (alarms == null) continue;
            Enumeration iter = alarms.elements();
            while (iter.hasMoreElements()) {
                AlarmImpl alarm = (AlarmImpl)iter.nextElement();
                if (!alarm.isAcknowledged()) continue;
                acknowledgedPendingAlarms.addElement(alarm);
            }
        }
        return acknowledgedPendingAlarms;
    }

    public Vector getAlarms(GeneralLogicObjectImpl source) throws RemoteException {
        Hashtable allPendingAlarms;
        Vector alarms = super.getAlarms(source);
        if (alarms == null && (allPendingAlarms = this.getAllAlarms()) != null) {
            Enumeration e = allPendingAlarms.keys();
            while (e.hasMoreElements()) {
                GeneralLogicObject key = (GeneralLogicObject)e.nextElement();
                if (source instanceof DRLogicObject) {
                    if (!(key instanceof DRLogicObject) || !key.equals(source) && !((GeneralLogicObjectImpl)key).equalsByCommKey(source)) continue;
                    alarms = (Vector)allPendingAlarms.get(key);
                    break;
                }
                if (!(key instanceof LogicObject) || !((LogicObject)key).getCommKeyClassId().equals(((LogicObject)((Object)source)).getCommKeyClassId())) continue;
                alarms = (Vector)allPendingAlarms.get(key);
                break;
            }
        }
        return alarms;
    }

    public Hashtable getAllAlarms() throws RemoteException {
        return this.list;
    }

    public AlarmImpl getAlarm(AlarmType type, GeneralLogicObject source, VSwitch vSwitch, Object additionalKeyObject) throws RemoteException {
        Vector pendingAlarms = this.getAlarms((GeneralLogicObjectImpl)source);
        if (pendingAlarms != null) {
            Enumeration e = pendingAlarms.elements();
            while (e.hasMoreElements()) {
                Object pendingAdditionalKeyObject;
                VSwitch pendingVSwitch;
                AlarmImpl pendingAlarm = (AlarmImpl)e.nextElement();
                if (!pendingAlarm.getType().equals(type) || !((GeneralLogicObjectImpl)pendingAlarm.getSource()).equalsByCommKey(source) || ((pendingVSwitch = pendingAlarm.getVSwitch()) == null || vSwitch == null || !pendingVSwitch.equals(vSwitch)) && (pendingVSwitch != null || vSwitch != null) || ((pendingAdditionalKeyObject = pendingAlarm.getAdditionalKeyObject()) == null || pendingAdditionalKeyObject == null || !pendingAdditionalKeyObject.equals(additionalKeyObject)) && (pendingAdditionalKeyObject != null || additionalKeyObject != null)) continue;
                return pendingAlarm;
            }
        }
        return null;
    }
}

