/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.alarm;

import com.sanrad.nms.server.RemoteObjectImpl;
import com.sanrad.nms.server.alarm.Alarm;
import com.sanrad.nms.server.alarm.AlarmSeverity;
import com.sanrad.nms.server.alarm.AlarmType;
import com.sanrad.nms.server.alarm.HistoryAlarm;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.GeneralLogicObject;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.util.ClassID;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.HashMap;

public class HistoryAlarmImpl
extends RemoteObjectImpl
implements HistoryAlarm,
Serializable {
    private String closedBy = "";
    private Long closedDateAndTime;
    private String sourceType;
    private String source;
    private String typeDescription;
    private Long dateAndTime;
    private Boolean acknowledged = Boolean.FALSE;
    private String vSwitch = null;
    private String message;
    private String cluster = null;

    public HistoryAlarmImpl(Alarm alarm, String closedBy) throws RemoteException {
        this.closedDateAndTime = new Long(System.currentTimeMillis());
        GeneralLogicObject source = alarm.getSource();
        if (source.getCluster() != null) {
            this.cluster = source.getCluster().getAlias();
        }
        VSwitch vSwitch = alarm.getVSwitch();
        this.sourceType = alarm.getSource().getClassId().toString();
        if (vSwitch != null) {
            if (vSwitch instanceof VSwitch) {
                this.vSwitch = vSwitch.getName();
            } else {
                System.err.println("vSwitch is " + vSwitch + " in HistoryAlarmImpl");
                this.vSwitch = vSwitch.toString();
            }
        } else {
            this.vSwitch = "---";
        }
        if (closedBy != null) {
            this.closedBy = closedBy;
        }
        this.typeDescription = alarm.getType().toString();
        this.dateAndTime = new Long(alarm.getDateAndTime());
        this.acknowledged = new Boolean(alarm.isAcknowledged());
        this.message = alarm.getMessage();
    }

    public String getSource() throws RemoteException {
        return this.source;
    }

    public String getCluster() throws RemoteException {
        return this.cluster;
    }

    public String getVSwitch() throws RemoteException {
        return this.vSwitch;
    }

    public AlarmType getType() throws RemoteException {
        return AlarmType.getAlarmType(this.typeDescription);
    }

    public AlarmSeverity getSeverity() throws RemoteException {
        AlarmType type = this.getType();
        return type == null ? null : this.getType().getSeverity();
    }

    public Long getDateAndTime() throws RemoteException {
        return this.dateAndTime;
    }

    public Boolean isAcknowledged() throws RemoteException {
        return this.acknowledged;
    }

    public String getMessage() throws RemoteException {
        return this.message;
    }

    public ClassID getSourceType() throws RemoteException {
        return ClassID.getClassId(this.sourceType);
    }

    public String getClosedBy() throws RemoteException {
        return this.closedBy;
    }

    public Long getClosedDateAndTime() throws RemoteException {
        return this.closedDateAndTime;
    }

    public boolean equals(Object obj) {
        boolean equal = super.equals(obj);
        if (equal && obj instanceof HistoryAlarm) {
            HistoryAlarmImpl alarmObj = (HistoryAlarmImpl)obj;
            return alarmObj.closedDateAndTime == this.closedDateAndTime && alarmObj.closedBy.equals(this.closedBy);
        }
        return false;
    }

    public HashMap toClientHashMap() throws RemoteException {
        HashMap<ClientParameterCode, Object> alarmToClient = new HashMap<ClientParameterCode, Object>();
        alarmToClient.put(ClientParameterCode.ALARM_SOURCE, this.getSource());
        alarmToClient.put(ClientParameterCode.ALARM_VSWITCH, this.getVSwitch());
        alarmToClient.put(ClientParameterCode.ALARM_SEVERITY, this.getSeverity());
        alarmToClient.put(ClientParameterCode.ALARM_TYPE, this.getType());
        alarmToClient.put(ClientParameterCode.ALARM_DATE_AND_TIME, this.getDateAndTime());
        alarmToClient.put(ClientParameterCode.ALARM_ACKNOWLEDGED, this.isAcknowledged());
        alarmToClient.put(ClientParameterCode.ALARM_MESSAGE, this.getMessage());
        alarmToClient.put(ClientParameterCode.ALARM_SOURCE_TYPE, this.getSourceType());
        alarmToClient.put(ClientParameterCode.ALARM_CLOSED_BY, this.getClosedBy());
        alarmToClient.put(ClientParameterCode.ALARM_CLOSED_DATE_AND_TIME, this.getClosedDateAndTime());
        alarmToClient.put(ClientParameterCode.ALARM_SOURCE_CLUSTER, this.getCluster());
        return alarmToClient;
    }

    public String toString() {
        try {
            StringBuffer strValue = new StringBuffer("Source type: ");
            strValue.append(this.getSourceType());
            strValue.append("; Source: ");
            strValue.append(this.getSource());
            strValue.append("; Cluster: ");
            strValue.append(this.getCluster());
            strValue.append("; ");
            strValue.append(ClassID.VSWITCH);
            strValue.append(": ");
            strValue.append(this.getVSwitch());
            strValue.append("; Severity: ");
            strValue.append(this.getSeverity());
            strValue.append("; Type: ");
            strValue.append(this.getType());
            return strValue.toString();
        }
        catch (RemoteException re) {
            logger.error(re);
            return null;
        }
    }
}

