/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.alarm;

import com.sanrad.nms.server.RemoteObjectImpl;
import com.sanrad.nms.server.alarm.AlarmGenerator;
import com.sanrad.nms.server.alarm.AlarmHistoryIterator;
import com.sanrad.nms.server.alarm.AlarmHistoryList;
import com.sanrad.nms.server.alarm.AlarmList;
import com.sanrad.nms.server.alarm.AlarmMgr;
import com.sanrad.nms.server.alarm.AlarmType;
import com.sanrad.nms.server.alarm.AlarmsNotificationData;
import com.sanrad.nms.server.alarm.PendingAlarmList;
import com.sanrad.nms.server.event.DataMgrListener;
import com.sanrad.nms.server.event.SrElementEvent;
import com.sanrad.nms.server.event.SrEvent;
import com.sanrad.nms.server.event.SrEventHandler;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.GeneralLogicObject;
import com.sanrad.nms.server.logic.GeneralLogicObjectImpl;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.LogicObjectImpl;
import com.sanrad.nms.server.logic.SystemRootImpl;
import com.sanrad.nms.server.logic.VSwitchGroup;
import com.sanrad.nms.server.logic.VSwitchGroupImpl;
import com.sanrad.nms.server.logic.acl.AclEntry;
import com.sanrad.nms.server.logic.acl.AclImpl;
import com.sanrad.nms.server.logic.cluster.Cluster;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.dr.DRRootImpl;
import com.sanrad.nms.server.logic.identity.Credentials;
import com.sanrad.nms.server.logic.identity.IdentityImpl;
import com.sanrad.nms.server.logic.identity.IdentityNameImpl;
import com.sanrad.nms.server.logic.lu.LU;
import com.sanrad.nms.server.logic.target.TargetImpl;
import com.sanrad.nms.server.logic.volume.Volume;
import com.sanrad.nms.server.logic.volume.VolumeNode;
import com.sanrad.nms.server.logic.volume.VolumeNodeImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.ConfigElementDataList;
import com.sanrad.nms.server.mgr.DataMgr;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKey;
import com.sanrad.nms.server.util.Parameter;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.SrBoolean;
import com.sanrad.nms.server.util.types.SrString;
import com.sanrad.nms.server.util.types.constants.DrSiteConstant;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public abstract class GeneralAlarmMgrImpl
extends RemoteObjectImpl
implements AlarmMgr,
DataMgrListener {
    protected Hashtable alarmLists = new Hashtable();
    protected Hashtable pendingAlarmLists = new Hashtable();
    protected AlarmsNotificationData alarmsNotificationData = new AlarmsNotificationData();

    protected GeneralAlarmMgrImpl() throws RemoteException {
        SrEventHandler.getEventMgr().addListener(this);
    }

    protected void finalize() throws Throwable {
        SrEventHandler.getEventMgr().removeListener(this);
        super.finalize();
    }

    protected AlarmList createAlarmList(Integer vSwitchGroupId) throws RemoteException, IllegalValueException {
        if (vSwitchGroupId == null) {
            vSwitchGroupId = DrSiteConstant.DR_VSWITCH_GROUP_ID.getValue();
        }
        AlarmList alarmList = null;
        alarmList = (AlarmList)this.alarmLists.get(vSwitchGroupId);
        if (alarmList == null) {
            alarmList = new AlarmList();
            this.alarmLists.put(vSwitchGroupId, alarmList);
        }
        return alarmList;
    }

    protected PendingAlarmList createPendingAlarmList(Integer vSwitchGroupId) throws RemoteException {
        PendingAlarmList pendingAlarmList = (PendingAlarmList)this.pendingAlarmLists.get(vSwitchGroupId);
        if (pendingAlarmList == null || pendingAlarmList.isListEmpty()) {
            pendingAlarmList = new PendingAlarmList(this.getAlarmList(vSwitchGroupId), vSwitchGroupId);
            this.pendingAlarmLists.put(vSwitchGroupId, pendingAlarmList);
        }
        return pendingAlarmList;
    }

    protected void updateSourceOfAlarms(AlarmList alarmList) throws RemoteException {
    }

    public void removeAlarmList(VSwitchGroupImpl vSwitchGroup) throws RemoteException, IllegalValueException {
        AlarmList alarmList = (AlarmList)this.alarmLists.remove(vSwitchGroup.getVSwitchGroupId());
        if (alarmList != null) {
            alarmList.removeAlarm(vSwitchGroup);
        }
    }

    protected AlarmList getAlarmList(Integer vSwitchGroupId) throws RemoteException {
        AlarmList alarmList = null;
        if (vSwitchGroupId != null) {
            alarmList = (AlarmList)this.alarmLists.get(vSwitchGroupId);
        }
        if (alarmList == null || this.alarmLists == null) {
            try {
                alarmList = this.createAlarmList(vSwitchGroupId);
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
            catch (IllegalValueException e) {
                e.printStackTrace();
            }
        }
        return alarmList;
    }

    protected PendingAlarmList getPendingAlarmList(Integer vSwitchGroupId) throws RemoteException {
        PendingAlarmList pendingAlarmList = (PendingAlarmList)this.pendingAlarmLists.get(vSwitchGroupId);
        if (pendingAlarmList == null) {
            pendingAlarmList = this.createPendingAlarmList(vSwitchGroupId);
        }
        return pendingAlarmList;
    }

    protected AlarmList getAlarmList(VSwitchGroup vSwitchGroup) throws RemoteException {
        if (vSwitchGroup == null) {
            try {
                return this.getAlarmList();
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
            catch (IllegalValueException e) {
                e.printStackTrace();
            }
        }
        return this.getAlarmList(vSwitchGroup.getVSwitchGroupId());
    }

    public void takePendingAlarmList(Cluster cluster) throws RemoteException {
        this.createPendingAlarmList(this.getVswitchGroupId(cluster));
        this.clear(cluster);
    }

    public void clear(Cluster cluster) throws RemoteException {
        AlarmList alarmList = this.getAlarmList(this.getVswitchGroupId(cluster));
        alarmList.clear();
    }

    public Integer getVswitchGroupId(Cluster cluster) throws RemoteException {
        if (cluster == null) {
            return DrSiteConstant.DR_VSWITCH_GROUP_ID.getValue();
        }
        return cluster.getVSwitchGroupId();
    }

    public void takePendingAlarms() throws RemoteException, IllegalValueException {
        AlarmList alarmList = this.getAlarmList();
        this.createPendingAlarmList();
        alarmList.clear();
    }

    protected void closePendingAlarms(VSwitchGroup vSwitchGroup) throws RemoteException {
        SystemRootImpl.setStatusInProcess("Check closing pending alarms for " + vSwitchGroup + "...");
        logger.debug("Check closing for pending alarms");
        PendingAlarmList pendingAlarmList = this.getPendingAlarmList(vSwitchGroup.getVSwitchGroupId());
        AlarmList alarmList = this.getAlarmList(vSwitchGroup);
        if (pendingAlarmList != null) {
            pendingAlarmList.removePendingAlarms(alarmList);
            pendingAlarmList.clear();
            this.pendingAlarmLists.remove(vSwitchGroup.getVSwitchGroupId());
        }
        SystemRootImpl.setStatusReady();
        logger.debug("Done closing pending alarms");
    }

    protected void closePendingAlarms() throws RemoteException, IllegalValueException {
        SystemRootImpl.setStatusInProcess("Check closing for pending alarms...");
        logger.debug("Check closing for pending alarms");
        PendingAlarmList pendingAlarmList = this.getPendingAlarmList();
        if (pendingAlarmList != null) {
            // empty if block
        }
        AlarmList alarmList = this.getAlarmList();
        if (pendingAlarmList != null) {
            pendingAlarmList.removePendingAlarms(alarmList);
        }
        SystemRootImpl.setStatusReady();
        logger.debug("Done closing pending alarms");
    }

    protected void setAlarmsIfNeed(GeneralLogicObjectImpl source, PendingAlarmList pendingAlarmList) throws RemoteException {
        this.setAlarmsIfNeed(source, null, pendingAlarmList);
    }

    protected void setAlarmsIfNeed(GeneralLogicObjectImpl source) throws RemoteException {
        this.setAlarmsIfNeed(source, (PendingAlarmList)null);
    }

    protected void setAlarmsIfNeed(GeneralLogicObjectImpl source, VSwitch vSwitch) throws RemoteException {
        this.setAlarmsIfNeed(source, vSwitch, null);
    }

    public void setAlarmsOnAllVSwitchesIfNeed(GeneralLogicObjectImpl source) throws RemoteException {
        VSwitch[] vSwitches = source.getConnectedVSwitches();
        for (int i = 0; i < vSwitches.length; ++i) {
            this.setAlarmsIfNeed(source, vSwitches[i]);
        }
    }

    protected void setAlarmsIfNeed(GeneralLogicObjectImpl source, VSwitch vSwitch, PendingAlarmList pendingAlarmList) throws RemoteException {
        if (source == null) {
            return;
        }
        AlarmGenerator alarmGenerator = source.getAlarmGenerator();
        if (alarmGenerator != null) {
            if (source.getClassId().equals(ClassID.HARDWARE)) {
                source = (VSwitchImpl)vSwitch;
            }
            Vector openAlarms = alarmGenerator.checkForAlarmsToOpen(source, vSwitch, pendingAlarmList);
            AlarmList alarmList = this.getAlarmList(source.getCluster());
            Vector currentOpenAlarmsOnVSwitch = alarmList.getAlarms(source, vSwitch);
            Vector currentOpenAlarms = alarmList.getAlarms(source, null);
            currentOpenAlarmsOnVSwitch.addAll(currentOpenAlarms);
            Vector closeAlarms = alarmGenerator.checkForAlarmsToClose(source, vSwitch, currentOpenAlarmsOnVSwitch);
            alarmList.removeAlarm(closeAlarms);
            alarmList.addAlarmIfNotExists((GeneralLogicObject)source, openAlarms);
        }
    }

    public Hashtable getAllAlarms(Integer vSwitchGroupId) throws RemoteException {
        if (vSwitchGroupId == null) {
            vSwitchGroupId = DrSiteConstant.DR_VSWITCH_GROUP_ID.getValue();
        }
        AlarmList alarmList = this.getAlarmList(vSwitchGroupId);
        return alarmList.getAllAlarms();
    }

    public Hashtable getAllAlarms(VSwitchGroup vSwitchGroup) throws RemoteException, IllegalValueException {
        return this.getAllAlarms(vSwitchGroup.getVSwitchGroupId());
    }

    public Hashtable getAllAlarms() throws RemoteException {
        Hashtable allAlarms = new Hashtable();
        Iterator i = this.alarmLists.keySet().iterator();
        while (i.hasNext()) {
            Object key = i.next();
            AlarmList alarmList = (AlarmList)this.alarmLists.get(key);
            allAlarms.putAll(alarmList.getAllAlarms());
        }
        return allAlarms;
    }

    public Vector getAlarms(CommKey[] commKeys, ClassID classId) throws RemoteException, IllegalValueException {
        LogicObjectImpl source = (LogicObjectImpl)SystemRootImpl.getInstance().getRefByStub(commKeys, classId);
        return this.getAlarms(source);
    }

    public Vector getAlarms(GeneralLogicObjectImpl source) throws RemoteException {
        if (source == null) {
            return null;
        }
        AlarmList alarmList = this.getAlarmList(source.getCluster());
        return alarmList.getAlarms(source);
    }

    public Vector getAlarms(GeneralLogicObjectImpl source, VSwitch vSwitch) throws RemoteException, IllegalValueException {
        AlarmList alarmList = this.getAlarmList(source.getCluster());
        return alarmList.getAlarms(source, vSwitch);
    }

    public Vector getAlarms(CommKey[] commKeys, ClassID classId, VSwitch vSwitch) throws IllegalValueException, RemoteException {
        LogicObjectImpl source = (LogicObjectImpl)SystemRootImpl.getInstance().getRefByStub(commKeys, classId);
        return this.getAlarms(source, vSwitch);
    }

    public void silentAlarms(Vector alarms) throws RemoteException {
        Iterator i = this.alarmLists.keySet().iterator();
        while (i.hasNext()) {
            AlarmList alarmList = (AlarmList)this.alarmLists.get(i.next());
            alarmList.removeAlarms(alarms, "User", true);
        }
    }

    public AlarmHistoryIterator getAlarmHistoryIterator() throws RemoteException {
        return AlarmHistoryList.getInstance().getAlarmHistoryIterator();
    }

    public int getHistoryAlarmCount() throws RemoteException {
        return AlarmHistoryList.getInstance().getHistoryAlarmCount();
    }

    public void closeAlarmsOnRemovedElement(GeneralLogicObjectImpl source, VSwitch vSwitch) throws RemoteException {
        AlarmList alarmList = this.getAlarmList(source.getCluster());
        alarmList.removeAlarm(source, vSwitch);
        if (source.getConnectedVSwitchCounter() == 0 || vSwitch == null) {
            alarmList.removeAlarm(alarmList.getAlarms(source));
            alarmList.removeAlarm(source);
        }
    }

    public void generateAlarms(ClusterImpl cluster, int eventType, GeneralLogicObjectImpl source, VSwitch vSwitch) throws RemoteException {
        ClassID classId;
        if (source == null) {
            return;
        }
        if (eventType == 3 || source instanceof LogicObjectImpl && ((LogicObjectImpl)source).isMerged()) {
            this.closeAlarmsOnRemovedElement(source, vSwitch);
            if (vSwitch == null) {
                logger.debug("remove alarms element " + source + "the cluster is " + cluster + " " + eventType);
                return;
            }
            if (source.getClassId().equals(ClassID.VSWITCH)) {
                AlarmList alarmList = this.getAlarmList(cluster);
                alarmList.closeAlarmsOnVSwitch(vSwitch);
                this.setAlarmsIfNeed(cluster);
                return;
            }
            if (source.getClassId().equals(ClassID.LUN)) {
                this.setAlarmsIfNeed(cluster);
            }
            if (source.getConnectedVSwitchCounter() > 0 && vSwitch != null) {
                Vector connectedVSwitch;
                Vector<VSwitch> removedVSwitch = new Vector<VSwitch>();
                removedVSwitch.addElement(vSwitch);
                if (cluster != null && !(connectedVSwitch = cluster.getOtherVSwitches(removedVSwitch)).isEmpty() && vSwitch != null) {
                    this.setAlarmsIfNeed(source, (VSwitch)connectedVSwitch.firstElement());
                }
            }
        } else {
            this.setAlarmsIfNeed(source, vSwitch);
        }
        if ((classId = source.getClassId()).equals(ClassID.LUN)) {
            this.setAlarmsIfNeed((GeneralLogicObjectImpl)((TargetImpl)((LU)((Object)source)).getParentTarget()), vSwitch);
            VolumeNodeImpl volume = (VolumeNodeImpl)((LU)((Object)source)).getVolumeChild();
            if (volume != null) {
                this.setAlarmsIfNeed((GeneralLogicObjectImpl)volume, vSwitch);
            }
        } else if (classId.equals(ClassID.IDENTITY_NAME)) {
            this.setAlarmsIfNeed((GeneralLogicObjectImpl)((IdentityImpl)((IdentityNameImpl)source).getIdentityParent()), vSwitch);
        } else if (classId.equals(ClassID.CHAP_CREDENTIALS) || classId.equals(ClassID.SRP_CREDENTIALS)) {
            if (((Credentials)((Object)source)).getIdentityParent() != null) {
                this.setAlarmsIfNeed((GeneralLogicObjectImpl)((IdentityImpl)((Credentials)((Object)source)).getIdentityParent()), vSwitch);
            }
        } else if (classId.equals(ClassID.VSWITCH) || classId.equals(ClassID.NEIGHBORE)) {
            this.setAlarmsIfNeed(cluster);
        } else if (classId.equals(ClassID.ACL_ENTRY)) {
            AclImpl acl = (AclImpl)((AclEntry)((Object)source)).getAclParent();
            TargetImpl target = (TargetImpl)acl.getTargetParent();
            if (!target.isDeletionProcessStarted()) {
                this.setAlarmsIfNeed(acl);
                this.setAlarmsIfNeed((GeneralLogicObjectImpl)target, vSwitch);
            }
        } else if (source instanceof VolumeNode) {
            Vector volChildren;
            Volume parent;
            LU lu = ((VolumeNode)((Object)source)).getParentLU();
            if (lu != null) {
                this.setAlarmsIfNeed((GeneralLogicObjectImpl)((TargetImpl)lu.getParentTarget()), vSwitch);
            }
            if ((parent = ((VolumeNode)((Object)source)).getParentVolume()) != null && parent.getClassId().equals(ClassID.MIRROR_VOLUME) && ((LogicObjectImpl)((Object)parent)).isKnownByVSwitch(vSwitch)) {
                this.setAlarmsIfNeed((GeneralLogicObjectImpl)((VolumeNodeImpl)((Object)parent)), vSwitch);
            }
            if ((volChildren = ((VolumeNode)((Object)source)).getChildren()) != null) {
                Iterator i = volChildren.iterator();
                while (i.hasNext()) {
                    this.generateAlarms(cluster, eventType, (GeneralLogicObjectImpl)i.next(), vSwitch);
                }
            }
        }
    }

    public void generateAlarms(ClusterImpl cluster) throws RemoteException {
        Integer vswitchGroupId = null;
        Vector objects = null;
        if (cluster == null) {
            vswitchGroupId = DrSiteConstant.DR_VSWITCH_GROUP_ID.getValue();
            objects = new Vector(DRRootImpl.getInstance().getDRObjects());
        } else {
            SystemRootImpl.setStatusInProcess("Generate alarms...");
            logger.debug("Generate alarms");
            vswitchGroupId = cluster.getVSwitchGroupId();
            objects = cluster.getCommKeyRefMap().getAllRefs();
        }
        PendingAlarmList pendingAlarmList = this.getPendingAlarmList(vswitchGroupId);
        Enumeration e = objects.elements();
        while (e.hasMoreElements()) {
            GeneralLogicObjectImpl obj = (GeneralLogicObjectImpl)e.nextElement();
            VSwitch[] vSwitches = obj.getConnectedVSwitches();
            for (int i = 0; i < vSwitches.length; ++i) {
                this.setAlarmsIfNeed(obj, vSwitches[i], pendingAlarmList);
            }
        }
        try {
            this.closePendingAlarms();
        }
        catch (IllegalValueException e2) {
            logger.debug(e2);
        }
        if (cluster != null) {
            Enumeration v = cluster.getVSwitches().elements();
            while (v.hasMoreElements()) {
                VSwitchImpl vSwitch = (VSwitchImpl)v.nextElement();
                this.setAlarmsIfNeed((GeneralLogicObjectImpl)vSwitch, pendingAlarmList);
            }
            this.setAlarmsIfNeed((GeneralLogicObjectImpl)cluster, pendingAlarmList);
            this.closePendingAlarms(cluster);
        }
    }

    public void saveCachedClosedAlarms() {
        AlarmHistoryList.getInstance().saveCachedClosedAlarms();
    }

    public void acknowledgeAlarms(Vector alarms, long period, String userName) throws RemoteException {
        Iterator i = this.alarmLists.keySet().iterator();
        while (i.hasNext()) {
            AlarmList alarmList = (AlarmList)this.alarmLists.get(i.next());
            alarmList.acknowledgeAlarms(alarms, userName);
        }
    }

    public void unacknowledgeAlarms(Vector alarms) throws RemoteException {
        Iterator i = this.alarmLists.keySet().iterator();
        while (i.hasNext()) {
            AlarmList alarmList = (AlarmList)this.alarmLists.get(i.next());
            alarmList.unacknowledgeAlarms(alarms);
        }
    }

    private void setAlarmType(ClusterImpl cluster, HashMap parameterList) {
        String name = (String)((SrString)parameterList.get(ParameterCode.ALARM_TYPE_NAME)).value();
        AlarmType alarmType = AlarmType.getAlarmTypeByName(name);
        if (alarmType != null) {
            Object silent;
            Object troubleshooting;
            Object severityParam;
            Object categoryParam;
            Object emailParam = parameterList.get(ParameterCode.ALARM_TYPE_EMAIL);
            if (emailParam != null) {
                Boolean email = (Boolean)((SrBoolean)emailParam).value();
                alarmType.setMailEnabled(email);
            }
            if ((categoryParam = parameterList.get(ParameterCode.ALARM_TYPE_CATEGORY)) != null) {
                String category = (String)((SrString)categoryParam).value();
                alarmType.setCategory(category);
            }
            if ((severityParam = parameterList.get(ParameterCode.ALARM_TYPE_SEVERITY)) != null) {
                String severity = (String)((SrString)severityParam).value();
                alarmType.setAlarmSeverity(severity);
            }
            if ((troubleshooting = parameterList.get(ParameterCode.ALARM_TYPE_TROUBLESHOOTING)) != null) {
                String troubleshoot = (String)((SrString)troubleshooting).value();
                alarmType.setTroubleShooting(troubleshoot);
            }
            if ((silent = parameterList.get(ParameterCode.ALARM_TYPE_SILENT)) != null) {
                String silentStr = (String)((SrString)silent).value();
                alarmType.setSilent(silentStr);
            }
            logger.debug("AlarmType: " + alarmType.toString() + " is set.");
        } else if (cluster != null) {
            logger.warning("AlarmType: " + name + " not found");
        }
    }

    private void setEmailContactData(ClusterImpl cluster, HashMap parameterList) {
        String fromAddress = (String)((SrString)parameterList.get(ParameterCode.EMAIL_CONTACT_FROM_ADDRESS)).value();
        String toAddress = (String)((SrString)parameterList.get(ParameterCode.EMAIL_CONTACT_TO_ADDRESS)).value();
        String smtpHost = (String)((SrString)parameterList.get(ParameterCode.EMAIL_CONTACT_SMTP_HOST)).value();
        String smtpUser = (String)((SrString)parameterList.get(ParameterCode.EMAIL_CONTACT_SMTP_USER)).value();
        String smtpPassword = (String)((SrString)parameterList.get(ParameterCode.EMAIL_CONTACT_SMTP_PASSWORD)).value();
        this.alarmsNotificationData.setContactFromAddress(fromAddress);
        this.alarmsNotificationData.setContactToAddressList(toAddress);
        this.alarmsNotificationData.setContactSMTPHost(smtpHost);
        this.alarmsNotificationData.setContactSMTPPassword(smtpPassword);
        this.alarmsNotificationData.setContactSMTPUser(smtpUser);
        logger.debug("from address: " + fromAddress + " is set.");
        logger.debug("to address: " + toAddress + " is set.");
        logger.debug("smtp server: " + smtpHost + " is set.");
    }

    public AlarmsNotificationData getAlarmsNotificationData() {
        return this.alarmsNotificationData;
    }

    public Vector getEmailEnabledAlarmTypes() throws RemoteException {
        Vector types = AlarmType.getAllAlarmTypes();
        Vector<AlarmType> emailEnabledTypes = new Vector<AlarmType>();
        for (int i = 0; i < types.size(); ++i) {
            AlarmType type = (AlarmType)types.get(i);
            if (!type.isMailEnabled()) continue;
            emailEnabledTypes.addElement(type);
        }
        return emailEnabledTypes;
    }

    public HashMap getTroubleShootingMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        Vector alarmTypes = AlarmType.getAllAlarmTypes();
        Enumeration iter = alarmTypes.elements();
        while (iter.hasMoreElements()) {
            AlarmType type = (AlarmType)iter.nextElement();
            map.put(type.getAlarmId(), type.getTroubleShooting());
        }
        return map;
    }

    public HashMap getEmailContactParameters() throws RemoteException {
        HashMap<ClientParameterCode, String> parameters = new HashMap<ClientParameterCode, String>();
        parameters.put(ClientParameterCode.EMAIL_CONTACT_FROM_ADDRESS, this.alarmsNotificationData.getContactFromAddress());
        parameters.put(ClientParameterCode.EMAIL_CONTACT_TO_ADDRESS, this.alarmsNotificationData.getContactToAddressList());
        parameters.put(ClientParameterCode.EMAIL_CONTACT_SMTP_HOST, this.alarmsNotificationData.getContactSMTPHost());
        parameters.put(ClientParameterCode.EMAIL_CONTACT_SMTP_USER, this.alarmsNotificationData.getContactSMTPUser());
        parameters.put(ClientParameterCode.EMAIL_CONTACT_SMTP_PASSWORD, this.alarmsNotificationData.getContactSMTPPassword());
        return parameters;
    }

    public void setEmailContactParameters(HashMap parameters) throws RemoteException {
        Object fromAddress = parameters.get(ClientParameterCode.EMAIL_CONTACT_FROM_ADDRESS);
        Object toAddress = parameters.get(ClientParameterCode.EMAIL_CONTACT_TO_ADDRESS);
        Object smtpHost = parameters.get(ClientParameterCode.EMAIL_CONTACT_SMTP_HOST);
        Object smtpUser = parameters.get(ClientParameterCode.EMAIL_CONTACT_SMTP_USER);
        Object smtpPassword = parameters.get(ClientParameterCode.EMAIL_CONTACT_SMTP_PASSWORD);
        if (fromAddress != null) {
            this.alarmsNotificationData.setContactFromAddress((String)fromAddress);
        }
        if (toAddress != null) {
            this.alarmsNotificationData.setContactToAddressList((String)toAddress);
        }
        if (smtpHost != null) {
            this.alarmsNotificationData.setContactSMTPHost((String)smtpHost);
        }
        if (smtpUser != null) {
            this.alarmsNotificationData.setContactSMTPUser((String)smtpUser);
        }
        if (smtpPassword != null) {
            this.alarmsNotificationData.setContactSMTPPassword((String)smtpPassword);
        }
        this.saveEmailContactConfiguration();
    }

    private void saveEmailContactConfiguration() throws RemoteException {
        ConfigElementData element = new ConfigElementData(ClassID.EMAIL_CONTACT);
        String from = this.alarmsNotificationData.getContactFromAddress();
        String to = this.alarmsNotificationData.getContactToAddressList();
        String host = this.alarmsNotificationData.getContactSMTPHost();
        String smtpUser = this.alarmsNotificationData.getContactSMTPUser();
        String smtpPassword = this.alarmsNotificationData.getContactSMTPPassword();
        if (from != null) {
            element.addParameter(new Parameter(ParameterCode.EMAIL_CONTACT_FROM_ADDRESS, new SrString(from)));
        }
        if (to != null) {
            element.addParameter(new Parameter(ParameterCode.EMAIL_CONTACT_TO_ADDRESS, new SrString(to)));
        }
        if (host != null) {
            element.addParameter(new Parameter(ParameterCode.EMAIL_CONTACT_SMTP_HOST, new SrString(host)));
        }
        if (smtpUser != null) {
            element.addParameter(new Parameter(ParameterCode.EMAIL_CONTACT_SMTP_USER, new SrString(smtpUser)));
        }
        if (smtpPassword != null) {
            element.addParameter(new Parameter(ParameterCode.EMAIL_CONTACT_SMTP_PASSWORD, new SrString(smtpPassword)));
        }
        DataMgr.getInstance().changeElement(element);
    }

    public void setEmailEnabledAlarmTypes(Vector enabledAlarmTypes, Vector disabledAlarmTypes) throws RemoteException, IllegalValueException {
        AlarmType alarmType;
        AlarmType clientAlarmType;
        int i;
        Vector<AlarmType> types = new Vector<AlarmType>(enabledAlarmTypes.size() + disabledAlarmTypes.size());
        for (i = 0; i < enabledAlarmTypes.size(); ++i) {
            clientAlarmType = (AlarmType)enabledAlarmTypes.get(i);
            alarmType = AlarmType.getAlarmType(clientAlarmType.toString());
            alarmType.setMailEnabled(true);
            types.addElement(alarmType);
        }
        for (i = 0; i < disabledAlarmTypes.size(); ++i) {
            clientAlarmType = (AlarmType)disabledAlarmTypes.get(i);
            alarmType = AlarmType.getAlarmType(clientAlarmType.toString());
            alarmType.setMailEnabled(false);
            types.addElement(alarmType);
        }
        this.saveAlarmConfiguration(types);
    }

    private void saveAlarmConfiguration(Vector alarmTypes) throws RemoteException, IllegalValueException {
        ConfigElementDataList elementList = new ConfigElementDataList();
        for (int i = 0; i < alarmTypes.size(); ++i) {
            AlarmType type = (AlarmType)alarmTypes.get(i);
            ConfigElementData element = new ConfigElementData(ClassID.ALARM_TYPE);
            element.addParameter(new Parameter(ParameterCode.ALARM_TYPE_NAME, new SrString(type.getName())));
            element.addParameter(new Parameter(ParameterCode.ALARM_TYPE_EMAIL, new SrBoolean(type.isMailEnabled())));
            elementList.addElement(element);
        }
        DataMgr.getInstance().changeElementAsync(elementList);
    }

    public void elementEvent(SrEvent event) {
        int eventType = event.getType();
        if (eventType == 1 || eventType == 2) {
            ClusterImpl relevantCluster = null;
            SrElementEvent eventElement = (SrElementEvent)event;
            ConfigElementDataList cedList = eventElement.getElements();
            Enumeration iter = cedList.elements();
            while (iter.hasMoreElements()) {
                ConfigElementData ced = (ConfigElementData)iter.nextElement();
                if (ced.getClassId().equals(ClassID.ALARM_TYPE)) {
                    this.setAlarmType(relevantCluster, ced.getParametersList());
                    continue;
                }
                if (!ced.getClassId().equals(ClassID.EMAIL_CONTACT)) continue;
                this.setEmailContactData(relevantCluster, ced.getParametersList());
            }
        }
    }

    public void clearPendingAlarms(Cluster cluster) throws RemoteException {
        this.getPendingAlarmList(this.getVswitchGroupId(cluster)).clear();
    }

    public void vSwitchGroupWasRemoved(VSwitchGroup vSwitchGroup) throws RemoteException {
        this.alarmLists.remove(vSwitchGroup.getVSwitchGroupId());
        this.pendingAlarmLists.remove(vSwitchGroup.getVSwitchGroupId());
    }

    protected abstract AlarmList createAlarmList() throws RemoteException, IllegalValueException;

    protected abstract PendingAlarmList createPendingAlarmList() throws IllegalValueException, RemoteException;

    protected abstract AlarmList getAlarmList() throws RemoteException, IllegalValueException;

    protected abstract PendingAlarmList getPendingAlarmList() throws IllegalValueException, RemoteException;
}

