/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.alarm;

import com.sanrad.nms.server.alarm.Alarm;
import com.sanrad.nms.server.alarm.AlarmGenerator;
import com.sanrad.nms.server.alarm.AlarmType;
import com.sanrad.nms.server.logic.GeneralAliasObject;
import com.sanrad.nms.server.logic.GeneralLogicObject;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Vector;

public abstract class AliasObjectAlarmGenerator
extends AlarmGenerator {
    protected AliasObjectAlarmGenerator() {
    }

    public Vector checkForAlarmsToOpen(GeneralLogicObject source, VSwitch vSwitch) throws RemoteException {
        GeneralAliasObject aliasObject = (GeneralAliasObject)source;
        Vector openAlarms = super.checkForAlarmsToOpen(source, vSwitch);
        String[] aliases = aliasObject.checkAliasConsistencyBetweenVSwitches();
        if (aliases != null) {
            StringBuffer msg = new StringBuffer("The ");
            msg.append(source.getClassId());
            msg.append(" ");
            msg.append(source.toString());
            msg.append(" has two different aliases (");
            msg.append(aliases[0]);
            msg.append(", ");
            if (aliases[1] != null) {
                msg.append(aliases[1]);
            }
            msg.append(")");
            this.addAlarm(openAlarms, AlarmType.ALIAS_INCONS, source, msg.toString());
        }
        return openAlarms;
    }

    public Vector checkForAlarmsToClose(GeneralLogicObject source, VSwitch vSwitch, Vector openAlarms) throws RemoteException {
        GeneralAliasObject aliasObject = (GeneralAliasObject)source;
        Vector closeAlarms = super.checkForAlarmsToClose(source, vSwitch, openAlarms);
        Enumeration e = openAlarms.elements();
        while (e.hasMoreElements()) {
            Alarm alarm = (Alarm)e.nextElement();
            if (!alarm.getType().equals(AlarmType.ALIAS_INCONS) || aliasObject.checkAliasConsistencyBetweenVSwitches() != null) continue;
            closeAlarms.addElement(alarm);
        }
        return closeAlarms;
    }
}

