/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.alarm;

import java.io.Serializable;

public class AlarmSeverity
implements Serializable {
    private static final String NAME_OK = "OK";
    private static final String NAME_WARNING = "WARNING";
    private static final String NAME_MINOR = "MINOR";
    private static final String NAME_MAJOR = "MAJOR";
    private static final String NAME_CRITICAL = "CRITICAL";
    public static final AlarmSeverity OK = new AlarmSeverity("OK");
    public static final AlarmSeverity WARNING = new AlarmSeverity("WARNING");
    public static final AlarmSeverity MINOR = new AlarmSeverity("MINOR");
    public static final AlarmSeverity MAJOR = new AlarmSeverity("MAJOR");
    public static final AlarmSeverity CRITICAL = new AlarmSeverity("CRITICAL");
    private static int counter = 0;
    private String name;
    private int severity;

    private AlarmSeverity(String name) {
        this.name = name;
        this.severity = counter++;
    }

    public boolean isMoreSevereThan(AlarmSeverity alarmSeverity) {
        return alarmSeverity.severity < this.severity;
    }

    public boolean isLessSevereThan(AlarmSeverity alarmSeverity) {
        return alarmSeverity.severity > this.severity;
    }

    public boolean equals(Object obj) {
        if (obj instanceof AlarmSeverity) {
            return ((AlarmSeverity)obj).severity == this.severity;
        }
        return false;
    }

    public static AlarmSeverity getAlarmSeverity(String name) {
        if (name.equalsIgnoreCase(NAME_OK)) {
            return OK;
        }
        if (name.equalsIgnoreCase(NAME_WARNING)) {
            return WARNING;
        }
        if (name.equalsIgnoreCase(NAME_MINOR)) {
            return MINOR;
        }
        if (name.equalsIgnoreCase(NAME_MAJOR)) {
            return MAJOR;
        }
        if (name.equalsIgnoreCase(NAME_CRITICAL)) {
            return CRITICAL;
        }
        return null;
    }

    public static AlarmSeverity moreSevere(AlarmSeverity alarmSeverity1, AlarmSeverity alarmSeverity2) {
        if (alarmSeverity1.isMoreSevereThan(alarmSeverity2)) {
            return alarmSeverity1;
        }
        return alarmSeverity2;
    }

    public String toString() {
        return this.name;
    }
}

