/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.alarm;

import com.sanrad.log.Log;
import com.sanrad.log.LogMgr;
import com.sanrad.nms.server.Server;
import com.sanrad.nms.server.alarm.Alarm;
import com.sanrad.nms.server.alarm.AlarmHistoryList;
import com.sanrad.nms.server.alarm.AlarmImpl;
import com.sanrad.nms.server.alarm.AlarmMgrImpl;
import com.sanrad.nms.server.alarm.AlarmSeverity;
import com.sanrad.nms.server.alarm.AlarmsNotificationData;
import com.sanrad.nms.server.alarm.event.AlarmChangedEvent;
import com.sanrad.nms.server.alarm.event.AlarmChangedListener;
import com.sanrad.nms.server.alarm.event.AlarmEvent;
import com.sanrad.nms.server.alarm.event.AlarmEventImpl;
import com.sanrad.nms.server.alarm.event.AlarmEventListener;
import com.sanrad.nms.server.logic.EventServiceImpl;
import com.sanrad.nms.server.logic.GeneralLogicObject;
import com.sanrad.nms.server.logic.GeneralLogicObjectImpl;
import com.sanrad.nms.server.logic.LogicObject;
import com.sanrad.nms.server.logic.LogicObjectImpl;
import com.sanrad.nms.server.logic.SystemRootImpl;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterLogicObjectImpl;
import com.sanrad.nms.server.logic.dr.DRLogicObject;
import com.sanrad.nms.server.logic.dr.DRLogicObjectImpl;
import com.sanrad.nms.server.logic.dr.DRRootImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.user.UserManagerImpl;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKey;
import com.sanrad.nms.server.util.types.constants.DrSiteConstant;
import com.sanrad.security.StringCodec;
import com.sanrad.util.MailSender;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;

public class AlarmList
implements Cloneable,
AlarmChangedListener {
    protected Hashtable list = new Hashtable();
    private Vector listeners = new Vector();
    private static Log logger = LogMgr.getServerLog();
    private static MailSender mailSender = new MailSender();
    private static String from = null;
    private static String host = null;
    private static String to = null;
    private static String smtpUser = null;
    private static String smtpPassword = null;

    public AlarmList() throws RemoteException {
        this.setEmailParameters();
    }

    private void setEmailParameters() throws RemoteException {
        String key = UserManagerImpl.getInstance().getCodecKey();
        AlarmsNotificationData data = AlarmMgrImpl.getInstance().getAlarmsNotificationData();
        from = data.getContactFromAddress();
        host = data.getContactSMTPHost();
        to = data.getContactToAddressList();
        smtpUser = data.getContactSMTPUser();
        smtpPassword = StringCodec.decryptString(key, data.getContactSMTPPassword());
    }

    protected AlarmList(AlarmList alarmList) throws RemoteException {
        this.list = (Hashtable)alarmList.list.clone();
    }

    public void setAlarmList(Hashtable alarmLists) {
        this.list = alarmLists;
    }

    public AlarmList(Hashtable alarmLists) {
        AlarmList alarmList = (AlarmList)alarmLists.get(DrSiteConstant.DR_VSWITCH_GROUP_ID.getValue());
        this.list = alarmList.list;
    }

    private boolean isAlarmAlreadyExists(Alarm alarm) throws RemoteException {
        Vector alarms = this.getAlarms((GeneralLogicObjectImpl)alarm.getSource(), alarm.getVSwitch());
        Enumeration e = alarms.elements();
        while (e.hasMoreElements()) {
            Alarm openedAlarm = (Alarm)e.nextElement();
            if (!openedAlarm.equals(alarm)) continue;
            return true;
        }
        return false;
    }

    public synchronized void addAlarmEventListener(AlarmEventListener listener) {
        this.listeners.addElement(listener);
    }

    public synchronized void removeAlarmEventListener(AlarmEventListener listener) {
        this.listeners.remove(listener);
    }

    private AlarmEvent getAlarmEvent(Alarm alarm) throws RemoteException {
        return new AlarmEventImpl(alarm.getSource(), alarm);
    }

    public synchronized void addAlarmIfNotExists(GeneralLogicObject source, Vector alarms) throws RemoteException {
        Enumeration e = alarms.elements();
        while (e.hasMoreElements()) {
            this.addAlarmIfNotExists(source, (Alarm)e.nextElement());
        }
    }

    public synchronized void addAlarmIfNotExists(GeneralLogicObject source, Alarm alarm) throws RemoteException {
        if (!this.isAlarmAlreadyExists(alarm)) {
            Vector<Alarm> alarms = this.getAlarms((GeneralLogicObjectImpl)alarm.getSource());
            StringBuffer debugMsg = new StringBuffer("Alarm ");
            debugMsg.append(alarm.getType());
            debugMsg.append(" on source ");
            debugMsg.append(alarm.getSource());
            if (alarm.getVSwitch() != null) {
                debugMsg.append(" on ");
                debugMsg.append(ClassID.VSWITCH);
                debugMsg.append(" ");
                debugMsg.append(alarm.getVSwitch());
            }
            debugMsg.append(" was added to AlarmList");
            ((AlarmImpl)alarm).addAlarmChangedListener(this);
            if (alarms == null) {
                alarms = new Vector<Alarm>();
                alarms.addElement(alarm);
                this.list.put(source, alarms);
                debugMsg.append(" - this is the first alarm on this source");
            } else {
                alarms.addElement(alarm);
            }
            logger.debug(debugMsg.toString());
            this.notifySourceNewState(alarm.getSource());
            if (!((AlarmImpl)alarm).isReopened()) {
                AlarmEvent event = this.getAlarmEvent(alarm);
                Enumeration e = this.listeners.elements();
                while (e.hasMoreElements()) {
                    AlarmEventListener listener = (AlarmEventListener)e.nextElement();
                    listener.alarmOpened(event);
                }
                if (!(event.getSource() instanceof DRClusterLogicObjectImpl)) {
                    EventServiceImpl.getInstance().fireAlarmOpened(event);
                }
                this.setEmailParameters();
                if (alarm.getType().isMailEnabled() && to != null) {
                    logger.debug("Sending Email about alarm: '" + alarm.getType().toString() + "'" + " to - " + to);
                    mailSender.initMessage(host, smtpUser, smtpPassword, from, to, "Alarm from " + Server.FULL_PRODUCT_NAME + ": " + alarm.getMessage());
                    mailSender.sendMail(((AlarmImpl)alarm).getAlarmEmailText());
                }
            }
        }
    }

    public synchronized void removeAlarm(GeneralLogicObjectImpl source, VSwitch vSwitch) throws RemoteException {
        this.removeAlarm(this.getAlarms(source, vSwitch));
    }

    public synchronized void removeAlarm(GeneralLogicObjectImpl source) throws RemoteException {
        this.removeAlarm(this.getAlarms(source, null));
    }

    public synchronized void removeAlarm(Vector alarms) throws RemoteException {
        this.removeAlarms(alarms, null, false);
    }

    public synchronized void removeAlarms(Vector alarms, String removedBy, boolean isSilent) throws RemoteException {
        if (alarms != null && !alarms.isEmpty()) {
            Object[] alarmsObj = alarms.toArray();
            int i = alarmsObj.length;
            while (i-- > 0) {
                this.removeAlarm((Alarm)alarmsObj[i], removedBy, isSilent);
            }
        }
    }

    public synchronized void removeAlarm(Alarm alarm) throws RemoteException {
        this.removeAlarm(alarm, null);
    }

    private void removeAlarm(Alarm alarm, String removedBy) throws RemoteException {
        this.removeAlarm(alarm, removedBy, false);
    }

    public synchronized void removeAlarm(Alarm alarm, String removedBy, boolean isRemovedByUser) throws RemoteException {
        AlarmImpl alarmImpl;
        Vector alarms;
        GeneralLogicObject source = alarm.getSource();
        GeneralLogicObjectImpl sourceImpl = null;
        if (source instanceof DRLogicObject) {
            if (source instanceof DRLogicObjectImpl) {
                alarms = this.getAlarms(source);
                sourceImpl = (GeneralLogicObjectImpl)source;
            } else {
                sourceImpl = DRRootImpl.getInstance().getDRObject((DRLogicObject)source);
                alarms = this.getAlarms(sourceImpl);
            }
        } else if (source instanceof LogicObjectImpl) {
            alarms = this.getAlarms(((LogicObject)source).getCommKeys(), source.getClassId());
            sourceImpl = (GeneralLogicObjectImpl)source;
        } else {
            sourceImpl = (LogicObjectImpl)SystemRootImpl.getInstance().getRefByStub(((LogicObject)source).getCommKeys(), source.getClassId());
            alarms = this.getAlarms(((LogicObject)source).getCommKeys(), source.getClassId());
        }
        if (alarms != null && (alarmImpl = this.getAlarmImplFromAlarm(alarm)) != null) {
            alarmImpl.removeAlarmChangedListener(this);
            boolean closedAlarmSucceeded = false;
            if (isRemovedByUser) {
                alarmImpl.setSilent();
                closedAlarmSucceeded = true;
            } else {
                closedAlarmSucceeded = alarms.removeElement(alarmImpl);
            }
            StringBuffer debugMsg = new StringBuffer("Alarm ");
            debugMsg.append(alarm.getType());
            debugMsg.append(" on source ");
            debugMsg.append(alarm.getSource());
            if (alarm.getVSwitch() != null) {
                debugMsg.append(" on ");
                debugMsg.append(ClassID.VSWITCH);
                debugMsg.append(" ");
                debugMsg.append(alarm.getVSwitch());
            }
            if (closedAlarmSucceeded) {
                debugMsg.append(" was removed from AlarmList");
                if (alarms.isEmpty() && !isRemovedByUser) {
                    this.list.remove(alarm.getSource());
                    debugMsg.append(" - this was the last alarm on this source");
                }
                logger.debug(debugMsg.toString());
                if (isRemovedByUser || !alarmImpl.isSilent()) {
                    this.addToHistory(alarm, removedBy, false, sourceImpl);
                }
            } else {
                debugMsg.insert(0, "Failed to remove ");
                logger.warning(debugMsg.toString());
            }
        }
    }

    public void addToHistory(Vector alarms, boolean pendingAlarm) throws RemoteException {
        Enumeration e = alarms.elements();
        while (e.hasMoreElements()) {
            Alarm alarm = (Alarm)e.nextElement();
            this.addToHistory(alarm, null, pendingAlarm, (GeneralLogicObjectImpl)alarm.getSource());
        }
    }

    protected void addToHistory(Alarm alarm, String removedBy, boolean pendingAlarm, GeneralLogicObjectImpl element) throws RemoteException {
        if (!pendingAlarm) {
            this.notifySourceNewState(element);
            if (alarm.getSource() != null) {
                AlarmEvent event = this.getAlarmEvent(alarm);
                Enumeration e = this.listeners.elements();
                while (e.hasMoreElements()) {
                    AlarmEventListener listener = (AlarmEventListener)e.nextElement();
                    listener.alarmClosed(event);
                }
                EventServiceImpl.getInstance().fireAlarmClosed(event);
            }
        }
        AlarmHistoryList.getInstance().addToAlarmHistoryList(alarm, removedBy);
    }

    public synchronized void removeAlarm(Alarm[] alarms) throws RemoteException {
        this.removeAlarm(alarms, null);
    }

    public synchronized void removeAlarm(Alarm[] alarms, String removedBy) throws RemoteException {
        for (int i = 0; i < alarms.length; ++i) {
            this.removeAlarm(alarms[i], removedBy);
        }
    }

    public Vector getAlarms(GeneralLogicObjectImpl source, VSwitch vSwitch) throws RemoteException {
        Vector<Alarm> alarms = new Vector<Alarm>();
        Vector allAlarms = this.getAlarms(source);
        if (allAlarms != null) {
            Enumeration e = allAlarms.elements();
            while (e.hasMoreElements()) {
                Alarm alarm = (Alarm)e.nextElement();
                if ((alarm.getVSwitch() == null || !alarm.getVSwitch().equals(vSwitch)) && (vSwitch != null || alarm.getVSwitch() != null)) continue;
                alarms.addElement(alarm);
            }
        }
        return alarms;
    }

    public Hashtable getAllAlarms() throws RemoteException {
        Hashtable sendList = new Hashtable();
        Iterator iter = this.list.keySet().iterator();
        while (iter.hasNext()) {
            GeneralLogicObject key = (GeneralLogicObject)iter.next();
            Vector alarms = (Vector)this.list.get(key);
            if (alarms == null) continue;
            Vector sendAlarms = new Vector();
            for (int i = 0; i < alarms.size(); ++i) {
                if (((Alarm)alarms.get(i)).isSilent()) continue;
                sendAlarms.add(alarms.get(i));
            }
            if (sendAlarms.isEmpty()) continue;
            sendList.put(key, sendAlarms);
        }
        return sendList;
    }

    public Vector getAllAlarmsOnVSwitch(VSwitch vSwitch) throws RemoteException {
        Vector alarmsOnVSwitch = new Vector();
        Enumeration e = this.getAllAlarms().keys();
        while (e.hasMoreElements()) {
            LogicObjectImpl source = (LogicObjectImpl)e.nextElement();
            Vector alarms = this.getAlarms(source, vSwitch);
            alarmsOnVSwitch.addAll(alarms);
        }
        return alarmsOnVSwitch;
    }

    public Vector getAlarms(CommKey[] sourceCommKey, ClassID sourceClassId) throws RemoteException {
        LogicObjectImpl source = (LogicObjectImpl)SystemRootImpl.getInstance().getRefByStub(sourceCommKey, sourceClassId);
        if (source != null) {
            return this.getAlarms(source);
        }
        logger.warning("Source " + sourceClassId + ", " + sourceCommKey + " is null");
        return null;
    }

    public Vector getAlarms(GeneralLogicObjectImpl source) throws RemoteException {
        return (Vector)this.list.get(source);
    }

    public Vector getAlarms(GeneralLogicObject source) throws RemoteException {
        if (source instanceof DRLogicObject) {
            return this.getAlarms(DRRootImpl.getInstance().getDRObject((DRLogicObject)source));
        }
        return this.getAlarms(((LogicObject)source).getCommKeys(), ((LogicObject)source).getClassId());
    }

    private GeneralLogicObject notifySourceNewState(GeneralLogicObject source) throws RemoteException {
        AlarmSeverity newState;
        boolean stateModified;
        if (source != null && (stateModified = source.setStateSeverity(newState = this.getState(source)))) {
            this.notifySourceNewAcknowledgeState(source);
        }
        return source;
    }

    private void notifySourceNewAcknowledgeState(GeneralLogicObject source) throws RemoteException {
        AlarmSeverity newAckState = this.getAckState(source);
        source.setAcknowledgeStateSeverity(newAckState);
    }

    public void clear() {
        this.list.clear();
    }

    private synchronized AlarmSeverity getState(GeneralLogicObject source) throws RemoteException {
        Vector alarms = this.getAlarms(source);
        AlarmSeverity severity = AlarmSeverity.OK;
        if (alarms != null) {
            Enumeration e = alarms.elements();
            while (e.hasMoreElements()) {
                AlarmSeverity alarmSeverity;
                Alarm alarm = (Alarm)e.nextElement();
                if (alarm.isSilent() || !(alarmSeverity = alarm.getSeverity()).isMoreSevereThan(severity)) continue;
                severity = alarmSeverity;
            }
        }
        return severity;
    }

    private synchronized AlarmSeverity getAckState(GeneralLogicObject source) throws RemoteException {
        Vector alarms = this.getAlarms(source);
        AlarmSeverity severity = AlarmSeverity.OK;
        if (alarms != null) {
            Enumeration e = alarms.elements();
            while (e.hasMoreElements()) {
                AlarmSeverity alarmSeverity;
                Alarm alarm = (Alarm)e.nextElement();
                if (alarm.isAcknowledged() || alarm.isSilent() || !(alarmSeverity = alarm.getSeverity()).isMoreSevereThan(severity)) continue;
                severity = alarmSeverity;
            }
        }
        return severity;
    }

    public Object clone() {
        try {
            AlarmList newList = new AlarmList();
            newList.list = (Hashtable)this.list.clone();
            return newList;
        }
        catch (RemoteException re) {
            logger.error(re);
            return null;
        }
    }

    public void closeAlarmsOnVSwitch(VSwitch vSwitch) throws RemoteException {
        Vector alarms = this.getAllAlarmsOnVSwitch(vSwitch);
        this.removeAlarm(alarms);
        alarms = this.getAllAlarmsOnVSwitch(null);
        this.removeAlarm(alarms);
    }

    public synchronized void acknowledgePendingAlarms(Vector pendingAlarms) throws RemoteException {
        if (pendingAlarms != null) {
            Enumeration e = pendingAlarms.elements();
            while (e.hasMoreElements()) {
                Alarm alarm = (Alarm)e.nextElement();
                this.acknowledgeAlarm(alarm, true, alarm.getAcknowledgedBy(), alarm.getAckDateAndTime());
            }
        }
    }

    public synchronized void acknowledgeAlarms(Vector alarms, String ackBy) throws RemoteException {
        if (alarms != null) {
            Enumeration e = alarms.elements();
            while (e.hasMoreElements()) {
                this.acknowledgeAlarm((Alarm)e.nextElement(), true, ackBy);
            }
        }
    }

    public synchronized void unacknowledgeAlarms(Vector alarms) throws RemoteException {
        if (alarms != null) {
            Enumeration e = alarms.elements();
            while (e.hasMoreElements()) {
                this.unAcknowledgeAlarm((Alarm)e.nextElement());
            }
        }
    }

    private boolean compare(Alarm alarm, Alarm otherAlarm) throws RemoteException {
        boolean isSourceEqual;
        if (alarm.equals(otherAlarm)) {
            return true;
        }
        if (!(alarm.getSource() instanceof DRLogicObject)) {
            if (otherAlarm.getSource() instanceof DRLogicObject) {
                return false;
            }
            isSourceEqual = ((LogicObject)alarm.getSource()).getCommKeyClassId().equals(((LogicObject)otherAlarm.getSource()).getCommKeyClassId());
        } else {
            isSourceEqual = alarm.getSource().hashKey().equals(alarm.getSource().hashKey());
        }
        boolean isTypeEqual = alarm.getType().equals(otherAlarm.getType());
        boolean isVSwitchEqual = alarm.getVSwitch() != null && otherAlarm.getVSwitch() != null ? alarm.getVSwitch().getCommKeyClassId().equals(otherAlarm.getVSwitch().getCommKeyClassId()) : alarm.getVSwitch() == null && otherAlarm.getVSwitch() == null;
        Object alarmAdditionalKeyObject = alarm.getAdditionalKeyObject();
        Object otherAlarmAdditionalKeyObject = otherAlarm.getAdditionalKeyObject();
        boolean isAdditionalKeyEqual = alarmAdditionalKeyObject != null && otherAlarmAdditionalKeyObject != null ? (alarmAdditionalKeyObject instanceof LogicObject && otherAlarmAdditionalKeyObject instanceof LogicObject ? ((LogicObject)alarmAdditionalKeyObject).getCommKeyClassId().equals(((LogicObject)otherAlarmAdditionalKeyObject).getCommKeyClassId()) : alarmAdditionalKeyObject.equals(otherAlarmAdditionalKeyObject)) : alarmAdditionalKeyObject == null && otherAlarmAdditionalKeyObject == null;
        return isSourceEqual && isTypeEqual && isVSwitchEqual && isAdditionalKeyEqual;
    }

    protected void unAcknowledgeAlarm(Alarm alarm) throws RemoteException {
        this.acknowledgeAlarm(alarm, false, "");
    }

    protected void acknowledgeAlarm(Alarm alarm, boolean ack, String ackBy) throws RemoteException {
        this.acknowledgeAlarm(alarm, ack, ackBy, 0L);
    }

    protected void acknowledgeAlarm(Alarm alarm, boolean ack, String ackBy, long dateAndTime) throws RemoteException {
        AlarmImpl alarmToAck = this.getAlarmImplFromAlarm(alarm);
        if (alarmToAck != null) {
            String debugMsgSuffix;
            if (ack) {
                debugMsgSuffix = " was acknowledged by " + ackBy;
                if (dateAndTime > 0L) {
                    alarmToAck.setAcknowledged(ackBy, dateAndTime);
                } else {
                    alarmToAck.setAcknowledged(ackBy);
                }
            } else {
                debugMsgSuffix = " was unacknowledged";
                alarmToAck.setUnacknowledged();
            }
            StringBuffer debugMsg = new StringBuffer("Alarm ");
            debugMsg.append(alarmToAck.getType());
            debugMsg.append(" on source ");
            debugMsg.append(alarmToAck.getSource());
            if (alarmToAck.getVSwitch() != null) {
                debugMsg.append(" on ");
                debugMsg.append(ClassID.VSWITCH);
                debugMsg.append(" ");
                debugMsg.append(alarmToAck.getVSwitch());
            }
            debugMsg.append(debugMsgSuffix);
            logger.debug(debugMsg.toString());
        }
    }

    private AlarmImpl getAlarmImplFromAlarm(Alarm alarm) throws RemoteException {
        if (alarm instanceof AlarmImpl) {
            return (AlarmImpl)alarm;
        }
        GeneralLogicObject source = alarm.getSource();
        Vector alarms = null;
        if (source instanceof DRLogicObject) {
            DRLogicObjectImpl sourceImpl = DRRootImpl.getInstance().getDRObject((DRLogicObject)source);
            if (sourceImpl != null) {
                alarms = this.getAlarms((GeneralLogicObject)sourceImpl);
            }
        } else {
            alarms = this.getAlarms(((LogicObject)source).getCommKeys(), source.getClassId());
        }
        if (alarms != null && !alarms.isEmpty()) {
            for (int i = 0; i < alarms.size(); ++i) {
                Alarm nextAlarm = (Alarm)alarms.get(i);
                if (!this.compare(alarm, nextAlarm)) continue;
                return (AlarmImpl)nextAlarm;
            }
        }
        return null;
    }

    public void acknowledgeAlarmStateChanged(AlarmChangedEvent event) {
        Object source = null;
        try {
            source = event.getSourceObject() instanceof DRLogicObject ? this.findDrObjectFromStub(event.getSourceObject()) : SystemRootImpl.getInstance().getRefByStub(((LogicObject)event.getSourceObject()).getCommKeyClassId());
            this.notifySourceNewAcknowledgeState((GeneralLogicObject)source);
        }
        catch (RemoteException re) {
            logger.error(re);
        }
    }

    private Object findDrObjectFromStub(GeneralLogicObject sourceObject) throws RemoteException {
        ArrayList list = DRRootImpl.getInstance().getDRObjects();
        for (int i = 0; i < list.size(); ++i) {
            if (!((DRLogicObject)list.get(i)).hashKey().equals(sourceObject.hashKey())) continue;
            return list.get(i);
        }
        return null;
    }

    public void addAlarmList(AlarmList alarmList) {
        this.list.putAll(alarmList.list);
    }

    public boolean isListEmpty() {
        return this.list.isEmpty();
    }

    class AcknowledeTimerTask
    extends TimerTask {
        private Timer timer;
        private Alarm alarm;

        public AcknowledeTimerTask(Timer timer, Alarm alarm) {
            this.alarm = alarm;
            this.timer = timer;
        }

        public void run() {
            try {
                AlarmList.this.unAcknowledgeAlarm(this.alarm);
            }
            catch (RemoteException re) {
                logger.error(re.getMessage(), re);
            }
            this.timer.cancel();
        }
    }
}

