/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.alarm;

import com.sanrad.nms.server.RemoteObjectImpl;
import com.sanrad.nms.server.Server;
import com.sanrad.nms.server.alarm.Alarm;
import com.sanrad.nms.server.alarm.AlarmSeverity;
import com.sanrad.nms.server.alarm.AlarmType;
import com.sanrad.nms.server.alarm.event.AlarmChangedEvent;
import com.sanrad.nms.server.alarm.event.AlarmChangedListener;
import com.sanrad.nms.server.alarm.event.AlarmEvent;
import com.sanrad.nms.server.alarm.event.AlarmEventImpl;
import com.sanrad.nms.server.logic.EventServiceImpl;
import com.sanrad.nms.server.logic.GeneralLogicObject;
import com.sanrad.nms.server.logic.LogicObject;
import com.sanrad.nms.server.logic.LogicObjectImpl;
import com.sanrad.nms.server.logic.cluster.Cluster;
import com.sanrad.nms.server.logic.dr.DRLogicObject;
import com.sanrad.nms.server.logic.dr.DRLogicObjectImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.types.constants.DrSiteConstant;
import com.sanrad.util.SrConstantsBundleKeys;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.Vector;

public class AlarmImpl
extends RemoteObjectImpl
implements Alarm {
    private static final String s_webSite = Server.CONSTANSTS_BUNDLE.getString(SrConstantsBundleKeys.VENDOR_WEBSITE);
    private static final String s_techSupportEmail = Server.CONSTANSTS_BUNDLE.getString(SrConstantsBundleKeys.VENDOR_TECH_SUPPORT_EMAIL);
    private GeneralLogicObject source;
    private AlarmType type;
    private long dateAndTime;
    private boolean acknowledged = false;
    private long ackDateAndTime = 0L;
    private String ackBy = "";
    private VSwitch vSwitch = null;
    private Cluster m_cluster = null;
    private Object additionalKeyObject = null;
    private String message;
    private boolean reopened = false;
    private boolean m_replacedByANewAlarm = false;
    private Vector listeners = new Vector();
    private boolean isSilent;

    protected AlarmImpl(AlarmType type, String message) throws RemoteException {
        this.setDateAndTime(System.currentTimeMillis());
        this.type = type;
        this.message = message;
        this.isSilent = type.getSilentValue();
    }

    public AlarmImpl(AlarmType type, GeneralLogicObject source, VSwitch vSwitch, String message) throws RemoteException {
        this(type, message);
        this.setSource(source);
        this.setVSwitch(vSwitch);
    }

    public void addAlarmChangedListener(AlarmChangedListener listener) {
        this.listeners.addElement(listener);
    }

    public void removeAlarmChangedListener(AlarmChangedListener listener) {
        this.listeners.removeElement(listener);
    }

    public void addAdditionalKeyObject(Object obj) {
        this.additionalKeyObject = obj;
    }

    public Object getAdditionalKeyObject() throws RemoteException {
        return this.additionalKeyObject;
    }

    public GeneralLogicObject getSource() throws RemoteException {
        return this.source;
    }

    protected void setSource(GeneralLogicObject source) {
        this.source = source;
    }

    protected void setVSwitch(VSwitch vSwitch) {
        this.vSwitch = vSwitch;
    }

    public VSwitch getVSwitch() throws RemoteException {
        return this.vSwitch;
    }

    public AlarmType getType() throws RemoteException {
        return this.type;
    }

    public AlarmSeverity getSeverity() throws RemoteException {
        return this.type.getSeverity();
    }

    public long getDateAndTime() throws RemoteException {
        return this.dateAndTime;
    }

    public void setDateAndTime(long dateAndTime) {
        this.dateAndTime = dateAndTime;
    }

    public boolean isAcknowledged() throws RemoteException {
        return this.acknowledged;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Alarm) {
            Alarm alarmObj = (Alarm)obj;
            try {
                boolean result;
                GeneralLogicObject objSource = alarmObj.getSource();
                if (objSource instanceof DRLogicObject) {
                    result = alarmObj.getType().equals(this.type) && alarmObj.getSource().equals(this.source);
                } else {
                    boolean bl = result = alarmObj.getType().equals(this.type) && ((LogicObject)alarmObj.getSource()).getCommKeyClassId().equals(((LogicObject)this.source).getCommKeyClassId());
                }
                if (result) {
                    if (this.vSwitch != null && alarmObj.getVSwitch() != null) {
                        result = alarmObj.getVSwitch().getCommKeyClassId().equals(this.vSwitch.getCommKeyClassId());
                    } else if (this.vSwitch != alarmObj.getVSwitch()) {
                        result = false;
                    }
                }
                Object objAdditionalKeyObject = alarmObj.getAdditionalKeyObject();
                if (this.additionalKeyObject != null && objAdditionalKeyObject != null) {
                    result = objAdditionalKeyObject instanceof LogicObjectImpl ? objAdditionalKeyObject.equals(this.additionalKeyObject) : (objAdditionalKeyObject instanceof LogicObject ? ((LogicObject)objAdditionalKeyObject).getCommKeyClassId().equals(((LogicObject)this.additionalKeyObject).getCommKeyClassId()) : objAdditionalKeyObject.equals(this.additionalKeyObject));
                } else if (this.additionalKeyObject != objAdditionalKeyObject) {
                    result = false;
                }
                return result;
            }
            catch (RemoteException re) {
                logger.warning(re);
            }
        }
        return false;
    }

    public String getMessage() throws RemoteException {
        return this.message;
    }

    public void setMessage(String msg) {
        this.message = msg;
    }

    public String toString() {
        try {
            StringBuffer toString = new StringBuffer(this.type.toString());
            toString.append(" on ");
            toString.append(this.getSource().getClassId());
            toString.append(" ");
            toString.append(this.getSource());
            return toString.toString();
        }
        catch (RemoteException re) {
            logger.error(re);
            return super.toString();
        }
    }

    public Integer getVSwitchGroupId() throws RemoteException {
        if (this.source instanceof DRLogicObjectImpl) {
            return DrSiteConstant.DR_VSWITCH_GROUP_ID.getValue();
        }
        return ((LogicObject)this.source).getCluster().getVSwitchGroupId();
    }

    public void setAcknowledged(String ackBy) throws RemoteException {
        long dataAndTime = this.getAckDateAndTime();
        if (dataAndTime == 0L) {
            dataAndTime = System.currentTimeMillis();
        }
        this.setAcknowledged(ackBy, dataAndTime);
    }

    public void setAcknowledged(String ackBy, long dataAndTime) throws RemoteException {
        this.setAcknowledged(true, ackBy, dataAndTime);
    }

    public void setUnacknowledged() throws RemoteException {
        this.setAcknowledged(false, "", 0L);
    }

    private void setAcknowledged(boolean ack, String ackBy, long dateAndTime) throws RemoteException {
        this.acknowledged = ack;
        this.setAcknowledgedBy(ackBy);
        this.setAcknowledgedDateAndTime(dateAndTime);
        AlarmChangedEvent event = new AlarmChangedEvent(this);
        Object e = this.listeners.elements();
        while (e.hasMoreElements()) {
            ((AlarmChangedListener)e.nextElement()).acknowledgeAlarmStateChanged(event);
        }
        e = new AlarmEventImpl(this.getSource(), this);
        EventServiceImpl.getInstance().fireAlarmChanged((AlarmEvent)e);
    }

    private void setAcknowledgedDateAndTime(long ackDateAndTime) {
        if (ackDateAndTime <= 0L) {
            ackDateAndTime = System.currentTimeMillis();
        }
        this.ackDateAndTime = ackDateAndTime;
    }

    public long getAckDateAndTime() throws RemoteException {
        return this.ackDateAndTime;
    }

    private void setAcknowledgedBy(String ackBy) throws RemoteException {
        this.ackBy = ackBy;
    }

    public String getAcknowledgedBy() throws RemoteException {
        return this.ackBy;
    }

    public String getProbableCause() throws RemoteException {
        return this.type.getProbableCause();
    }

    public String getCategory() throws RemoteException {
        return this.type.getCategory();
    }

    public String getTypeDescription() throws RemoteException {
        return this.type.toString();
    }

    public void setReopened() {
        this.reopened = true;
    }

    public boolean isReopened() {
        return this.reopened;
    }

    public String getAlarmEmailText() throws RemoteException {
        Cluster cluster = null;
        if (this.source instanceof LogicObjectImpl) {
            cluster = ((LogicObject)this.getSource()).getCluster();
        }
        StringBuffer msg = new StringBuffer();
        if (cluster != null) {
            msg.append(ClassID.CLUSTER);
            msg.append(" ");
            msg.append(cluster);
            msg.append(" - ");
        }
        msg.append(this.getMessage());
        StringBuffer text = new StringBuffer();
        text.append("<html>");
        text.append("<body>");
        Date date = new Date(this.getDateAndTime());
        text.append("<br>");
        text.append(Server.FULL_PRODUCT_NAME);
        text.append(" Alarm<br><br>");
        text.append("Message:<br>");
        text.append(msg);
        text.append("<br>Opened at: ");
        text.append(date.toString());
        text.append("<br><br>ID: ");
        text.append(this.getType().getAlarmId());
        text.append("<br>Type: ");
        text.append(this.getType());
        text.append("<br><br>Troubleshooting:<br>");
        text.append(this.getType().getTroubleShooting());
        text.append("<br><br><br>");
        if (s_techSupportEmail != null && !s_techSupportEmail.equals("")) {
            text.append("For Technical Support, please contact mailto:");
            text.append(s_techSupportEmail);
            text.append("<br>");
        }
        text.append("-------------------------------------------------------------------------");
        text.append("<br><br>");
        text.append("Visit us at ");
        text.append(s_webSite);
        text.append("</body>");
        text.append("</html>");
        return text.toString();
    }

    public boolean isReplacedByANewAlarm() {
        return this.m_replacedByANewAlarm;
    }

    public void setReplacedByANewAlarm(boolean flag) {
        this.m_replacedByANewAlarm = flag;
    }

    public void setSilent() {
        this.isSilent = true;
    }

    public boolean isSilent() {
        return this.isSilent;
    }

    public void setCluster(Cluster cluster) {
        this.m_cluster = cluster;
    }

    public Cluster getCluster() throws RemoteException {
        return this.m_cluster;
    }
}

