/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.alarm;

import com.sanrad.log.Log;
import com.sanrad.log.LogMgr;
import com.sanrad.nms.server.alarm.Alarm;
import com.sanrad.nms.server.alarm.AlarmHistoryFileMgr;
import com.sanrad.nms.server.alarm.AlarmHistoryIterator;
import com.sanrad.nms.server.alarm.AlarmHistoryIteratorImpl;
import com.sanrad.nms.server.alarm.HistoryAlarm;
import com.sanrad.nms.server.alarm.HistoryAlarmImpl;
import com.sanrad.nms.server.logic.LogicObject;
import com.sanrad.nms.server.util.ClassID;
import java.rmi.RemoteException;

public class AlarmHistoryList {
    private static Log logger = LogMgr.getServerLog();
    private AlarmHistoryFileMgr alarmHistoryFileMgr = AlarmHistoryFileMgr.getInstance();
    private static AlarmHistoryList theInstance = new AlarmHistoryList();

    private AlarmHistoryList() {
    }

    public static AlarmHistoryList getInstance() {
        return theInstance;
    }

    public synchronized void addToAlarmHistoryList(Alarm alarm, String closedBy) throws RemoteException {
        ClassID sourceType = alarm.getSource().getClassId();
        HistoryAlarmImpl historyAlarm = new HistoryAlarmImpl(alarm, closedBy);
        logger.debug("Alarm on " + historyAlarm + " was added to alarm history");
        this.alarmHistoryFileMgr.addToHistory(sourceType.toString(), historyAlarm);
    }

    public synchronized void addToAlarmHistoryList(Alarm[] alarms, String closedBy) throws RemoteException {
        ClassID[] sourceType = new ClassID[alarms.length];
        Object[] key = new Object[alarms.length];
        HistoryAlarm[] historyAlarms = new HistoryAlarm[alarms.length];
        for (int i = 0; i < alarms.length; ++i) {
            sourceType[i] = ((LogicObject)alarms[i].getSource()).getClassId();
            key[i] = alarms[i].getSource().toString();
            historyAlarms[i] = new HistoryAlarmImpl(alarms[i], closedBy);
            logger.debug("Alarm " + historyAlarms[i].getType() + " on " + sourceType[i] + " " + key[i] + "on " + ClassID.VSWITCH + " " + historyAlarms[i].getVSwitch() + " was added to alarm history");
        }
    }

    public int getHistoryAlarmCount() {
        return this.alarmHistoryFileMgr.getAlarmCount();
    }

    public AlarmHistoryIterator getAlarmHistoryIterator() throws RemoteException {
        return new AlarmHistoryIteratorImpl(this.alarmHistoryFileMgr);
    }

    public void saveCachedClosedAlarms() {
        this.alarmHistoryFileMgr.saveCachedClosedAlarms();
    }
}

