/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.alarm;

import com.sanrad.nms.server.RemoteObjectImpl;
import com.sanrad.nms.server.alarm.AlarmHistoryFileMgr;
import com.sanrad.nms.server.alarm.AlarmHistoryIterator;
import com.sanrad.nms.server.alarm.HistoryAlarmImpl;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public class AlarmHistoryIteratorImpl
extends RemoteObjectImpl
implements AlarmHistoryIterator {
    private AlarmHistoryFileMgr alarmHistoryFileMgr;
    private int cursorIndex = -1;

    public AlarmHistoryIteratorImpl(AlarmHistoryFileMgr alarmHistoryFileMgr) throws RemoteException {
        this.alarmHistoryFileMgr = alarmHistoryFileMgr;
    }

    public boolean hasNext() throws RemoteException {
        if (this.cursorIndex != 0) {
            return this.cursorIndex <= this.alarmHistoryFileMgr.getFileNames().size() - 1;
        }
        return false;
    }

    public boolean hasPrevious() throws RemoteException {
        return this.cursorIndex != 1;
    }

    public HashMap next() throws RemoteException {
        String fileName;
        if (!this.hasNext()) {
            return null;
        }
        ++this.cursorIndex;
        if (this.cursorIndex == this.alarmHistoryFileMgr.getFileNames().size()) {
            this.cursorIndex = 0;
        }
        if ((fileName = (String)this.alarmHistoryFileMgr.getFileNames().elementAt(this.cursorIndex)).equals("")) {
            return this.getHashMapToClient(this.alarmHistoryFileMgr.getCachedHistoryList());
        }
        HashMap loadedHistoryList = this.alarmHistoryFileMgr.load(fileName);
        return this.getHashMapToClient(loadedHistoryList);
    }

    public HashMap previous() throws RemoteException {
        String fileName;
        if (!this.hasPrevious()) {
            return null;
        }
        --this.cursorIndex;
        if (this.cursorIndex < 0) {
            this.cursorIndex = this.alarmHistoryFileMgr.getFileNames().size() - 1;
        }
        if ((fileName = (String)this.alarmHistoryFileMgr.getFileNames().elementAt(this.cursorIndex)).equals("")) {
            return this.getHashMapToClient(this.alarmHistoryFileMgr.getCachedHistoryList());
        }
        HashMap loadedHistoryList = this.alarmHistoryFileMgr.load(fileName);
        return this.getHashMapToClient(loadedHistoryList);
    }

    private Vector getAlarmsToClient(Vector alarms) throws RemoteException {
        Vector<HashMap> alarmsToClient = new Vector<HashMap>();
        Enumeration iter = alarms.elements();
        while (iter.hasMoreElements()) {
            HistoryAlarmImpl alarm = (HistoryAlarmImpl)iter.nextElement();
            HashMap alarmToClient = alarm.toClientHashMap();
            alarmsToClient.addElement(alarmToClient);
        }
        return alarmsToClient;
    }

    private HashMap getHashMapToClient(HashMap loadedHistoryList) throws RemoteException {
        HashMap historyList = new HashMap();
        if (loadedHistoryList != null) {
            Iterator i = loadedHistoryList.keySet().iterator();
            while (i.hasNext()) {
                Object key = i.next();
                Vector alarms = (Vector)loadedHistoryList.get(key);
                Vector alarmsToClient = this.getAlarmsToClient(alarms);
                historyList.put(key, alarmsToClient);
            }
        }
        return historyList;
    }
}

