/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.alarm;

import com.sanrad.log.Log;
import com.sanrad.log.LogMgr;
import com.sanrad.nms.server.comm.exception.SrCommunicationException;
import com.sanrad.nms.server.mgr.DataMgr;
import java.io.File;
import java.io.FilenameFilter;
import java.io.InvalidClassException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public class AlarmHistoryFileMgr {
    private static Log logger = LogMgr.getServerLog();
    private static AlarmHistoryFileMgr theInstance = null;
    private static final int ALARMS_FILE_BULK_SIZE = 100;
    private static final int MAX_NUMBER_OF_FILES = 100;
    private static final String HISTORY_FILE_PATH_NAME = "alarms/";
    private static final String HISTORY_FILE_FULL_PATH_NAME = "alarms/";
    private static final String HISTORY_FILE_NAME_PREFIX = "alarms";
    private static final String HISTORY_FILE_NAME_SUFFIX = ".history";
    private static final String HISTORY_CACHE_FILE_NAME = "alarmsCache.history";
    private Vector historyFileNames = new Vector();
    private int[] historyFileIndices = null;
    private int numberOfAlarmsInHistoryCacheList = 0;
    private HashMap historyCacheList = null;

    private AlarmHistoryFileMgr() {
        this.initHistoryFileLists();
    }

    public void initHistoryFileLists() {
        this.setHistoryFileNames();
        this.setHistoryFileIndices();
        this.setHistoryCacheList();
    }

    public static AlarmHistoryFileMgr getInstance() {
        if (theInstance == null) {
            theInstance = new AlarmHistoryFileMgr();
        }
        return theInstance;
    }

    public int getAlarmCount() {
        int counter = this.historyFileIndices.length - 1;
        return counter * 100 + this.numberOfAlarmsInHistoryCacheList;
    }

    public Vector getFileNames() {
        return this.historyFileNames;
    }

    public HashMap load(String fileName) {
        try {
            HashMap loadedHistoryList = (HashMap)DataMgr.getInstance().loadFromFile("alarms/" + fileName);
            return loadedHistoryList;
        }
        catch (InvalidClassException ice) {
            LogMgr.getServerLog().debug(ice);
            logger.warning("Alarm history file " + fileName + " is not valid.");
        }
        catch (SrCommunicationException sce) {
            logger.debug(sce.getMessage(), sce);
        }
        return null;
    }

    public synchronized void addToHistory(Object key, Object value) {
        Vector<Object> values = (Vector<Object>)this.historyCacheList.get(key);
        if (values == null) {
            values = new Vector<Object>();
        }
        values.addElement(value);
        this.historyCacheList.put(key, values);
        ++this.numberOfAlarmsInHistoryCacheList;
        if (this.numberOfAlarmsInHistoryCacheList == 100) {
            this.save(this.getNextFileNameToSave());
            this.numberOfAlarmsInHistoryCacheList = 0;
        }
    }

    public HashMap getCachedHistoryList() {
        return this.historyCacheList;
    }

    private boolean removeFirstFile() {
        if (this.historyFileIndices != null && this.historyFileIndices.length > 0) {
            File fileToRemove = new File("alarms/" + this.getFileName(this.historyFileIndices[0]));
            return fileToRemove.delete();
        }
        return false;
    }

    private void renameAllFiles() {
        for (int i = 1; i < this.historyFileNames.size(); ++i) {
            String currentFileName = this.getFileName(this.historyFileIndices[i]);
            File currentFile = new File("alarms/" + currentFileName);
            String newFileName = this.getFileName(i - 1);
            File newFile = new File("alarms/" + newFileName);
            if (!currentFile.renameTo(newFile)) continue;
            this.historyFileNames.setElementAt(newFileName, i);
        }
        this.setHistoryFileIndices();
    }

    private void removeFirstFileAndRenameAllFiles() {
        if (this.removeFirstFile()) {
            this.historyFileNames.removeElementAt(1);
            this.setHistoryFileIndices();
            this.renameAllFiles();
        }
    }

    private void addFile(String fileName) {
        this.historyFileNames.addElement(fileName);
        this.setHistoryFileIndices();
    }

    private void save(String fileName) {
        try {
            DataMgr.getInstance().setToFile("alarms/" + fileName, this.historyCacheList);
            if (!fileName.equals(HISTORY_CACHE_FILE_NAME)) {
                this.historyCacheList = new HashMap();
                this.addFile(fileName);
                if (this.historyFileNames.size() - 1 > 100) {
                    this.removeFirstFileAndRenameAllFiles();
                }
            }
        }
        catch (SrCommunicationException sce) {
            logger.info(sce);
        }
    }

    private int getNextAvailableFileIndexToSave() {
        int index = 0;
        if (this.historyFileIndices != null && this.historyFileIndices.length > 0) {
            index = this.historyFileIndices[this.historyFileIndices.length - 1] + 1;
        }
        return index;
    }

    private String getFileName(int index) {
        StringBuffer fileName = new StringBuffer(HISTORY_FILE_NAME_PREFIX);
        if (index > 0) {
            fileName.append(index);
        }
        fileName.append(HISTORY_FILE_NAME_SUFFIX);
        return fileName.toString();
    }

    private String getNextFileNameToSave() {
        int index = this.getNextAvailableFileIndexToSave();
        return this.getFileName(index);
    }

    private int getFileIndexOf(String fileName) {
        int fileIndexSuffix;
        if (fileName.equals("")) {
            return -1;
        }
        String fileIndexPrefix = fileName.substring(HISTORY_FILE_NAME_PREFIX.length());
        String index = fileIndexPrefix.substring(0, fileIndexSuffix = fileIndexPrefix.indexOf(HISTORY_FILE_NAME_SUFFIX));
        if (index.equals("")) {
            return 0;
        }
        try {
            return Integer.parseInt(index);
        }
        catch (NumberFormatException nfe) {
            return -1;
        }
    }

    private void setHistoryFileIndices() {
        this.historyFileIndices = new int[this.historyFileNames.size()];
        for (int i = 0; i < this.historyFileNames.size(); ++i) {
            this.historyFileIndices[i] = this.getFileIndexOf((String)this.historyFileNames.elementAt(i));
        }
        Arrays.sort(this.historyFileIndices);
    }

    private boolean isValidName(String fileName) {
        return this.getFileIndexOf(fileName) >= 0;
    }

    private void setHistoryCacheList() {
        this.historyCacheList = this.load(HISTORY_CACHE_FILE_NAME);
        if (this.historyCacheList == null) {
            this.historyCacheList = new HashMap();
        }
        this.numberOfAlarmsInHistoryCacheList = 0;
        Iterator i = this.historyCacheList.keySet().iterator();
        while (i.hasNext()) {
            Vector alarms = (Vector)this.historyCacheList.get(i.next());
            this.numberOfAlarmsInHistoryCacheList += alarms.size();
        }
    }

    private void setHistoryFileNames() {
        File path = new File("alarms/");
        path.mkdir();
        String[] fileNames = path.list(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                if (name.indexOf(AlarmHistoryFileMgr.HISTORY_FILE_NAME_PREFIX) == 0) {
                    int suffixIndex = name.indexOf(AlarmHistoryFileMgr.HISTORY_FILE_NAME_SUFFIX);
                    return suffixIndex + AlarmHistoryFileMgr.HISTORY_FILE_NAME_SUFFIX.length() == name.length();
                }
                return false;
            }
        });
        if (fileNames != null) {
            this.historyFileNames = new Vector();
            this.historyFileNames.addElement("");
            for (int i = 0; i < fileNames.length; ++i) {
                if (!this.isValidName(fileNames[i])) continue;
                this.historyFileNames.addElement(fileNames[i]);
            }
        }
    }

    public void saveCachedClosedAlarms() {
        this.save(HISTORY_CACHE_FILE_NAME);
    }
}

