/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Properties;

public class ServerPropertiesFetcher {
    public static final String SERVER_PROPERTIES_FILE_NAME = "server.properties";
    private static String DEFAULT_PROPERTIES_FILE_DIR = "./";
    public static final String RMI_REGISTRY_PORT_PROPERTY = "rmiRegPort";
    public static final String HOSTNAME_PROPERTY = "hostname";

    private ServerPropertiesFetcher() {
    }

    public static void setDefaultPropertiesFileDir(String dir) {
        DEFAULT_PROPERTIES_FILE_DIR = dir;
    }

    public static String getHost() throws FileNotFoundException, IOException {
        String host = ServerPropertiesFetcher.getHostname();
        if (host == null || host.trim().equals("")) {
            host = ServerPropertiesFetcher.getHostAddress();
        }
        return host;
    }

    public static String getHostname() throws FileNotFoundException, IOException {
        return ServerPropertiesFetcher.getHostname(DEFAULT_PROPERTIES_FILE_DIR);
    }

    public static String getHostname(String propertiesFileDir) throws FileNotFoundException, IOException {
        return ServerPropertiesFetcher.getServerPropertyValue(HOSTNAME_PROPERTY, propertiesFileDir);
    }

    private static String getPropertiesFileFullName(String propertiesFileDir) {
        if (!propertiesFileDir.endsWith("/")) {
            propertiesFileDir = propertiesFileDir + "/";
        }
        return propertiesFileDir + SERVER_PROPERTIES_FILE_NAME;
    }

    private static String getServerPropertyValue(String propertyName, String propertiesFileDir) throws FileNotFoundException, IOException {
        String propertyValue = null;
        Properties serverData = new Properties();
        String propertiesFileFullName = ServerPropertiesFetcher.getPropertiesFileFullName(propertiesFileDir);
        serverData.load(new FileInputStream(propertiesFileFullName));
        propertyValue = serverData.getProperty(propertyName);
        return propertyValue;
    }

    public static String getRMIRegistryPort() throws FileNotFoundException, IOException {
        return ServerPropertiesFetcher.getRMIRegistryPort(DEFAULT_PROPERTIES_FILE_DIR);
    }

    public static String getRMIRegistryPort(String propertiesFileDir) throws FileNotFoundException, IOException {
        String port = ServerPropertiesFetcher.getServerPropertyValue(RMI_REGISTRY_PORT_PROPERTY, propertiesFileDir);
        if (port == null) {
            return String.valueOf(1099);
        }
        return port;
    }

    public static InetAddress getHostInetAddress() {
        InetAddress[] hostAddressList = ServerPropertiesFetcher.getHostAddressList();
        return hostAddressList[0];
    }

    public static String getHostAddress() {
        return ServerPropertiesFetcher.getHostInetAddress().getHostAddress();
    }

    public static InetAddress[] getHostAddressList() {
        try {
            return InetAddress.getAllByName(InetAddress.getLocalHost().getHostName());
        }
        catch (UnknownHostException uhe) {
            uhe.printStackTrace();
            return null;
        }
    }

    public static String getServerPropertyValue(String propertyName) throws FileNotFoundException, IOException {
        return ServerPropertiesFetcher.getServerPropertyValue(propertyName, DEFAULT_PROPERTIES_FILE_DIR);
    }
}

