/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server;

import com.sanrad.log.Log;
import com.sanrad.log.LogMgr;
import com.sanrad.nms.server.ServerPropertiesFetcher;
import com.sanrad.nms.server.SrServerBundleKeys;
import com.sanrad.nms.server.comm.database.DatabaseManager;
import com.sanrad.nms.server.logic.LogicMgr;
import com.sanrad.nms.server.logic.SystemRootImpl;
import com.sanrad.nms.server.user.UserManagerImpl;
import com.sanrad.util.EditAsciiFile;
import com.sanrad.util.NetUtil;
import com.sanrad.util.SrConstantsBundleKeys;
import com.sanrad.util.SrResourceBundle;
import com.sanrad.util.Util;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.rmi.RMISecurityManager;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.ExportException;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;

public class Server {
    public static SrResourceBundle BUNDLE = SrResourceBundle.getInstance("product_server", Locale.US);
    public static SrResourceBundle CONSTANSTS_BUNDLE = SrResourceBundle.getInstance("constants", Locale.US);
    public static final String VENDOR_NAME = CONSTANSTS_BUNDLE.getString(SrConstantsBundleKeys.VENDOR_NAME);
    private static final String PRODUCT_NAME = CONSTANSTS_BUNDLE.getString(SrConstantsBundleKeys.PRODUCT_NAME);
    public static final String FULL_PRODUCT_NAME = PRODUCT_NAME + " Server";
    public static String VERSION = BUNDLE.getString(SrServerBundleKeys.SERVER_VERSION);
    public static final int PORT_NOT_SET = -1;
    public static final String APP_ICON = "images/app-icon.gif";
    public static final String ABOUT_IMAGE = "images/about.jpg";
    private static final String RMI_POLICY_FILE_NAME = "rmi.policy";
    public static final String RMI_EXPORT_PORT_PROPERTY = "rmiExportPort";
    public static final String CLIENT_APPLICATION_LOCATION_PROPERTY = "clientApplicationLocation";
    public static final String CLIENT_APPLET_LOCATION_PROPERTY = "clientAppletionLocation";
    private static final String CLIENT_APPLICATION_PROPERTIES_FILE_NAME = "client.properties";
    private static final String CLIENT_APPLET_PROPERTIES_FILE_NAME = "index.html";
    private static Log logger = LogMgr.getServerLog();
    private static InetAddress hostInetAddress = null;
    private static int rmiregistryPort = -1;

    public static int getRMIExportPort() {
        String port = null;
        try {
            port = ServerPropertiesFetcher.getServerPropertyValue(RMI_EXPORT_PORT_PROPERTY);
        }
        catch (IOException ioe) {
            logger.error(ioe);
        }
        if (port == null) {
            return -1;
        }
        return Integer.parseInt(port);
    }

    public static String getClientApplicationPropertyPath() {
        try {
            return ServerPropertiesFetcher.getServerPropertyValue(CLIENT_APPLICATION_LOCATION_PROPERTY);
        }
        catch (IOException ioe) {
            logger.error(ioe);
            return null;
        }
    }

    public static String getClientAppletPropertyPath() {
        try {
            return ServerPropertiesFetcher.getServerPropertyValue(CLIENT_APPLET_LOCATION_PROPERTY);
        }
        catch (IOException ioe) {
            logger.error(ioe);
            return null;
        }
    }

    private static Registry getRegistry(int registryPort) {
        Registry registry = null;
        try {
            registry = LocateRegistry.createRegistry(registryPort);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return registry;
    }

    public static void main(String[] args) {
        if (Util.lockApplicationInstanceIfNotActive(".lock")) {
            System.err.println(PRODUCT_NAME + " already runs");
            System.exit(0);
        }
        logger.info("OS: " + Util.getOSName() + " version " + Util.getOSVersion());
        logger.info("JVM version: " + Util.getCurrentJVMVersion());
        logger.info("Locale: " + Util.getLocale());
        if (VERSION == null) {
            VERSION = Util.getCVSTagVersionString();
        }
        if (!Util.isJavaVersion14Compatible()) {
            String version = "1.4";
            System.err.println("You must use Java(TM) version " + version + " or higher in order to run " + FULL_PRODUCT_NAME + "\nCurrently you use Java(TM) version " + Util.getCurrentJavaVersion() + ".\nThe Java Runtime Environment can be downloaded from:\nhttp://java.sun.com");
            System.exit(0);
        }
        Server.setJavaSecurityPolicy();
        String hostname = null;
        String rmiregistryPortStr = null;
        try {
            hostname = ServerPropertiesFetcher.getHostname();
            rmiregistryPortStr = ServerPropertiesFetcher.getRMIRegistryPort();
            rmiregistryPort = Server.getFreePortAndSaveIfDifferent(Integer.parseInt(rmiregistryPortStr));
        }
        catch (IOException ioe) {
            logger.error(ioe);
        }
        if (hostname != null && !hostname.equals("")) {
            System.setProperty("java.rmi.server.hostname", hostname);
            logger.info("Setting java.rmi.server.hostname to " + hostname);
        }
        LogicMgr.getInstance();
        SystemRootImpl.setStatusInProcess("Initializing server...");
        try {
            if (System.getSecurityManager() == null) {
                System.setSecurityManager(new RMISecurityManager());
            }
            Server.getHostAddress();
            if (hostInetAddress != null) {
                int originalRegistryPort;
                StringBuffer host = new StringBuffer(hostInetAddress.getHostAddress());
                logger.debug("Host is: " + host);
                int registryPort = originalRegistryPort = Server.getRegistryPort();
                Registry registry = Server.getRegistry(registryPort);
                if (registry != null) {
                    UserManagerImpl userManager = UserManagerImpl.getInstance();
                    userManager.bindToRMIRegistry(registry);
                    DatabaseManager.getInstance().convertOldDatabaseToNewDatabaseAndDeleteOldFile();
                    LogicMgr.getInstance().discover();
                } else {
                    SystemRootImpl.setStatusError("Failed to load");
                }
            } else {
                logger.fatal("Hostname not found - cannot proceed.  You must set an IP address.");
                SystemRootImpl.setStatusReady();
            }
        }
        catch (ExportException ee) {
            logger.fatal("Port " + rmiregistryPortStr + " is already in use!", ee);
            SystemRootImpl.setStatusError("Failed to initialize");
        }
        catch (RemoteException re) {
            logger.fatal(re.getMessage(), re);
        }
        catch (Exception e) {
            logger.fatal(e.getMessage() + " in Server::main()", e);
        }
        try {
            Runtime.getRuntime().addShutdownHook(new Thread("Shutdown"){

                public void run() {
                }
            });
        }
        catch (SecurityException se) {
            logger.warning(se.getMessage());
        }
    }

    private static int getFreePortAndSaveIfDifferent(int defaultPort) {
        if (NetUtil.isPortBusy(defaultPort)) {
            try {
                defaultPort = NetUtil.getRandomFreePort();
                Properties newProperties = new Properties();
                newProperties.setProperty("rmiRegPort", Integer.toString(defaultPort));
                Server.setNewProperties(newProperties);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        return defaultPort;
    }

    public static String[] getHostAddressListAsStringArray() {
        InetAddress[] inetAddress = ServerPropertiesFetcher.getHostAddressList();
        String[] ips = new String[inetAddress.length];
        for (int i = 0; i < inetAddress.length; ++i) {
            ips[i] = inetAddress[i].getHostAddress();
        }
        return ips;
    }

    public static int getRegistryPort() {
        return rmiregistryPort;
    }

    public static String getHostAddress() {
        if (hostInetAddress == null) {
            hostInetAddress = ServerPropertiesFetcher.getHostInetAddress();
        }
        return hostInetAddress.getHostAddress();
    }

    public static void setNewProperties(Properties newProperties) {
        if (newProperties != null) {
            try {
                Properties serverPropertiesToSave = Server.getPropertiesToSave(newProperties, "server.properties");
                Server.saveProperties(serverPropertiesToSave, "server.properties");
                String clientApplicationPropertyPath = Server.getClientApplicationPropertyPath();
                String clientApplicationPropertyFileName = clientApplicationPropertyPath + File.separator + CLIENT_APPLICATION_PROPERTIES_FILE_NAME;
                Properties clientApplicationPropertiesToSave = Server.getPropertiesToSave(newProperties, clientApplicationPropertyFileName);
                Server.saveProperties(clientApplicationPropertiesToSave, clientApplicationPropertyFileName);
                String clientAppletPropertyPath = Server.getClientAppletPropertyPath();
                String clientAppletPropertyFileName = clientAppletPropertyPath + File.separator + CLIENT_APPLET_PROPERTIES_FILE_NAME;
                EditAsciiFile.changeAppletValues(newProperties, clientAppletPropertyFileName);
            }
            catch (IOException ioe) {
                logger.warning(ioe);
            }
        }
    }

    private static void saveProperties(Properties propertiesToSave, String fileName) throws IOException {
        FileOutputStream outFile = new FileOutputStream(fileName);
        propertiesToSave.store(outFile, null);
        outFile.flush();
        outFile.close();
    }

    private static Properties getPropertiesToSave(Properties newProperties, String propertiesFileName) {
        try {
            Properties propertiesToSave = new Properties();
            Properties currentProperties = new Properties();
            FileInputStream serverInFile = new FileInputStream(propertiesFileName);
            currentProperties.load(serverInFile);
            Enumeration<Object> e = currentProperties.keys();
            while (e.hasMoreElements()) {
                Object key = e.nextElement();
                if (!newProperties.containsKey(key)) {
                    propertiesToSave.put(key, currentProperties.get(key));
                    continue;
                }
                propertiesToSave.put(key, newProperties.get(key));
            }
            return propertiesToSave;
        }
        catch (IOException ioe) {
            logger.warning(ioe);
            return null;
        }
    }

    private static boolean setJavaSecurityPolicy() {
        String localDir = Server.getLocalDir() + "/";
        String policyProperty = "file:" + localDir;
        if (Server.createRMIPolicyFile(policyProperty, localDir + RMI_POLICY_FILE_NAME)) {
            System.setProperty("java.security.policy", policyProperty + RMI_POLICY_FILE_NAME);
            return true;
        }
        return false;
    }

    private static boolean createRMIPolicyFile(String policyProperty, String fileName) {
        StringBuffer policy = new StringBuffer("grant codeBase \"");
        policy.append(policyProperty);
        policy.append("-\"\n");
        policy.append("{\n");
        policy.append("\t// Allow everything for now\n");
        policy.append("\tpermission java.net.SocketPermission  \"*:1024-65535\", \"accept, connect, listen\";\n");
        policy.append("\tpermission java.security.AllPermission;\n");
        policy.append("};\n");
        File policyFile = new File(fileName);
        if (policyFile.delete()) {
            logger.info("Old RMI policy file " + fileName + " with the policy: " + policy.toString() + " was removed");
        }
        if (!policyFile.isFile()) {
            policyFile.deleteOnExit();
            logger.debug("Trying to create RMI policy file " + fileName + " with the policy: " + policy.toString());
            try {
                FileOutputStream fos = new FileOutputStream(policyFile);
                fos.write(policy.toString().getBytes());
                fos.flush();
                fos.close();
            }
            catch (FileNotFoundException fnfe) {
                logger.fatal("Failed to create RMI policy file " + fileName + " due to " + fnfe.getMessage(), fnfe);
                return false;
            }
            catch (IOException ioe) {
                logger.fatal("Failed to create RMI policy file " + fileName + " due to " + ioe.getMessage(), ioe);
                return false;
            }
            logger.debug("Create RMI policy file succeeded");
        } else {
            logger.debug("RMI policy file " + fileName + " exists");
        }
        return true;
    }

    private static String getLocalDir() {
        String localDir = System.getProperty("user.dir");
        StringTokenizer tokens = new StringTokenizer(localDir, "\\");
        StringBuffer location = new StringBuffer();
        while (tokens.hasMoreTokens()) {
            location.append(tokens.nextToken());
            location.append(tokens.hasMoreTokens() ? "/" : "");
        }
        return location.toString();
    }
}

