/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server;

import com.sanrad.nms.server.ServerPropertiesFetcher;
import com.sanrad.nms.server.SrSocketFactory;
import com.sanrad.nms.server.alarm.event.AlarmEvent;
import com.sanrad.nms.server.alarm.event.PropagatedStateEvent;
import com.sanrad.nms.server.comm.snmp.SnmpVersion;
import com.sanrad.nms.server.logic.ElementEvent;
import com.sanrad.nms.server.logic.ElementListener;
import com.sanrad.nms.server.logic.GeneralLogicObject;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.LogicObject;
import com.sanrad.nms.server.logic.Site;
import com.sanrad.nms.server.logic.SystemRoot;
import com.sanrad.nms.server.logic.VSwitchGroup;
import com.sanrad.nms.server.logic.cluster.Cluster;
import com.sanrad.nms.server.logic.dr.DRConsistencyGroup;
import com.sanrad.nms.server.logic.dr.DREvent;
import com.sanrad.nms.server.logic.dr.DRListener;
import com.sanrad.nms.server.logic.dr.DRRoot;
import com.sanrad.nms.server.logic.dr.DRSyncPair;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.user.UserManager;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.ArrayList;
import java.util.Iterator;

public class ClientSimulator
implements ElementListener {
    private SystemRoot systemRoot = null;
    private static final String DEVELOPMENT_PROPERTIES_FILE_PATH = "/Program Files/SANRAD/VSS/StoragePro/server";

    private void test() throws RemoteException {
        DRRoot drRoot = this.systemRoot.getDRRoot();
        DRConsistencyGroup[] groups = drRoot.getConsistencyGroups();
        DRSyncPair[] syncPairs = drRoot.getSyncPairs();
        boolean a = false;
        try {
            DRConsistencyGroup[] groups1 = drRoot.getConsistencyGroups();
            Cluster cl1 = (Cluster)((Site)this.systemRoot.getSites().get(0)).getClusters().get(0);
            LogicObject pair1 = null;
            DREvent drEvent = new DREvent((Object)cl1, pair1, 1);
            ((DRListener)((Object)drRoot)).invokeDREventAndWait(drEvent);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        System.out.println("Test ended");
    }

    private void printClusters(Site site) throws RemoteException {
        if (site.getVSwitchGroups().isEmpty() && site.getClusters().isEmpty()) {
            System.out.println(site.getClassId() + " " + site.getAlias() + " is empty");
        }
        Iterator iterator = site.getVSwitchGroups().iterator();
        while (iterator.hasNext()) {
            Cluster cluster = (Cluster)iterator.next();
            String alias = cluster.getAlias();
            System.out.println(site.getClassId() + " " + site.getAlias());
            this.printVSwitches(cluster, true);
        }
    }

    private void printVSwitches(Cluster cluster, boolean hasParentSite) throws RemoteException {
        String tabs = "\t";
        if (hasParentSite) {
            System.out.println(tabs + cluster.getClassId() + " " + cluster.getAlias());
            tabs = tabs + "\t";
        } else {
            System.out.println(cluster.getClassId() + " " + cluster.getAlias());
        }
        if (cluster.getVSwitches().isEmpty()) {
            String alias = cluster.getAlias();
            System.out.println(cluster.getClassId() + " " + alias + " is empty");
        }
        Iterator iterator = cluster.getVSwitches().iterator();
        while (iterator.hasNext()) {
            VSwitch vSwitch = (VSwitch)iterator.next();
            String name = vSwitch.getName();
            System.out.println(tabs + vSwitch.getClassId() + " " + name);
        }
    }

    private void addVSwitch() {
        try {
            ArrayList vSwitchGroups = this.systemRoot.getVSwitchGroups();
            Iterator iter = vSwitchGroups.iterator();
            while (iter.hasNext()) {
                VSwitchGroup vSwitchGroup = (VSwitchGroup)iter.next();
                if (!vSwitchGroup.getClassId().equals(ClassID.SITE)) continue;
                ArrayList clusters = ((Site)vSwitchGroup).getClusters();
                if (!clusters.isEmpty()) {
                    this.addVSwitch((Cluster)clusters.iterator().next());
                }
                break;
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    private void addVSwitch(Cluster cluser) {
        try {
            cluser.addVSwitch("172.17.200.153", "255.255.255.0", 161, 162, "public", "private", 3000L, 3, SnmpVersion.V2C);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        catch (IllegalValueException e) {
            e.printStackTrace();
        }
    }

    private void addCluster() {
        try {
            this.systemRoot.createCluster("Shay");
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        catch (IllegalValueException e) {
            e.printStackTrace();
        }
    }

    private ClientSimulator() {
        Registry registry = ClientSimulator.getRegistry();
        String serverObjectName = "UserManager";
        try {
            UserManager userManager = (UserManager)registry.lookup(serverObjectName);
            this.systemRoot = userManager.getSystemRoot();
            this.test();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Registry getRegistry() {
        try {
            Registry registry = LocateRegistry.getRegistry(null, Integer.parseInt(ClientSimulator.getPort()), new SrSocketFactory(null));
            return registry;
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return null;
    }

    private static String getPort() {
        String port = null;
        try {
            port = ServerPropertiesFetcher.getRMIRegistryPort();
            port = "4085";
        }
        catch (FileNotFoundException fnfe) {
            try {
                port = ServerPropertiesFetcher.getRMIRegistryPort(DEVELOPMENT_PROPERTIES_FILE_PATH);
            }
            catch (FileNotFoundException fnfe2) {
                fnfe2.printStackTrace();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return port;
    }

    public static void main(String[] args) {
        new ClientSimulator();
        System.exit(0);
    }

    public void elementCreate(ElementEvent e) throws RemoteException {
        Object element = e.getElement();
        System.out.println("elementCreate " + element);
    }

    public void elementRemove(ElementEvent e) throws RemoteException {
        Object element = e.getElement();
        System.out.println("elementRemove " + element);
    }

    public void elementChanged(ElementEvent e) throws RemoteException {
        Object element = e.getElement();
        System.out.println("elementChanged " + element);
    }

    public void startDiscovering(ElementEvent e) throws RemoteException {
        Object element = e.getElement();
        System.out.println("startDiscovering " + element);
    }

    public void discoverCompleted(ElementEvent e) throws RemoteException {
        Object element = e.getElement();
        System.out.println("discoverCompleted " + element);
    }

    public void connectionTimeOut(ElementEvent e) throws RemoteException {
        Object element = e.getElement();
        System.out.println("connectionTimeOut " + element);
    }

    public void configurationError(ElementEvent e) throws RemoteException {
        Object element = e.getElement();
        System.out.println("configurationError " + element);
    }

    public void fatalConfigurationError(ElementEvent e) throws RemoteException {
        Object element = e.getElement();
        System.out.println("fatalConfigurationError " + element);
    }

    public void startManualDiscovering(ElementEvent e) throws RemoteException {
        Object element = e.getElement();
        System.out.println("startManualDiscovering " + element);
    }

    public void loginSucceed(ElementEvent e) throws RemoteException {
        Object element = e.getElement();
        System.out.println("loginSucceed " + element);
    }

    public void startReset(ElementEvent e) throws RemoteException {
        Object element = e.getElement();
        System.out.println("startReset " + element);
    }

    public void alreadyKnownByVSwitch(ElementEvent e) throws RemoteException {
        Object element = e.getElement();
        System.out.println("alreadyKnownByVSwitch " + element);
    }

    public void fireElementRemoveFromVSwitch(ElementEvent e) throws RemoteException {
        Object element = e.getElement();
        System.out.println("fireElementRemoveFromVSwitch " + element);
    }

    public void alarmOpened(AlarmEvent e) throws RemoteException {
        GeneralLogicObject element = e.getSourceObject();
        System.out.println("alarmOpened " + element);
    }

    public void alarmClosed(AlarmEvent e) throws RemoteException {
        GeneralLogicObject element = e.getSourceObject();
        System.out.println("alarmClosed " + element);
    }

    public void alarmChanged(AlarmEvent e) throws RemoteException {
        GeneralLogicObject element = e.getSourceObject();
        System.out.println("alarmChanged " + element);
    }

    public void propagatedStateChanged(PropagatedStateEvent e) throws RemoteException {
        GeneralLogicObject element = e.getSourceObject();
        System.out.println("propagatedStateChanged " + element);
    }

    public void snmpError(ElementEvent e) throws RemoteException {
        Object element = e.getElement();
        System.out.println("snmpError " + element);
    }

    public void checkConnectivity() throws RemoteException {
        System.out.println("checkConnectivity");
    }

    public void serverWasShutdown(ElementEvent e) throws RemoteException {
        Object element = e.getElement();
        System.out.println("serverWasShutdown " + element);
    }

    public String hashKey() throws RemoteException {
        return null;
    }

    public void drDiscoveryStarted(ElementEvent e) throws RemoteException {
    }

    public void drDiscoveryCompleted(ElementEvent e) throws RemoteException {
    }

    public void systemDiscoveryCompleted(ElementEvent e) throws RemoteException {
    }

    private void createSites() throws RemoteException, IllegalValueException {
        String local = "local";
        String remote = "remote";
        this.systemRoot.createSite(local);
        this.systemRoot.createSite(remote);
    }

    private Site getSite(String role) throws RemoteException {
        ArrayList sites = this.systemRoot.getSites();
        for (int i = 0; i < sites.size(); ++i) {
            if (!((Site)sites.get(i)).getAlias().equals(role)) continue;
            return (Site)sites.get(i);
        }
        return null;
    }

    private CommKeyClassId createVolume(Cluster cluster) {
        return null;
    }
}

