/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server;

import com.sanrad.log.Log;
import com.sanrad.log.LogMgr;
import com.sanrad.nms.server.FixedPortRMISocketFactory;
import com.sanrad.nms.server.Server;
import com.sanrad.nms.server.SrSocketFactory;
import java.io.IOException;
import java.rmi.AccessException;
import java.rmi.AlreadyBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.Registry;
import java.rmi.server.RMISocketFactory;
import java.rmi.server.UnicastRemoteObject;

public abstract class AbstractBoundedStub
implements Remote {
    protected static Log logger = LogMgr.getServerLog();

    protected AbstractBoundedStub() {
        try {
            if (RMISocketFactory.getSocketFactory() == null) {
                RMISocketFactory.setSocketFactory(new FixedPortRMISocketFactory());
            }
        }
        catch (IOException ioe) {
            logger.debug(ioe);
        }
    }

    public void bindToRMIRegistry(Registry registry) throws RemoteException {
        String hostname = Server.getHostAddress();
        int exportPort = Server.getRMIExportPort();
        if (exportPort > 0) {
            UnicastRemoteObject.exportObject(this, exportPort, new SrSocketFactory(hostname), new SrSocketFactory(hostname));
            logger.debug(this + " was exported via port " + exportPort);
        } else {
            UnicastRemoteObject.exportObject(this);
            logger.debug(this + " was exported via \"any\" (no special) port ");
        }
        String serverObjectName = this.toString();
        logger.debug("Trying to bind " + this + " to " + serverObjectName);
        try {
            registry.bind(serverObjectName, this);
        }
        catch (AccessException ae) {
            logger.fatal(ae);
        }
        catch (AlreadyBoundException abe) {
            logger.fatal(abe);
        }
        logger.debug(this + " binding to " + serverObjectName + " succeeded");
    }
}

