/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.log;

import com.sanrad.log.AppenderInitializer;
import com.sanrad.log.LogMgr;
import com.sanrad.log.SrSMTPLayout;
import com.sanrad.nms.server.Server;
import java.util.Date;
import java.util.Hashtable;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Transport;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.apache.log4j.net.SMTPAppender;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.TriggeringEventEvaluator;

class SrSMTPAppender
extends SMTPAppender
implements AppenderInitializer {
    public SrSMTPAppender() {
        this.setName("SrSMTPAppender");
    }

    public SrSMTPAppender(TriggeringEventEvaluator evaluator) {
        super(evaluator);
        this.setName("SrSMTPAppender");
    }

    protected void sendBuffer() {
        try {
            MimeBodyPart part = new MimeBodyPart();
            StringBuffer sbuf = new StringBuffer();
            String t = this.layout.getHeader();
            if (t != null) {
                sbuf.append(t);
            }
            int len = this.cb.length();
            for (int i = 0; i < len; ++i) {
                String[] s;
                LoggingEvent event = this.cb.get();
                sbuf.append(this.layout.format(event));
                if (!this.layout.ignoresThrowable() || (s = event.getThrowableStrRep()) == null) continue;
                for (int j = 0; j < s.length; ++j) {
                    sbuf.append(s[j]);
                }
            }
            t = this.layout.getFooter();
            if (t != null) {
                sbuf.append(t);
            }
            part.setContent((Object)sbuf.toString(), this.layout.getContentType());
            MimeMultipart mp = new MimeMultipart();
            mp.addBodyPart((BodyPart)part);
            this.msg.setContent((Multipart)mp);
            this.msg.setSentDate(new Date());
            Transport.send((Message)this.msg);
        }
        catch (Exception e) {
            LogMgr.getServerLog().warning("Failed to send an Email message to recipient: " + this.getTo(), e);
        }
    }

    public void setParameters(Hashtable parameters) {
        try {
            Object layout;
            Object toAddress;
            this.setBufferSize(1);
            this.setEvaluatorClass("com.sanrad.log.MailTrigger");
            this.setSubject("Alarm from Sanrad " + Server.FULL_PRODUCT_NAME + " !");
            Object threshold = parameters.get("threshold");
            if (threshold != null) {
                this.setThreshold((Priority)Level.toLevel((String)threshold.toString()));
            } else {
                this.setThreshold((Priority)Level.INFO);
            }
            Object from = parameters.get("from");
            if (from != null) {
                this.setFrom(from.toString());
            }
            if ((toAddress = parameters.get("to")) != null) {
                this.setTo(toAddress.toString());
            }
            Object serverName = parameters.get("smtp-server");
            if (toAddress != null) {
                this.setSMTPHost(serverName.toString());
            }
            if ((layout = parameters.get("layout")) == null) {
                this.setLayout(new SrSMTPLayout());
            }
            this.activateOptions();
        }
        catch (Exception e) {
            LogMgr.getServerLog().warning("Wrong mail parameters", e);
        }
    }
}

