/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.log;

import com.sanrad.log.AppenderInitializer;
import com.sanrad.log.SrHTMLLayout;
import com.sanrad.nms.server.Server;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Hashtable;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.apache.log4j.RollingFileAppender;

class SrRollingFileAppender
extends RollingFileAppender
implements AppenderInitializer {
    protected String headerString = "";
    private static String MAX_SIZE_FILE = "250KB";
    private static int MAX_BACK_UP_FILES = 10;

    public SrRollingFileAppender(Layout layout, String filename, boolean append) throws IOException {
        super(layout, filename, append);
        this.setName("SrRollingFile  Appender " + this.toString());
    }

    public SrRollingFileAppender() {
        this.setName("SrRollingFile  Appender " + this.toString());
    }

    public SrRollingFileAppender(Layout layout, String filename, boolean append, String header) throws IOException {
        super(layout, filename, append);
        this.headerString = header;
        this.setName("SrRollingFile  Appender " + this.toString());
    }

    public SrRollingFileAppender(Layout layout, String filename) throws IOException {
        super(layout, filename);
        this.setName("SrRollingFile  Appender " + this.toString());
    }

    public void rollOver1() {
        super.rollOver();
        try {
            File file = new File(this.fileName);
            if (file.exists()) {
                FileOutputStream fos = new FileOutputStream(file);
                PrintWriter pw = new PrintWriter(fos);
                pw.println(this.headerString);
                pw.close();
            }
            this.setFile(this.fileName, true, this.bufferedIO, this.bufferSize);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setParameters(Hashtable parameters) {
        Object layout;
        Object threshold = parameters.get("threshold");
        if (threshold != null) {
            this.setThreshold((Priority)Level.toLevel((String)threshold.toString()));
        } else {
            this.setThreshold((Priority)Level.INFO);
        }
        Object fileName = parameters.get("fileName");
        if (fileName != null) {
            this.setFile("log" + File.separator + fileName.toString());
        }
        if ((layout = parameters.get("layout")) == null) {
            this.setLayout((Layout)new SrHTMLLayout(Server.VENDOR_NAME));
        }
        this.setMaxBackupIndex(MAX_BACK_UP_FILES);
        this.setMaxFileSize(MAX_SIZE_FILE);
        this.activateOptions();
    }
}

