/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.log;

import com.sanrad.log.DebugLevel;
import com.sanrad.log.Log;
import java.util.Enumeration;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class SrLogger
implements Log {
    protected Logger myLogger = null;
    private String name;

    protected SrLogger(String name) {
        this.myLogger = Logger.getLogger((String)name);
        this.name = name;
    }

    public void setDebugLevel(DebugLevel level) {
        throw new UnsupportedOperationException("This method does nothing...");
    }

    public void removeAppender(String name) {
        this.myLogger.removeAppender(name);
    }

    public void removeAllAppenders() {
        this.myLogger.removeAllAppenders();
    }

    public String getName() {
        return this.name;
    }

    protected void setLevel(DebugLevel newLevel) {
        Level level = Level.DEBUG;
        switch (newLevel.getIntValue()) {
            case 0: {
                level = Level.FATAL;
                break;
            }
            case 1: {
                level = Level.ERROR;
                break;
            }
            case 2: {
                level = Level.WARN;
                break;
            }
            case 3: {
                level = Level.INFO;
                break;
            }
            case 4: {
                level = Level.DEBUG;
            }
        }
        this.myLogger.setLevel(level);
    }

    public void addAppenders(Object[] appenders) {
        for (int i = 0; i < appenders.length; ++i) {
            this.myLogger.addAppender((Appender)appenders[i]);
        }
    }

    public DebugLevel getLowestDebugLevel() {
        DebugLevel threshold = DebugLevel.FATAL;
        Level lowest = Level.toLevel((String)threshold.toString());
        Enumeration iter = this.myLogger.getAllAppenders();
        while (iter.hasMoreElements()) {
            AppenderSkeleton appender = (AppenderSkeleton)iter.nextElement();
            if (appender.getThreshold().isGreaterOrEqual((Priority)lowest)) continue;
            lowest = (Level)appender.getThreshold();
        }
        return DebugLevel.getDebugLevel(lowest.toString());
    }

    public synchronized void debug(StringBuffer msg) {
        if (this.myLogger.isDebugEnabled()) {
            this.myLogger.debug((Object)msg);
        }
    }

    public synchronized void debug(String msg) {
        if (this.myLogger.isDebugEnabled()) {
            this.myLogger.debug((Object)msg);
        }
    }

    public synchronized void debug(String msg, Exception e) {
        if (this.myLogger.isDebugEnabled()) {
            e.printStackTrace();
            this.myLogger.debug((Object)msg, (Throwable)e);
        }
    }

    public synchronized void debug(Exception e) {
        this.debug(e.getMessage(), e);
    }

    public synchronized void info(String msg) {
        this.myLogger.info((Object)msg);
    }

    public synchronized void info(String msg, Exception e) {
        if (this.myLogger.isDebugEnabled()) {
            e.printStackTrace();
        }
        this.myLogger.info((Object)msg, (Throwable)e);
    }

    public synchronized void info(Exception e) {
        this.info(e.getMessage(), e);
    }

    public synchronized void warning(String msg) {
        this.myLogger.warn((Object)msg);
    }

    public synchronized void warning(String msg, Exception e) {
        if (this.myLogger.isDebugEnabled()) {
            e.printStackTrace();
        }
        this.myLogger.warn((Object)msg, (Throwable)e);
    }

    public synchronized void warning(Exception e) {
        this.warning(e.getMessage(), e);
    }

    public synchronized void error(String msg) {
        this.myLogger.error((Object)msg);
    }

    public synchronized void error(Throwable e) {
        this.error(e.getMessage(), e);
    }

    public synchronized void error(String msg, Throwable e) {
        if (this.myLogger.isDebugEnabled()) {
            e.printStackTrace();
        }
        this.myLogger.error((Object)msg, e);
    }

    public synchronized void fatal(String msg) {
        this.myLogger.fatal((Object)msg);
    }

    public synchronized void fatal(Exception e) {
        this.myLogger.fatal((Object)e.getMessage(), (Throwable)e);
    }

    public synchronized void fatal(String msg, Exception e) {
        if (this.myLogger.isDebugEnabled()) {
            e.printStackTrace();
        }
        this.myLogger.fatal((Object)msg, (Throwable)e);
    }
}

