/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.log;

import java.util.Date;
import org.apache.log4j.HTMLLayout;
import org.apache.log4j.Layout;
import org.apache.log4j.helpers.Transform;
import org.apache.log4j.spi.LocationInfo;
import org.apache.log4j.spi.LoggingEvent;

public class SrHTMLLayout
extends HTMLLayout {
    protected static String TRACE_PREFIX = "<br>&nbsp;&nbsp;&nbsp;&nbsp;";
    protected static String FONT_CLOSE_TAG = "</font>";

    public SrHTMLLayout(String companyName) {
        this.setTitle(companyName + " Log");
    }

    public String format(LoggingEvent event) {
        StringBuffer sb = new StringBuffer();
        sb.append(Layout.LINE_SEP + "<tr>" + Layout.LINE_SEP);
        sb.append("<td>");
        Date date = new Date(event.timeStamp);
        sb.append(date.toString());
        sb.append("</td>" + Layout.LINE_SEP);
        sb.append("<td title=\"Level\">");
        String color = this.messageColor(event);
        sb.append(color);
        sb.append(event.level.toString());
        sb.append(FONT_CLOSE_TAG);
        sb.append("</td>" + Layout.LINE_SEP);
        if (this.getLocationInfo()) {
            LocationInfo locInfo = event.getLocationInformation();
            sb.append("<td>");
            sb.append(Transform.escapeTags((String)locInfo.getFileName()));
            sb.append(':');
            sb.append(locInfo.getLineNumber());
            sb.append("</td>" + Layout.LINE_SEP);
        }
        sb.append("<td title=\"Message\">");
        sb.append(color);
        sb.append(Transform.escapeTags((String)event.getRenderedMessage()));
        sb.append(FONT_CLOSE_TAG);
        sb.append("</td>" + Layout.LINE_SEP);
        sb.append("</tr>" + Layout.LINE_SEP);
        String[] s = event.getThrowableStrRep();
        if (s != null) {
            sb.append("<tr><td bgcolor=\"#993300\" style=\"color:White; font-size : xx-small;\" colspan=\"6\">");
            this.appendThrowableAsHTML(s, sb);
            sb.append("</td></tr>" + Layout.LINE_SEP);
        }
        return sb.toString();
    }

    protected String messageColor(LoggingEvent event) {
        switch (event.level.toInt()) {
            case 10000: {
                return "<font color=\"black\">";
            }
            case 20000: {
                return "<font color=\"blue\">";
            }
            case 30000: {
                return "<font color=\"yellow\">";
            }
            case 40000: {
                return "<font color=\"orange\">";
            }
            case 50000: {
                return "<font color=\"red\">";
            }
        }
        return "<font color=\"black\">";
    }

    public String getHeader() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">" + Layout.LINE_SEP);
        sbuf.append("<html>" + Layout.LINE_SEP);
        sbuf.append("<head>" + Layout.LINE_SEP);
        sbuf.append("<title>" + this.getTitle() + "</title>" + Layout.LINE_SEP);
        sbuf.append("<style type=\"text/css\">" + Layout.LINE_SEP);
        sbuf.append("<!--" + Layout.LINE_SEP);
        sbuf.append("body, table {font-family: arial,sans-serif; font-size: x-small;}" + Layout.LINE_SEP);
        sbuf.append("th {background: #919FCC; color: #FFFFFF; text-align: left;}" + Layout.LINE_SEP);
        sbuf.append("-->" + Layout.LINE_SEP);
        sbuf.append("</style>" + Layout.LINE_SEP);
        sbuf.append("</head>" + Layout.LINE_SEP);
        sbuf.append("<body bgcolor=\"#FFFFFF\" topmargin=\"6\" leftmargin=\"6\">" + Layout.LINE_SEP);
        sbuf.append("<hr size=\"1\" noshade>" + Layout.LINE_SEP);
        sbuf.append("Log session start time " + new Date() + "<br>" + Layout.LINE_SEP);
        sbuf.append("<br>" + Layout.LINE_SEP);
        sbuf.append("<table cellspacing=\"0\" cellpadding=\"4\" border=\"1\" bordercolor=\"#224466\" width=\"100%\">" + Layout.LINE_SEP);
        sbuf.append("<tr>" + Layout.LINE_SEP);
        sbuf.append("<th>Time</th>" + Layout.LINE_SEP);
        sbuf.append("<th>Level</th>" + Layout.LINE_SEP);
        if (this.getLocationInfo()) {
            sbuf.append("<th>File:Line</th>" + Layout.LINE_SEP);
        }
        sbuf.append("<th>Message</th>" + Layout.LINE_SEP);
        sbuf.append("</tr>" + Layout.LINE_SEP);
        return sbuf.toString();
    }

    private void appendThrowableAsHTML(String[] s, StringBuffer sbuf) {
        if (s != null) {
            int len = s.length;
            if (len == 0) {
                return;
            }
            sbuf.append(Transform.escapeTags((String)s[0]));
            sbuf.append(Layout.LINE_SEP);
            for (int i = 1; i < len; ++i) {
                sbuf.append(TRACE_PREFIX);
                sbuf.append(Transform.escapeTags((String)s[i]));
                sbuf.append(Layout.LINE_SEP);
            }
        }
    }
}

