/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.log;

import com.sanrad.log.AppenderInitializer;
import com.sanrad.log.LogPropertiesException;
import com.sanrad.log.SrLogger;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;

public class LogMgr {
    private static SrLogger serverLog;
    private static SrLogger trapsLog;
    private static SrLogger historyAlarmsLog;
    private static SrLogger nullLogger;
    private static Document doc;
    private static Hashtable allLoggers;
    private static LogMgr theInstance;
    public static final String CLIENT_LOG = "clientLog";
    public static final String TRAPS_LOG = "trapsLog";
    public static final String SERVER_LOG = "serverLog";
    public static final String HISTORY_ALARM_LOG = "historyAlarmsLog";
    public static final String PROPERTIES_FILE_NAME = "LogProperties.xml";
    private static final File FILE_PROPERTIES;
    public static final String APPENDER_TAG = "Appender";
    public static final String PARAMETER_TAG = "Param";
    public static final String NAME_ATTRIBUTE = "name";
    public static final String LAYOUT_ATTRIBUTE = "layout";
    public static final String DEBUG_LEVEL_ATTRIBUTE = "debugLevel";

    private LogMgr() {
    }

    private static void initDefaultLoggers() {
        Object serverlogger = allLoggers.get(SERVER_LOG);
        serverLog = serverlogger == null ? LogMgr.getNullLogger() : (SrLogger)serverlogger;
        Object trapslogger = allLoggers.get(TRAPS_LOG);
        trapsLog = trapslogger == null ? LogMgr.getNullLogger() : (SrLogger)trapslogger;
        Object historyLogger = allLoggers.get(HISTORY_ALARM_LOG);
        historyAlarmsLog = historyLogger == null ? LogMgr.getNullLogger() : (SrLogger)historyLogger;
    }

    private static void readProperties() {
        SAXBuilder builder = new SAXBuilder();
        try {
            doc = builder.build(FILE_PROPERTIES);
            Element root = doc.getRootElement();
            List loggersElement = root.getChildren();
            LogMgr.createLoggers(loggersElement);
        }
        catch (JDOMException e) {
            System.err.println("File is not well-formed. " + e.getMessage());
            e.printStackTrace();
        }
        catch (LogPropertiesException lpe) {
            System.err.println("Problem found in log properties file ! " + lpe.getMessage());
            lpe.printStackTrace();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
        }
    }

    public void addAppender(SrLogger logger, String appenderName, Hashtable parameters) {
        Object appenderObject = LogMgr.createAppender(appenderName, parameters);
        Object[] appender = new Object[]{appenderObject};
        logger.addAppenders(appender);
        if (doc != null) {
            Element root = doc.getRootElement();
            List loggers = root.getChildren();
            Element loggerElement = null;
            for (int i = 0; i < loggers.size(); ++i) {
                Element e = (Element)loggers.get(i);
                String name = e.getAttributeValue(NAME_ATTRIBUTE);
                if (!name.equalsIgnoreCase(logger.getName())) continue;
                loggerElement = e;
                break;
            }
            if (loggerElement != null) {
                Element newAppender = this.createAppenderElement(appenderName, parameters);
                loggerElement.addContent(newAppender);
                this.saveProperties();
            }
        }
    }

    public void removeAppender(SrLogger logger, String appenderName) {
        logger.removeAppender(appenderName);
        if (doc != null) {
            Element root = doc.getRootElement();
            List loggers = root.getChildren();
            Element loggerElement = null;
            for (int i = 0; i < loggers.size(); ++i) {
                Element e = (Element)loggers.get(i);
                String name = e.getAttributeValue(NAME_ATTRIBUTE);
                if (!name.equalsIgnoreCase(logger.getName())) continue;
                loggerElement = e;
                break;
            }
            if (loggerElement != null) {
                List appenders = loggerElement.getChildren(APPENDER_TAG);
                Element appenderElement = null;
                for (int j = 0; j < appenders.size(); ++j) {
                    Element e = (Element)appenders.get(j);
                    String name = e.getAttributeValue(NAME_ATTRIBUTE);
                    if (!name.equalsIgnoreCase(appenderName)) continue;
                    appenderElement = e;
                    break;
                }
                if (appenderElement != null) {
                    loggerElement.removeContent(appenderElement);
                    this.saveProperties();
                }
            }
        }
    }

    private Element createAppenderElement(String appenderName, Hashtable parameters) {
        Element newAppender = new Element(APPENDER_TAG);
        newAppender.addAttribute(NAME_ATTRIBUTE, appenderName);
        Object debugLevel = parameters.get("threshold");
        if (debugLevel != null) {
            newAppender.addAttribute(DEBUG_LEVEL_ATTRIBUTE, debugLevel.toString());
        } else {
            newAppender.addAttribute(DEBUG_LEVEL_ATTRIBUTE, "info");
        }
        Enumeration params = parameters.keys();
        while (params.hasMoreElements()) {
            String key = (String)params.nextElement();
            if (key == NAME_ATTRIBUTE || key == "threshold") continue;
            Element parameter = new Element(PARAMETER_TAG);
            parameter.addAttribute(NAME_ATTRIBUTE, key);
            parameter.addContent(parameters.get(key).toString());
            newAppender.addContent(parameter);
        }
        return newAppender;
    }

    public void saveProperties() {
        try {
            FileOutputStream fw = new FileOutputStream(FILE_PROPERTIES);
            XMLOutputter output = new XMLOutputter();
            output.output(doc, (OutputStream)fw);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void createLoggers(List loggers) throws LogPropertiesException {
        SrLogger[] srLoggers = new SrLogger[loggers.size()];
        try {
            for (int j = 0; j < loggers.size(); ++j) {
                Element logger = (Element)loggers.get(j);
                srLoggers[j] = LogMgr.createLogger(logger);
            }
        }
        catch (LogPropertiesException lpe) {
            lpe.printStackTrace();
            throw lpe;
        }
    }

    private static SrLogger createLogger(Element logger) throws LogPropertiesException {
        String loggerName = logger.getAttributeValue(NAME_ATTRIBUTE);
        if (loggerName == null) {
            throw new LogPropertiesException("Found logger without a name");
        }
        SrLogger srLogger = new SrLogger(loggerName);
        allLoggers.put(loggerName, srLogger);
        List appendersElements = logger.getChildren();
        int totalAppenders = appendersElements.size();
        Object[] appenders = new Object[totalAppenders];
        for (int k = 0; k < totalAppenders; ++k) {
            Element appenderElement = (Element)appendersElements.get(k);
            try {
                appenders[k] = LogMgr.createAppender(appenderElement);
                continue;
            }
            catch (LogPropertiesException lpe) {
                lpe.printStackTrace();
                throw lpe;
            }
        }
        srLogger.addAppenders(appenders);
        return srLogger;
    }

    private static Object createAppender(Element appenderElement) throws LogPropertiesException {
        String appenderName = appenderElement.getAttributeValue(NAME_ATTRIBUTE);
        if (appenderName == null) {
            throw new LogPropertiesException("Found Appender without a name");
        }
        Hashtable<String, String> parameters = new Hashtable<String, String>();
        String layout = appenderElement.getAttributeValue(LAYOUT_ATTRIBUTE);
        String debugLevel = appenderElement.getAttributeValue(DEBUG_LEVEL_ATTRIBUTE);
        List params = appenderElement.getChildren(PARAMETER_TAG);
        int totalParams = params.size();
        for (int l = 0; l < totalParams; ++l) {
            Element param = (Element)params.get(l);
            String paramName = param.getAttributeValue(NAME_ATTRIBUTE);
            String value = param.getText().trim();
            parameters.put(paramName, value);
        }
        if (debugLevel != null) {
            parameters.put("threshold", debugLevel);
        }
        if (layout != null) {
            parameters.put(LAYOUT_ATTRIBUTE, layout);
        }
        return LogMgr.createAppender(appenderName, parameters);
    }

    public static Object createAppender(String appenderName, Hashtable parameters) {
        Object appender = null;
        try {
            appender = Class.forName("com.sanrad.log." + appenderName).newInstance();
            ((AppenderInitializer)appender).setParameters(parameters);
            return appender;
        }
        catch (ClassNotFoundException cnfe) {
            System.err.println("Class com.sanrad.log." + appenderName + " Not found !");
            cnfe.printStackTrace();
        }
        catch (IllegalAccessException iae) {
            System.err.println("Could not create Appender " + appenderName + ": " + iae.getMessage());
            iae.printStackTrace();
        }
        catch (InstantiationException ie) {
            System.err.println("Could not instantiate the appender - " + appenderName);
            ie.printStackTrace();
        }
        return null;
    }

    public static LogMgr getInstance() {
        if (theInstance == null) {
            theInstance = new LogMgr();
        }
        return theInstance;
    }

    public static SrLogger getServerLog() {
        return serverLog;
    }

    public static SrLogger getTrapsLog() {
        return trapsLog;
    }

    public static SrLogger getHistoryAlarmsLog() {
        return historyAlarmsLog;
    }

    private static SrLogger getNullLogger() {
        if (nullLogger == null) {
            nullLogger = new SrLogger("null logger");
        }
        return nullLogger;
    }

    static {
        theInstance = null;
        FILE_PROPERTIES = new File("config" + File.separator + PROPERTIES_FILE_NAME);
        String dir = System.getProperty("user.dir");
        File logDir = new File(dir = dir + File.separator + "log");
        if (!logDir.isDirectory()) {
            logDir.mkdir();
        }
        allLoggers = new Hashtable();
        LogMgr.readProperties();
        LogMgr.initDefaultLoggers();
    }
}

