/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.log;

import com.sanrad.log.DebugLevel;
import com.sanrad.log.Log;
import java.util.Date;

public class ConsoleLogger
implements Log {
    private DebugLevel level = DebugLevel.DEBUG;

    public void setDebugLevel(DebugLevel level) {
        this.level = level;
    }

    protected String getCurrentTime() {
        Date date = new Date(System.currentTimeMillis());
        return date.toString();
    }

    protected synchronized void printMessage(DebugLevel level, String msg) {
        if (level.isLessThan(this.level)) {
            return;
        }
        String time = this.getCurrentTime();
        StringBuffer message = new StringBuffer("[");
        message.append(time);
        message.append("] [");
        message.append(level);
        message.append("] - ");
        message.append(msg);
        if (level.equals(DebugLevel.ERROR) || level.equals(DebugLevel.FATAL)) {
            System.err.println(message);
        } else {
            System.out.println(message);
        }
    }

    protected synchronized void printException(DebugLevel level, Throwable e) {
        this.printMessage(level, "Exception:");
        e.printStackTrace();
    }

    public synchronized void debug(String msg) {
        this.printMessage(DebugLevel.DEBUG, msg);
    }

    public synchronized void info(String msg) {
        this.printMessage(DebugLevel.INFO, msg);
    }

    public synchronized void warning(String msg) {
        this.printMessage(DebugLevel.WARNING, msg);
    }

    public synchronized void error(String msg) {
        this.printMessage(DebugLevel.ERROR, msg);
    }

    public synchronized void fatal(String msg) {
        this.printMessage(DebugLevel.FATAL, msg);
    }

    public synchronized void debug(String msg, Exception e) {
        this.debug(msg);
        this.debug(e);
    }

    public synchronized void info(String msg, Exception e) {
        this.info(msg);
        this.info(e);
    }

    public synchronized void warning(String msg, Exception e) {
        this.warning(msg);
        this.warning(e);
    }

    public synchronized void error(String msg, Throwable e) {
        this.error(msg);
        this.error(e);
    }

    public synchronized void fatal(String msg, Exception e) {
        this.fatal(msg);
        this.fatal(e);
    }

    public synchronized void debug(Exception e) {
        this.printException(DebugLevel.DEBUG, e);
    }

    public synchronized void info(Exception e) {
        this.printException(DebugLevel.INFO, e);
    }

    public synchronized void warning(Exception e) {
        this.printException(DebugLevel.WARNING, e);
    }

    public synchronized void error(Throwable e) {
        this.printException(DebugLevel.ERROR, e);
    }

    public synchronized void fatal(Exception e) {
        this.printException(DebugLevel.FATAL, e);
    }
}

