/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.log;

import com.sanrad.log.LogMgr;
import com.sanrad.log.SrHTMLLayout;
import com.sanrad.nms.server.alarm.AlarmSeverity;
import com.sanrad.nms.server.alarm.HistoryAlarmImpl;
import com.sanrad.nms.server.util.ClassID;
import java.rmi.RemoteException;
import java.util.Date;
import org.apache.log4j.Layout;
import org.apache.log4j.spi.LoggingEvent;

class AlarmsHistoryLayout
extends SrHTMLLayout {
    public AlarmsHistoryLayout(String companyName) {
        super(companyName);
        this.setTitle(companyName + " History Alarms Log");
    }

    public String format(LoggingEvent event) {
        try {
            HistoryAlarmImpl alarm = (HistoryAlarmImpl)event.getMessage();
            StringBuffer sb = new StringBuffer();
            AlarmSeverity severity = alarm.getSeverity();
            String color = this.messageColor(event);
            sb.append(Layout.LINE_SEP + "<tr>" + Layout.LINE_SEP);
            sb.append("<td>");
            sb.append(color);
            sb.append("<img src='images/" + this.getSeverityIcon(severity) + "'>");
            sb.append(FONT_CLOSE_TAG);
            sb.append("</td>" + Layout.LINE_SEP);
            sb.append("<td title=\"Name\">");
            sb.append(alarm.getType().toString());
            sb.append("</td>");
            sb.append(Layout.LINE_SEP);
            sb.append("<td title=\"Source\">");
            sb.append("<img src='images/");
            sb.append(this.getSourceIcon(alarm.getSourceType()));
            sb.append("'>&nbsp;&nbsp;");
            sb.append(alarm.getSource());
            sb.append("</td>");
            sb.append(Layout.LINE_SEP);
            sb.append("<td title=\"Description\">");
            sb.append(alarm.getMessage());
            sb.append("</td>");
            sb.append(Layout.LINE_SEP);
            sb.append("<td title=\"Opened At\">");
            Date open = new Date(alarm.getDateAndTime());
            sb.append(open.toString());
            sb.append("</td>");
            sb.append(Layout.LINE_SEP);
            sb.append("<td title=\"Closed At\">");
            Date closed = new Date(alarm.getClosedDateAndTime());
            sb.append(closed.toString());
            sb.append("</td>");
            sb.append(Layout.LINE_SEP);
            sb.append("<td title=\"Closed By\">");
            String closedBy = alarm.getClosedBy();
            if (closedBy == null || closedBy.equals("")) {
                sb.append("System");
            } else {
                sb.append(closedBy);
            }
            sb.append("</td>");
            sb.append(Layout.LINE_SEP);
            sb.append("</tr>");
            sb.append(Layout.LINE_SEP);
            return sb.toString();
        }
        catch (RemoteException re) {
            LogMgr.getServerLog().error(re);
            return "Could not render the alarm";
        }
    }

    protected String getSourceIcon(ClassID sourceType) {
        if (sourceType.equals(ClassID.CLUSTER)) {
            return "cluster.gif";
        }
        if (sourceType.equals(ClassID.CONCAT_VOLUME)) {
            return "concatination.gif";
        }
        if (sourceType.equals(ClassID.DIRECT_ACCESS_DEVICE)) {
            return "disk.gif";
        }
        if (sourceType.equals(ClassID.FC_TARGET)) {
            return "target.gif";
        }
        if (sourceType.equals(ClassID.ISCSI_TARGET)) {
            return "target.gif";
        }
        if (sourceType.equals(ClassID.LUN)) {
            return "lu.gif";
        }
        if (sourceType.equals(ClassID.MIRROR_VOLUME)) {
            return "mirror.gif";
        }
        if (sourceType.equals(ClassID.NEIGHBORE)) {
            return "vswitch.gif";
        }
        if (sourceType.equals(ClassID.STRIPE_VOLUME)) {
            return "stripe.gif";
        }
        if (sourceType.equals(ClassID.SUB_DIRECT_ACCESS_DEVICE)) {
            return "subdisk.gif";
        }
        if (sourceType.equals(ClassID.TRANSPARENT_VOLUME)) {
            return "transparent.gif";
        }
        if (sourceType.equals(ClassID.VSWITCH)) {
            return "vswitch.gif";
        }
        return "not_found.gif";
    }

    protected String getSeverityIcon(AlarmSeverity severity) {
        if (severity.equals(AlarmSeverity.MINOR)) {
            return "yellowAlarm.gif";
        }
        if (severity.equals(AlarmSeverity.MAJOR)) {
            return "orangeAlarm.gif";
        }
        if (severity.equals(AlarmSeverity.WARNING)) {
            return "blueAlarm.gif";
        }
        if (severity.equals(AlarmSeverity.CRITICAL)) {
            return "redAlarm.gif";
        }
        return "not_found.gif";
    }

    protected String messageColor(LoggingEvent event) {
        try {
            HistoryAlarmImpl alarm = (HistoryAlarmImpl)event.getMessage();
            AlarmSeverity as = alarm.getSeverity();
            if (as.equals(AlarmSeverity.MINOR)) {
                return "<font color=\"yellow\">";
            }
            if (as.equals(AlarmSeverity.MAJOR)) {
                return "<font color=\"orange\">";
            }
            if (as.equals(AlarmSeverity.WARNING)) {
                return "<font color=\"blue\">";
            }
            if (as.equals(AlarmSeverity.CRITICAL)) {
                return "<font color=\"red\">";
            }
            if (as.equals(AlarmSeverity.OK)) {
                return "<font color=\"green\">";
            }
        }
        catch (RemoteException re) {
            LogMgr.getServerLog().error(re);
        }
        return "<font color=\"black\">";
    }

    public String getHeader() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">" + Layout.LINE_SEP);
        sbuf.append("<html>" + Layout.LINE_SEP);
        sbuf.append("<head>" + Layout.LINE_SEP);
        sbuf.append("<title>" + this.getTitle() + "</title>" + Layout.LINE_SEP);
        sbuf.append("<style type=\"text/css\">" + Layout.LINE_SEP);
        sbuf.append("<!--" + Layout.LINE_SEP);
        sbuf.append("body, table {font-family: arial,sans-serif; font-size: x-small;}" + Layout.LINE_SEP);
        sbuf.append("th {background: #919FCC; color: #FFFFFF; text-align: left;}" + Layout.LINE_SEP);
        sbuf.append("-->" + Layout.LINE_SEP);
        sbuf.append("</style>" + Layout.LINE_SEP);
        sbuf.append("</head>" + Layout.LINE_SEP);
        sbuf.append("<body bgcolor=\"#FFFFFF\" topmargin=\"6\" leftmargin=\"6\">" + Layout.LINE_SEP);
        sbuf.append("<br>" + Layout.LINE_SEP);
        sbuf.append("<table cellspacing=\"0\" cellpadding=\"4\" border=\"1\" bordercolor=\"#224466\" width=\"100%\">" + Layout.LINE_SEP);
        sbuf.append("<tr>" + Layout.LINE_SEP);
        sbuf.append("<th>Severity</th>" + Layout.LINE_SEP);
        sbuf.append("<th>Name</th>" + Layout.LINE_SEP);
        sbuf.append("<th>Source</th>" + Layout.LINE_SEP);
        sbuf.append("<th>Description</th>" + Layout.LINE_SEP);
        sbuf.append("<th>Opened At</th>" + Layout.LINE_SEP);
        sbuf.append("<th>Closed At</th>" + Layout.LINE_SEP);
        sbuf.append("<th>Closed By</th>" + Layout.LINE_SEP);
        sbuf.append("</tr>" + Layout.LINE_SEP);
        return sbuf.toString();
    }
}

