/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.alarm.vswitch;

import com.sanrad.nms.server.alarm.AlarmGenerator;
import com.sanrad.nms.server.alarm.AlarmImpl;
import com.sanrad.nms.server.alarm.AlarmType;
import com.sanrad.nms.server.logic.GeneralLogicObject;
import com.sanrad.nms.server.logic.hardware.HardwareImpl;
import com.sanrad.nms.server.logic.vswitch.InterfaceTableRowImpl;
import com.sanrad.nms.server.logic.vswitch.SFPConnectedInterfaceImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.Parameter;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.constants.VSwitchStatusConstant;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.List;

public class VSwitchAlarmGenerator
extends AlarmGenerator {
    private static VSwitchAlarmGenerator theInstance = new VSwitchAlarmGenerator();

    private VSwitchAlarmGenerator() {
    }

    public static VSwitchAlarmGenerator getInstance() {
        return theInstance;
    }

    @Override
    public List<AlarmImpl> checkForAlarmsToOpen(GeneralLogicObject source, VSwitchImpl vSwitch) throws RemoteException {
        HardwareImpl hardware;
        VSwitchImpl otherVSwitch;
        AbstractStringBuilder msg;
        VSwitchImpl vSwitchSource = (VSwitchImpl)source;
        List<AlarmImpl> openAlarms = super.checkForAlarmsToOpen(source, vSwitch);
        if (!vSwitchSource.isConnected()) {
            msg = new StringBuffer(vSwitchSource.getClassId().toString());
            ((StringBuffer)msg).append(" ");
            ((StringBuffer)msg).append(vSwitchSource.getName());
            ((StringBuffer)msg).append(" is disconnected");
            this.addAlarm(openAlarms, AlarmType.VSWITCH_DISCONNECTED, source, vSwitchSource, ((StringBuffer)msg).toString());
        }
        if (VSwitchStatusConstant.LOW_MEMORY.equals((Object)vSwitchSource.getVSwitchStatus())) {
            msg = new StringBuilder(vSwitchSource.getClassId().toString());
            ((StringBuilder)msg).append(" ");
            ((StringBuilder)msg).append(vSwitchSource.getName());
            ((StringBuilder)msg).append(" has low memory");
            this.addAlarm(openAlarms, AlarmType.VSWITCH_LOW_MEMORY, source, vSwitchSource, ((StringBuilder)msg).toString());
        }
        if (vSwitchSource.isConnected() && vSwitchSource.isUnderTakeover() && (otherVSwitch = vSwitchSource.getCluster().getOtherVSwitch(vSwitchSource)) != null) {
            StringBuffer msg2 = new StringBuffer(vSwitchSource.getClassId().toString());
            msg2.append(" ");
            msg2.append(vSwitchSource.getName());
            msg2.append(" has taken over the volumes of the ");
            msg2.append(otherVSwitch.getClassId());
            msg2.append(" ");
            msg2.append(otherVSwitch.getName());
            this.addAlarm(openAlarms, AlarmType.VSWITCH_TAKEOVER, source, vSwitchSource, msg2.toString());
        }
        List linkDownInterfaces = vSwitchSource.getLinkDownInterfaces();
        for (InterfaceTableRowImpl inter : linkDownInterfaces) {
            StringBuffer msg3 = new StringBuffer(vSwitchSource.getClassId().toString());
            msg3.append(" ");
            msg3.append(vSwitchSource.getName());
            msg3.append(".  The ");
            msg3.append(inter.getClassId());
            msg3.append(" ");
            msg3.append(inter.getAlias());
            msg3.append(" is down");
            this.addAlarm(openAlarms, AlarmType.LINK_DOWN, source, vSwitchSource, msg3.toString(), inter);
        }
        if (vSwitchSource.isSupportSFP()) {
            List tooHighSpeedSFPInterfaces = vSwitchSource.getTooHighSpeedSFPInterfaces();
            for (SFPConnectedInterfaceImpl sfpConnectedInterface : tooHighSpeedSFPInterfaces) {
                BigInteger ifSpeed = sfpConnectedInterface.getHighSpeedMbits();
                Integer sfpSpeed = sfpConnectedInterface.getConnectedSFPSpeedMbits();
                StringBuffer msg4 = new StringBuffer(vSwitchSource.getClassId().toString());
                msg4.append(' ');
                msg4.append(vSwitchSource.getName());
                msg4.append(". The SFP connector bit rate of ");
                msg4.append(sfpConnectedInterface.getClassId());
                msg4.append(' ');
                msg4.append(sfpConnectedInterface.getAlias());
                msg4.append(" (");
                msg4.append(sfpSpeed);
                msg4.append(" Mbit) is bigger than the interface bit rate (");
                msg4.append(ifSpeed);
                msg4.append(" Mbit)");
                this.addAlarm(openAlarms, AlarmType.SFP_SPEED_TOO_HIGH, source, vSwitchSource, msg4.toString(), sfpConnectedInterface);
            }
            List tooLowSpeedSFPInterfaces = vSwitchSource.getTooLowSpeedSFPInterfaces();
            for (SFPConnectedInterfaceImpl sfpConnectedInterface : tooLowSpeedSFPInterfaces) {
                BigInteger ifSpeed = sfpConnectedInterface.getHighSpeedMbits();
                Integer sfpSpeed = sfpConnectedInterface.getConnectedSFPSpeedMbits();
                StringBuffer msg5 = new StringBuffer(vSwitchSource.getClassId().toString());
                msg5.append(' ');
                msg5.append(vSwitchSource.getName());
                msg5.append(". The SFP connector bit rate of ");
                msg5.append(sfpConnectedInterface.getClassId());
                msg5.append(' ');
                msg5.append(sfpConnectedInterface.getAlias());
                msg5.append(" (");
                msg5.append(sfpSpeed);
                msg5.append(" Mbit) is lower than the interface bit rate (");
                msg5.append(ifSpeed);
                msg5.append(" Mbit)");
                this.addAlarm(openAlarms, AlarmType.SFP_SPEED_TOO_LOW, source, vSwitchSource, msg5.toString(), sfpConnectedInterface);
            }
        }
        if (vSwitchSource.isConnected() && (hardware = vSwitchSource.getHardware()) != null) {
            StringBuffer msg6;
            if (hardware.isFanFaulty()) {
                msg6 = new StringBuffer(ClassID.VSWITCH.toString());
                msg6.append(" ");
                msg6.append(vSwitchSource.getName());
                msg6.append(". Only two fans are working");
                this.addAlarm(openAlarms, AlarmType.HARDWARE_FAN_FAULTY, source, msg6.toString());
            }
            if (hardware.isFanCritical()) {
                msg6 = new StringBuffer(ClassID.VSWITCH.toString());
                msg6.append(" ");
                msg6.append(vSwitchSource.getName());
                msg6.append(". Only one fan is working");
                this.addAlarm(openAlarms, AlarmType.HARDWARE_FAN_CRITICAL, source, msg6.toString());
            }
            if (hardware.isPowerSupplyFaulty()) {
                msg6 = new StringBuffer(ClassID.VSWITCH.toString());
                msg6.append(" ");
                msg6.append(vSwitchSource.getName());
                msg6.append(". Only one power supply is working");
                this.addAlarm(openAlarms, AlarmType.HARDWARE_POWER_SUPPLY_FAULTY, source, msg6.toString());
            }
            if (hardware.isCPUTempWarning()) {
                msg6 = new StringBuffer(ClassID.VSWITCH.toString());
                msg6.append(" ");
                msg6.append(vSwitchSource.getName());
                msg6.append(". The CPU temperature ");
                msg6.append(hardware.getCPUTemp().toString());
                msg6.append(vSwitchSource.getTempUnits().toString());
                msg6.append(" crossed the threshold of acceptable temperature (above ");
                msg6.append(hardware.getCPUWarningTempThresh().toString());
                msg6.append(vSwitchSource.getTempUnits());
                msg6.append(")");
                this.addAlarm(openAlarms, AlarmType.HARDWARE_CPU_TEMP_WARNING, source, msg6.toString());
            }
            if (hardware.isOnBoardTempWarning()) {
                msg6 = new StringBuffer(ClassID.VSWITCH.toString());
                msg6.append(" ");
                msg6.append(vSwitchSource.getName());
                msg6.append(". The on-board temperature ");
                msg6.append(hardware.getOnBoardTemp().toString());
                msg6.append(vSwitchSource.getTempUnits().toString());
                msg6.append(" crossed the threshold of acceptable temperature (above ");
                msg6.append(hardware.getOnBoardWarningTempThresh().toString());
                msg6.append(vSwitchSource.getTempUnits());
                msg6.append(")");
                this.addAlarm(openAlarms, AlarmType.HARDWARE_ON_BOARD_TEMP_WARNING, source, msg6.toString());
            }
            if (hardware.isCPUTempCritical()) {
                msg6 = new StringBuffer(ClassID.VSWITCH.toString());
                msg6.append(" ");
                msg6.append(vSwitchSource.getName());
                msg6.append(". The CPU temperature ");
                msg6.append(hardware.getCPUTemp().toString());
                msg6.append(vSwitchSource.getTempUnits().toString());
                msg6.append(" crossed the threshold of acceptable temperature (above ");
                msg6.append(hardware.getCPUFactoryTempThresh().toString());
                msg6.append(vSwitchSource.getTempUnits());
                msg6.append(")");
                this.addAlarm(openAlarms, AlarmType.HARDWARE_CPU_TEMP_CRITICAL, source, msg6.toString());
            }
            if (hardware.isOnBoardTempCritical()) {
                msg6 = new StringBuffer(ClassID.VSWITCH.toString());
                msg6.append(" ");
                msg6.append(vSwitchSource.getName());
                msg6.append(", the on-board temperature ");
                msg6.append(hardware.getOnBoardTemp().toString());
                msg6.append(vSwitchSource.getTempUnits().toString());
                msg6.append(" crossed the threshold of acceptable temperature (above ");
                msg6.append(hardware.getOnBoardFactoryTempThresh().toString());
                msg6.append(vSwitchSource.getTempUnits());
                msg6.append(")");
                this.addAlarm(openAlarms, AlarmType.HARDWARE_ON_BOARD_TEMP_CRITICAL, source, msg6.toString());
            }
            if (hardware.isNoFan()) {
                msg6 = new StringBuffer(ClassID.VSWITCH.toString());
                msg6.append(" ");
                msg6.append(vSwitchSource.getName());
                msg6.append(". No fan is working");
                this.addAlarm(openAlarms, AlarmType.HARDWARE_NO_FAN, source, msg6.toString());
            }
        }
        openAlarms = this.hasBadValues(openAlarms, source, (VSwitch)vSwitch);
        return openAlarms;
    }

    @Override
    protected List<AlarmImpl> hasBadValues(List<AlarmImpl> openAlarms, GeneralLogicObject source, VSwitch vSwitch) throws RemoteException {
        openAlarms = super.hasBadValues(openAlarms, source, vSwitch);
        VSwitchImpl vSwitchSource = (VSwitchImpl)source;
        List badValues = vSwitchSource.getParametersBadValue(vSwitchSource);
        if (badValues != null) {
            for (Parameter parameter : badValues) {
                if (!parameter.getCode().equals((Object)ParameterCode.VSWITCH_TRAP_UDP_PORT)) continue;
                StringBuffer msg = new StringBuffer(vSwitchSource.getClassId().toString());
                msg.append(" ");
                msg.append(vSwitchSource.getName());
                msg.append(" trap port ");
                msg.append(vSwitchSource.getTrapPort());
                msg.append(" is already in use.  Change the trap port in ");
                msg.append(ClassID.VSWITCH);
                msg.append(" -> Properties -> SNMP to receive traps from this ");
                msg.append(vSwitchSource.getClassId());
                this.addAlarm(openAlarms, AlarmType.VSWITCH_TRAP_PORT_IS_IN_USE, source, vSwitchSource, msg.toString());
            }
        }
        return openAlarms;
    }

    @Override
    public List<AlarmImpl> checkForAlarmsToClose(GeneralLogicObject source, VSwitchImpl vSwitch, List<AlarmImpl> openAlarms) throws RemoteException {
        VSwitchImpl vSwitchSource = (VSwitchImpl)source;
        List<AlarmImpl> closeAlarms = super.checkForAlarmsToClose(source, vSwitch, openAlarms);
        for (AlarmImpl alarm : openAlarms) {
            HardwareImpl hardware;
            if (alarm.getType().equals(AlarmType.VSWITCH_DISCONNECTED)) {
                if (!vSwitchSource.isConnected()) continue;
                closeAlarms.add(alarm);
                continue;
            }
            if (alarm.getType().equals(AlarmType.VSWITCH_TAKEOVER)) {
                if (vSwitchSource.isUnderTakeover()) continue;
                closeAlarms.add(alarm);
                continue;
            }
            if (alarm.getType().equals(AlarmType.LINK_DOWN)) {
                List linkDownInterfaces = vSwitchSource.getLinkDownInterfaces();
                if (linkDownInterfaces.contains(alarm.getAdditionalKeyObject())) continue;
                closeAlarms.add(alarm);
                continue;
            }
            if (vSwitchSource.isSupportSFP()) {
                List interfaces;
                if (alarm.getType().equals(AlarmType.SFP_SPEED_TOO_HIGH) && !(interfaces = vSwitchSource.getTooHighSpeedSFPInterfaces()).contains(alarm.getAdditionalKeyObject())) {
                    closeAlarms.add(alarm);
                }
                if (!alarm.getType().equals(AlarmType.SFP_SPEED_TOO_LOW) || (interfaces = vSwitchSource.getTooLowSpeedSFPInterfaces()).contains(alarm.getAdditionalKeyObject())) continue;
                closeAlarms.add(alarm);
                continue;
            }
            if (alarm.getType().equals(AlarmType.VSWITCH_TRAP_PORT_IS_IN_USE)) {
                List badValues = vSwitchSource.getParametersBadValue(vSwitchSource);
                boolean close = true;
                if (badValues != null) {
                    for (Parameter parameter : badValues) {
                        if (!parameter.getCode().equals((Object)ParameterCode.VSWITCH_TRAP_UDP_PORT)) continue;
                        close = false;
                        break;
                    }
                }
                if (!close) continue;
                closeAlarms.add(alarm);
                continue;
            }
            if (alarm.getType().equals(AlarmType.HARDWARE_CPU_TEMP_WARNING)) {
                hardware = vSwitchSource.getHardware();
                if (hardware == null || hardware.isCPUTempWarning()) continue;
                closeAlarms.add(alarm);
                continue;
            }
            if (alarm.getType().equals(AlarmType.HARDWARE_CPU_TEMP_CRITICAL)) {
                hardware = vSwitchSource.getHardware();
                if (hardware == null || hardware.isCPUTempCritical()) continue;
                closeAlarms.add(alarm);
                continue;
            }
            if (alarm.getType().equals(AlarmType.HARDWARE_FAN_FAULTY)) {
                hardware = vSwitchSource.getHardware();
                if (hardware == null || hardware.isFanFaulty()) continue;
                closeAlarms.add(alarm);
                continue;
            }
            if (alarm.getType().equals(AlarmType.HARDWARE_FAN_CRITICAL)) {
                hardware = vSwitchSource.getHardware();
                if (hardware == null || hardware.isFanCritical()) continue;
                closeAlarms.add(alarm);
                continue;
            }
            if (alarm.getType().equals(AlarmType.HARDWARE_ON_BOARD_TEMP_WARNING)) {
                hardware = vSwitchSource.getHardware();
                if (hardware == null || hardware.isOnBoardTempWarning()) continue;
                closeAlarms.add(alarm);
                continue;
            }
            if (alarm.getType().equals(AlarmType.HARDWARE_ON_BOARD_TEMP_CRITICAL)) {
                hardware = vSwitchSource.getHardware();
                if (hardware == null || hardware.isOnBoardTempCritical()) continue;
                closeAlarms.add(alarm);
                continue;
            }
            if (alarm.getType().equals(AlarmType.HARDWARE_POWER_SUPPLY_FAULTY)) {
                hardware = vSwitchSource.getHardware();
                if (hardware == null || hardware.isPowerSupplyFaulty()) continue;
                closeAlarms.add(alarm);
                continue;
            }
            if (alarm.getType().equals(AlarmType.HARDWARE_NO_FAN)) {
                hardware = vSwitchSource.getHardware();
                if (hardware == null || hardware.isNoFan()) continue;
                closeAlarms.add(alarm);
                continue;
            }
            if (!alarm.getType().equals(AlarmType.VSWITCH_LOW_MEMORY) || VSwitchStatusConstant.LOW_MEMORY.equals((Object)vSwitchSource.getVSwitchStatus())) continue;
            closeAlarms.add(alarm);
        }
        return closeAlarms;
    }

    @Override
    protected boolean isRedundant(GeneralLogicObject source) throws RemoteException {
        return true;
    }
}

