/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.alarm.volume;

import com.sanrad.nms.server.alarm.AlarmImpl;
import com.sanrad.nms.server.alarm.AlarmType;
import com.sanrad.nms.server.alarm.volume.VirtualVolumeAlarmGenerator;
import com.sanrad.nms.server.logic.GeneralLogicObject;
import com.sanrad.nms.server.logic.volume.SnapshotVolumeImpl;
import com.sanrad.nms.server.logic.volume.VolumeNodeImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import java.rmi.RemoteException;
import java.util.List;

public class SnapshotAlarmGenerator
extends VirtualVolumeAlarmGenerator {
    private static SnapshotAlarmGenerator theInstance = new SnapshotAlarmGenerator();

    private SnapshotAlarmGenerator() {
    }

    public static SnapshotAlarmGenerator getInstance() {
        return theInstance;
    }

    @Override
    public List<AlarmImpl> checkForAlarmsToOpen(GeneralLogicObject source, VSwitchImpl vSwitch) throws RemoteException {
        SnapshotVolumeImpl volume = (SnapshotVolumeImpl)source;
        List<AlarmImpl> openAlarms = super.checkForAlarmsToOpen(source, vSwitch);
        if (volume.isFull(vSwitch)) {
            VolumeNodeImpl snapSource = volume.getSourceVolume();
            this.msg = this.getDefaultMessage(source, (VSwitch)vSwitch);
            this.msg.append(" is not synchronized with its source ");
            this.msg.append(snapSource.getClassId());
            this.msg.append(" ");
            this.msg.append(snapSource.getAlias());
            this.msg.append(" because it is full");
            this.addAlarm(openAlarms, AlarmType.SNAPSHOT_IS_FULL, source, vSwitch, this.msg.toString());
        } else if (volume.isOutOfSync()) {
            VolumeNodeImpl snapSource = volume.getSourceVolume();
            this.msg = this.getDefaultMessage(source, (VSwitch)vSwitch);
            this.msg.append(" is not synchronized with its source ");
            this.msg.append(snapSource.getClassId());
            this.msg.append(" ");
            this.msg.append(snapSource.getAlias());
            this.addAlarm(openAlarms, AlarmType.SNAPSHOT_VOLUME_OUT_OF_SYNC, source, vSwitch, this.msg.toString());
        } else if (volume.isOverUsed(vSwitch)) {
            int thresh = volume.getPercentageThreshold(vSwitch);
            this.msg = this.getDefaultMessage(source, (VSwitch)vSwitch);
            this.msg.append(" has exceeded its threshold [");
            this.msg.append(thresh);
            this.msg.append("%]");
            this.addAlarm(openAlarms, AlarmType.OVER_USED_SNAPSHOT, source, vSwitch, this.msg.toString());
        } else if (volume.getCluster().getCopyOperManager().isInvolvedInActiveRestoreOperation((VolumeNodeImpl)volume)) {
            this.msg = this.getDefaultMessage((VSwitch)vSwitch);
            this.msg.append("Roll back operation for ");
            this.msg.append(volume.getClassId());
            this.msg.append(" ");
            this.msg.append(volume.getAlias(vSwitch));
            this.msg.append(" in progress.");
            this.addAlarm(openAlarms, AlarmType.VOLUME_OPER, (GeneralLogicObject)volume, vSwitch, this.msg.toString());
        }
        if (volume.isModified(vSwitch)) {
            this.msg = this.getDefaultMessage(source, (VSwitch)vSwitch);
            this.msg.append(" has been modified");
            this.addAlarm(openAlarms, AlarmType.SNAPSHOT_VOLUME_MODIFIED, source, vSwitch, this.msg.toString());
        }
        return openAlarms;
    }

    @Override
    public List<AlarmImpl> checkForAlarmsToClose(GeneralLogicObject source, VSwitchImpl vSwitch, List<AlarmImpl> openAlarms) throws RemoteException {
        SnapshotVolumeImpl volume = (SnapshotVolumeImpl)source;
        List<AlarmImpl> closeAlarms = super.checkForAlarmsToClose(source, vSwitch, openAlarms);
        for (AlarmImpl alarm : openAlarms) {
            if (alarm.getType().equals(AlarmType.OVER_USED_SNAPSHOT)) {
                if (volume.isOverUsed(vSwitch) && !volume.isFull(vSwitch)) continue;
                closeAlarms.add(alarm);
                continue;
            }
            if (alarm.getType().equals(AlarmType.SNAPSHOT_VOLUME_OUT_OF_SYNC)) {
                if (volume.isOutOfSync(vSwitch) && !volume.isFull(vSwitch)) continue;
                closeAlarms.add(alarm);
                continue;
            }
            if (alarm.getType().equals(AlarmType.SNAPSHOT_VOLUME_MODIFIED)) {
                if (volume.isModified(vSwitch)) continue;
                closeAlarms.add(alarm);
                continue;
            }
            if (alarm.getType().equals(AlarmType.SNAPSHOT_IS_FULL)) {
                if (volume.isFull(vSwitch)) continue;
                closeAlarms.add(alarm);
                continue;
            }
            if (!alarm.getType().equals(AlarmType.VOLUME_OPER) || volume.getCluster().getCopyOperManager().isInvolvedInActiveRestoreOperation((VolumeNodeImpl)volume)) continue;
            closeAlarms.add(alarm);
        }
        return closeAlarms;
    }
}

