/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.alarm.volume;

import com.sanrad.nms.server.alarm.AlarmImpl;
import com.sanrad.nms.server.alarm.AlarmType;
import com.sanrad.nms.server.alarm.volume.VirtualVolumeAlarmGenerator;
import com.sanrad.nms.server.logic.GeneralLogicObject;
import com.sanrad.nms.server.logic.volume.MirrorVolumeImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import java.rmi.RemoteException;
import java.util.List;

public class MirrorVolumeAlarmGenerator
extends VirtualVolumeAlarmGenerator {
    private static MirrorVolumeAlarmGenerator theInstance = new MirrorVolumeAlarmGenerator();

    private MirrorVolumeAlarmGenerator() {
    }

    public static MirrorVolumeAlarmGenerator getInstance() {
        return theInstance;
    }

    @Override
    public List<AlarmImpl> checkForAlarmsToOpen(GeneralLogicObject source, VSwitchImpl vSwitch) throws RemoteException {
        MirrorVolumeImpl volume = (MirrorVolumeImpl)source;
        List<AlarmImpl> openAlarms = super.checkForAlarmsToOpen(source, vSwitch);
        if (!volume.isMirrorMirroring(vSwitch)) {
            this.msg = this.getDefaultMessage(source, (VSwitch)vSwitch);
            this.msg.append(" is not mirroring the data");
            this.addAlarm(openAlarms, AlarmType.MIR_NOT_MIR, source, vSwitch, this.msg.toString());
        }
        return openAlarms;
    }

    @Override
    public List<AlarmImpl> checkForAlarmsToClose(GeneralLogicObject source, VSwitchImpl vSwitch, List<AlarmImpl> openAlarms) throws RemoteException {
        MirrorVolumeImpl volume = (MirrorVolumeImpl)source;
        List<AlarmImpl> closeAlarms = super.checkForAlarmsToClose(source, vSwitch, openAlarms);
        for (AlarmImpl alarm : openAlarms) {
            if (!alarm.getType().equals(AlarmType.MIR_NOT_MIR) || !volume.isMirrorMirroring(vSwitch)) continue;
            closeAlarms.add(alarm);
        }
        return closeAlarms;
    }
}

