/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.alarm.volume;

import com.sanrad.nms.server.alarm.Alarm;
import com.sanrad.nms.server.alarm.AlarmGenerator;
import com.sanrad.nms.server.alarm.AlarmImpl;
import com.sanrad.nms.server.alarm.AlarmMgrImpl;
import com.sanrad.nms.server.alarm.AlarmType;
import com.sanrad.nms.server.logic.GeneralLogicObject;
import com.sanrad.nms.server.logic.GeneralLogicObjectImpl;
import com.sanrad.nms.server.logic.volume.VolumeNodeImpl;
import com.sanrad.nms.server.logic.volume.copy.CopyOperationImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.nms.server.util.types.constants.VolumeOperationOperStatusConstant;
import com.sanrad.nms.server.util.types.constants.VolumeOperationType;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public class CopyOperationAlarmGenerator
extends AlarmGenerator {
    private static CopyOperationAlarmGenerator theInstance = new CopyOperationAlarmGenerator();

    private CopyOperationAlarmGenerator() {
    }

    public static CopyOperationAlarmGenerator getInstance() {
        return theInstance;
    }

    @Override
    public List<AlarmImpl> checkForAlarmsToOpen(GeneralLogicObject source, VSwitchImpl vSwitch) throws RemoteException {
        List<AlarmImpl> openAlarms = super.checkForAlarmsToOpen(source, vSwitch);
        CopyOperationImpl copyOper = (CopyOperationImpl)source;
        VolumeNodeImpl srcVol = copyOper.getCopySrcNode();
        VolumeNodeImpl dstVol = copyOper.getCopyDstNode();
        VolumeOperationOperStatusConstant operStat = copyOper.getCopyStatus();
        VolumeOperationType operType = copyOper.getCopyType();
        if (operStat.isActive()) {
            this.msg = this.getDefaultMessage((VSwitch)vSwitch);
            this.msg.append(operType.toString());
            this.msg.append(" is performed from source ");
            this.msg.append(srcVol.getClassId());
            this.msg.append(" ");
            this.msg.append(srcVol.getAlias(vSwitch));
            this.msg.append(" to destination ");
            this.msg.append(dstVol.getClassId());
            this.msg.append(" ");
            this.msg.append(dstVol.getAlias(vSwitch));
            this.addAlarm(openAlarms, AlarmType.VOLUME_OPER, (GeneralLogicObject)srcVol, vSwitch, this.msg.toString());
        } else if (operStat.equals((Object)VolumeOperationOperStatusConstant.VOLUME_OPERATION_OPER_END_ERROR)) {
            this.msg = this.getDefaultMessage((VSwitch)vSwitch);
            this.msg.append(operType.toString());
            this.msg.append(" ended with error for source ");
            this.msg.append(srcVol.getClassId());
            this.msg.append(" ");
            this.msg.append(srcVol.getAlias(vSwitch));
            this.msg.append(" and destination ");
            this.msg.append(dstVol.getClassId());
            this.msg.append(" ");
            this.msg.append(dstVol.getAlias(vSwitch));
            this.addAlarm(openAlarms, AlarmType.VOLUME_OPER_ER, (GeneralLogicObject)srcVol, vSwitch, this.msg.toString());
        }
        return openAlarms;
    }

    @Override
    protected StringBuffer getDefaultMessage(VSwitch vSwitch) throws RemoteException {
        StringBuffer msg = new StringBuffer(vSwitch.getClassId().toString());
        msg.append(" ");
        msg.append(vSwitch.getName());
        msg.append(". ");
        return msg;
    }

    @Override
    public List<AlarmImpl> checkForAlarmsToClose(GeneralLogicObject source, VSwitchImpl vSwitch, List<AlarmImpl> openAlarmsForCopyOper) throws RemoteException {
        List<AlarmImpl> closeAlarms = super.checkForAlarmsToClose(source, vSwitch, openAlarmsForCopyOper);
        CopyOperationImpl copyOper = (CopyOperationImpl)source;
        VolumeNodeImpl srcVol = copyOper.getCopySrcNode();
        VolumeOperationOperStatusConstant operStat = copyOper.getCopyStatus();
        List<Alarm> openAlarmsForSrcVol_Patch = AlarmMgrImpl.getInstance().getAlarms((GeneralLogicObjectImpl)srcVol);
        ArrayList<AlarmImpl> openAlarmsForSrcVol = new ArrayList<AlarmImpl>();
        for (Alarm alarm : openAlarmsForSrcVol_Patch) {
            openAlarmsForSrcVol.add((AlarmImpl)alarm);
        }
        for (AlarmImpl alarmImpl : openAlarmsForSrcVol) {
            if (alarmImpl.getType().equals(AlarmType.VOLUME_OPER)) {
                if (!operStat.equals((Object)VolumeOperationOperStatusConstant.VOLUME_OPERATION_OPER_END_ERROR) && !operStat.equals((Object)VolumeOperationOperStatusConstant.VOLUME_OPERATION_OPER_END_OK) && !operStat.equals((Object)VolumeOperationOperStatusConstant.VOLUME_OPERATION_OPER_STATUS_IDLE)) continue;
                closeAlarms.add(alarmImpl);
                continue;
            }
            if (!alarmImpl.getType().equals(AlarmType.VOLUME_OPER_ER) || !operStat.isActive() && !operStat.equals((Object)VolumeOperationOperStatusConstant.VOLUME_OPERATION_OPER_END_OK) && !operStat.equals((Object)VolumeOperationOperStatusConstant.VOLUME_OPERATION_OPER_STATUS_IDLE)) continue;
            closeAlarms.add(alarmImpl);
        }
        return closeAlarms;
    }

    @Override
    protected List<AlarmImpl> hasBadValues(List<AlarmImpl> openAlarms, GeneralLogicObject source, VSwitch vSwitch) throws RemoteException {
        return openAlarms;
    }
}

