/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.alarm.target;

import com.sanrad.nms.server.alarm.AlarmImpl;
import com.sanrad.nms.server.alarm.AlarmType;
import com.sanrad.nms.server.alarm.AliasObjectAlarmGenerator;
import com.sanrad.nms.server.logic.GeneralLogicObject;
import com.sanrad.nms.server.logic.acl.AclEntry;
import com.sanrad.nms.server.logic.acl.AclEntryImpl;
import com.sanrad.nms.server.logic.acl.AclImpl;
import com.sanrad.nms.server.logic.acl.Permission;
import com.sanrad.nms.server.logic.identity.IdentityImpl;
import com.sanrad.nms.server.logic.lu.LUImpl;
import com.sanrad.nms.server.logic.target.TargetImpl;
import com.sanrad.nms.server.logic.volume.VolumeNodeImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.SrInteger;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;

public abstract class TargetAlarmGenerator
extends AliasObjectAlarmGenerator {
    protected TargetAlarmGenerator() {
    }

    @Override
    public List<AlarmImpl> checkForAlarmsToOpen(GeneralLogicObject source, VSwitchImpl vSwitch) throws RemoteException {
        StringBuffer msg;
        AclImpl acl;
        TargetImpl target = (TargetImpl)source;
        List<AlarmImpl> openAlarms = super.checkForAlarmsToOpen(source, vSwitch);
        if (target.isExposedOnDifferentVSwitches()) {
            String[] vSwitches = target.getExposedOnVSwitches();
            StringBuffer msg2 = new StringBuffer(source.getClassId().toString());
            msg2.append(" ");
            msg2.append(target);
            msg2.append(" is exposed on different ");
            msg2.append(VSwitch.VSWITCHES_DISPLAY_STRING);
            msg2.append(" (");
            for (int i = 0; i < vSwitches.length; ++i) {
                msg2.append(vSwitches[i]);
                if (i == vSwitches.length - 1) {
                    msg2.append(")");
                    continue;
                }
                msg2.append(", ");
            }
            this.addAlarm(openAlarms, AlarmType.TARGET_EXPOSED_INCONS, source, msg2.toString());
        }
        if ((acl = target.getAclForTarget()) != null) {
            List notRedundantACLEntries;
            HashMap inconsMap = acl.isOrdered();
            if (!inconsMap.isEmpty()) {
                for (AclEntry aclEntry : inconsMap.keySet()) {
                    IdentityImpl identity = (IdentityImpl)aclEntry.getIdentity();
                    if (!identity.isOfLocalTarget() && (identity.isDRIdentityAll() || identity.isPurposeUnknown() || identity.isOfLocalInitiator() || identity.isOfRemoteInitiatorDR())) continue;
                    HashMap map = (HashMap)inconsMap.get(aclEntry);
                    for (ParameterCode code : map.keySet()) {
                        Object value = map.get(code);
                        StringBuffer msg3 = new StringBuffer(code.toString());
                        msg3.append(" of ");
                        msg3.append(target.getClassId());
                        msg3.append(" ");
                        msg3.append(target);
                        msg3.append(" and ");
                        msg3.append(identity.getClassId());
                        msg3.append(" ");
                        msg3.append(identity);
                        msg3.append(" is inconsistent in the cluster");
                        if (code.equals((Object)ParameterCode.ACL_ENTRY_ACCESS)) {
                            Object[] inconsistentValues = (Object[])value;
                            msg3.append(" (");
                            if (inconsistentValues[0] instanceof SrInteger) {
                                msg3.append(Permission.getPermission((int)((SrInteger)inconsistentValues[0]).intValue()));
                            } else {
                                msg3.append(inconsistentValues[0]);
                            }
                            msg3.append(", ");
                            if (inconsistentValues[1] instanceof SrInteger) {
                                msg3.append(Permission.getPermission((int)((SrInteger)inconsistentValues[1]).intValue()));
                            } else {
                                msg3.append(inconsistentValues[1]);
                            }
                            msg3.append(")");
                        }
                        this.addAlarm(openAlarms, AlarmType.ACL_INCONS, (GeneralLogicObject)target, msg3.toString(), value);
                    }
                }
            }
            if ((notRedundantACLEntries = acl.getNotRedundantACLEntries()) != null) {
                for (AclEntryImpl aclEntry : notRedundantACLEntries) {
                    IdentityImpl identity = aclEntry.getIdentity();
                    if (!identity.isOfLocalTarget() && (identity.isDRIdentityAll() || identity.isPurposeUnknown() || identity.isOfLocalInitiator() || identity.isOfRemoteInitiatorDR())) continue;
                    msg = new StringBuffer("The ");
                    msg.append(aclEntry.getClassId());
                    msg.append(" for ");
                    msg.append(target.getClassId());
                    msg.append(" ");
                    msg.append(target);
                    msg.append(" and ");
                    msg.append(identity.getClassId());
                    msg.append(" ");
                    msg.append(identity);
                    msg.append(" is defined only in the ");
                    msg.append(vSwitch.getClassId().toString());
                    msg.append(" ");
                    msg.append(vSwitch.getName());
                    this.addAlarm(openAlarms, AlarmType.ACL_ENTRY_NOT_REDUNDANT, (GeneralLogicObject)target, msg.toString(), aclEntry);
                }
            }
        }
        HashMap<Integer, Integer> checkedLUNs = new HashMap<Integer, Integer>();
        for (LUImpl lu : target.getLUs()) {
            if (checkedLUNs.get(lu.getLUN()) != null) continue;
            checkedLUNs.put(lu.getLUN(), lu.getLUN());
            LUImpl otherLu = target.isLUVolumeChildConsistence(lu);
            if (otherLu != null) {
                VolumeNodeImpl child1 = lu.getVolumeChild();
                VolumeNodeImpl child2 = otherLu.getVolumeChild();
                StringBuffer msg4 = new StringBuffer(source.getClassId().toString());
                msg4.append(" ");
                msg4.append(source.toString());
                msg4.append(" has LU ");
                msg4.append(lu.getLUN());
                msg4.append(" with different volume child (");
                msg4.append(child1.getClassId());
                msg4.append(" ");
                msg4.append(child1);
                msg4.append(", ");
                msg4.append(child2.getClassId());
                msg4.append(" ");
                msg4.append(child2);
                msg4.append(")");
                this.addAlarm(openAlarms, AlarmType.LU_VOLUME_INCONS, source, msg4.toString(), lu.getLUN());
            }
            if ((otherLu = target.isLUNConsistence(lu)) == null) continue;
            VolumeNodeImpl child = lu.getVolumeChild();
            msg = new StringBuffer(source.getClassId().toString());
            msg.append(" ");
            msg.append(source.toString());
            msg.append(" has LU with the same volume child ");
            msg.append(child.getClassId());
            msg.append(" ");
            msg.append(child);
            msg.append(" and different LUN (");
            msg.append(lu.getLUN());
            msg.append(", ");
            msg.append(otherLu.getLUN());
            msg.append(")");
            this.addAlarm(openAlarms, AlarmType.LU_NUMBER_INCONS, source, msg.toString(), lu.getVolumeChild());
        }
        return openAlarms;
    }

    @Override
    public List<AlarmImpl> checkForAlarmsToClose(GeneralLogicObject source, VSwitchImpl vSwitch, List<AlarmImpl> openAlarms) throws RemoteException {
        TargetImpl target = (TargetImpl)source;
        List<AlarmImpl> closeAlarms = super.checkForAlarmsToClose(source, vSwitch, openAlarms);
        for (AlarmImpl alarm : openAlarms) {
            List notRedundantACLEntries;
            AclImpl acl;
            LUImpl lu;
            Enumeration iter;
            AlarmType alarmType = alarm.getType();
            if (alarmType.equals(AlarmType.TARGET_EXPOSED_INCONS)) {
                if (target.isExposedOnDifferentVSwitches()) continue;
                closeAlarms.add(alarm);
                continue;
            }
            if (alarmType.equals(AlarmType.LU_VOLUME_INCONS)) {
                iter = target.getLUs().elements();
                while (iter.hasMoreElements()) {
                    lu = (LUImpl)iter.nextElement();
                    if (target.isLUVolumeChildConsistence(lu) != null || !alarm.getAdditionalKeyObject().equals(lu.getLUN())) continue;
                    closeAlarms.add(alarm);
                }
                continue;
            }
            if (alarmType.equals(AlarmType.LU_NUMBER_INCONS)) {
                iter = target.getLUs().elements();
                while (iter.hasMoreElements()) {
                    lu = (LUImpl)iter.nextElement();
                    if (target.isLUNConsistence(lu) != null || !alarm.getAdditionalKeyObject().equals(lu.getVolumeChild())) continue;
                    closeAlarms.add(alarm);
                }
                continue;
            }
            if (alarmType.equals(AlarmType.ACL_INCONS)) {
                acl = target.getAclForTarget();
                if (acl == null) continue;
                HashMap inconsMap = acl.isOrdered();
                if (inconsMap.isEmpty()) {
                    closeAlarms.add(alarm);
                    continue;
                }
                for (AclEntry aclEntry : inconsMap.keySet()) {
                    HashMap map = (HashMap)inconsMap.get(aclEntry);
                    if (map.containsValue(alarm.getAdditionalKeyObject()) || map.containsValue(alarm.getAdditionalKeyObject())) continue;
                    closeAlarms.add(alarm);
                }
                continue;
            }
            if (!alarmType.equals(AlarmType.ACL_ENTRY_NOT_REDUNDANT) || (acl = target.getAclForTarget()) == null || (notRedundantACLEntries = acl.getNotRedundantACLEntries()) != null && notRedundantACLEntries.contains(alarm.getAdditionalKeyObject())) continue;
            closeAlarms.add(alarm);
        }
        return closeAlarms;
    }
}

