/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.alarm.physstorage;

import com.sanrad.nms.server.alarm.AlarmImpl;
import com.sanrad.nms.server.alarm.AlarmType;
import com.sanrad.nms.server.alarm.AliasObjectAlarmGenerator;
import com.sanrad.nms.server.logic.GeneralLogicObject;
import com.sanrad.nms.server.logic.physstorage.SubDirectAccessDeviceImpl;
import com.sanrad.nms.server.logic.volume.VolumeNodeImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import java.rmi.RemoteException;
import java.util.List;

public class SubDirectAccessDeviceAlarmGenerator
extends AliasObjectAlarmGenerator {
    private static SubDirectAccessDeviceAlarmGenerator theInstance = new SubDirectAccessDeviceAlarmGenerator();

    private SubDirectAccessDeviceAlarmGenerator() {
    }

    public static SubDirectAccessDeviceAlarmGenerator getInstance() {
        return theInstance;
    }

    @Override
    public List<AlarmImpl> checkForAlarmsToOpen(GeneralLogicObject source, VSwitchImpl vSwitch) throws RemoteException {
        StringBuffer msg;
        SubDirectAccessDeviceImpl subDirectAccessDevice = (SubDirectAccessDeviceImpl)source;
        List<AlarmImpl> openAlarms = super.checkForAlarmsToOpen(source, vSwitch);
        if (subDirectAccessDevice.isNeedSync(vSwitch)) {
            this.msg = this.getDefaultMessage(source, (VSwitch)vSwitch);
            this.msg.append(" needs to be synchronized");
            this.addAlarm(openAlarms, AlarmType.VOLUME_NEED_SYNC, source, vSwitch, this.msg.toString());
        }
        if (subDirectAccessDevice.isNonFunctional(vSwitch) && !subDirectAccessDevice.isDROfflineLocalCopy()) {
            this.msg = this.getDefaultMessage(source, (VSwitch)vSwitch);
            this.msg.append(" is not functioning");
            this.addAlarm(openAlarms, AlarmType.VOLUME_NON_FUNC, source, vSwitch, this.msg.toString());
        }
        if (subDirectAccessDevice.getCluster().getCopyOperManager().isInvolvedInActiveRestoreOperation((VolumeNodeImpl)subDirectAccessDevice)) {
            this.msg = this.getDefaultMessage((VSwitch)vSwitch);
            this.msg.append("Roll back operation on ");
            this.msg.append(subDirectAccessDevice.getClassId());
            this.msg.append(" ");
            this.msg.append(subDirectAccessDevice.getAlias(vSwitch));
            this.msg.append(" in progress");
            this.addAlarm(openAlarms, AlarmType.VOLUME_OPER, (GeneralLogicObject)subDirectAccessDevice, vSwitch, this.msg.toString());
        }
        if (subDirectAccessDevice.isMismatch(vSwitch)) {
            msg = new StringBuffer(vSwitch.getClassId().toString());
            msg.append(" ");
            msg.append(vSwitch.getName());
            msg.append(source.getClassId());
            msg.append(" ");
            msg.append(source.toString());
            msg = this.getDefaultMessage(source, (VSwitch)vSwitch);
            msg.append(" is mismatch");
            this.addAlarm(openAlarms, AlarmType.SUBDISK_MISMATCH, source, vSwitch, msg.toString());
        }
        if (subDirectAccessDevice.isNonValidate(vSwitch)) {
            msg = new StringBuffer(vSwitch.getClassId().toString());
            msg.append(" ");
            msg.append(vSwitch.getName());
            msg.append(source.getClassId());
            msg.append(" ");
            msg.append(source.toString());
            msg = this.getDefaultMessage(source, (VSwitch)vSwitch);
            msg.append(" is non validated");
            this.addAlarm(openAlarms, AlarmType.NON_VALIDATE, source, vSwitch, msg.toString());
        }
        return openAlarms;
    }

    @Override
    public List<AlarmImpl> checkForAlarmsToClose(GeneralLogicObject source, VSwitchImpl vSwitch, List<AlarmImpl> openAlarms) throws RemoteException {
        SubDirectAccessDeviceImpl subDirectAccessDevice = (SubDirectAccessDeviceImpl)source;
        List<AlarmImpl> closeAlarms = super.checkForAlarmsToClose(source, vSwitch, openAlarms);
        for (AlarmImpl alarm : openAlarms) {
            if (alarm.getType().equals(AlarmType.VOLUME_NEED_SYNC)) {
                if (subDirectAccessDevice.isNeedSync(vSwitch)) continue;
                closeAlarms.add(alarm);
                continue;
            }
            if (alarm.getType().equals(AlarmType.SUBDISK_MISMATCH)) {
                if (subDirectAccessDevice.isMismatch(vSwitch)) continue;
                closeAlarms.add(alarm);
                continue;
            }
            if (alarm.getType().equals(AlarmType.NON_VALIDATE)) {
                if (subDirectAccessDevice.isNonValidate(vSwitch)) continue;
                closeAlarms.add(alarm);
                continue;
            }
            if (alarm.getType().equals(AlarmType.VOLUME_NON_FUNC)) {
                if (subDirectAccessDevice.isNonFunctional(vSwitch)) continue;
                closeAlarms.add(alarm);
                continue;
            }
            if (!alarm.getType().equals(AlarmType.VOLUME_OPER) || subDirectAccessDevice.getCluster().getCopyOperManager().isInvolvedInActiveRestoreOperation((VolumeNodeImpl)subDirectAccessDevice)) continue;
            closeAlarms.add(alarm);
        }
        return closeAlarms;
    }
}

