/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.alarm.physstorage;

import com.sanrad.nms.server.alarm.AlarmImpl;
import com.sanrad.nms.server.alarm.AlarmType;
import com.sanrad.nms.server.alarm.AliasObjectAlarmGenerator;
import com.sanrad.nms.server.logic.GeneralLogicObject;
import com.sanrad.nms.server.logic.physstorage.GeneralSCSIDeviceImpl;
import com.sanrad.nms.server.logic.volume.VolumeNodeImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import java.rmi.RemoteException;
import java.util.List;

public class GeneralSCSIDeviceAlarmGenerator
extends AliasObjectAlarmGenerator {
    private static GeneralSCSIDeviceAlarmGenerator theInstance = new GeneralSCSIDeviceAlarmGenerator();

    protected GeneralSCSIDeviceAlarmGenerator() {
    }

    public static GeneralSCSIDeviceAlarmGenerator getInstance() {
        return theInstance;
    }

    @Override
    public List<AlarmImpl> checkForAlarmsToOpen(GeneralLogicObject source, VSwitchImpl vSwitch) throws RemoteException {
        GeneralSCSIDeviceImpl device = (GeneralSCSIDeviceImpl)source;
        List<AlarmImpl> openAlarms = super.checkForAlarmsToOpen(source, vSwitch);
        if (device.isMissing(vSwitch)) {
            this.msg = this.getDefaultMessage(source, (VSwitch)vSwitch);
            this.msg.append(" is missing");
            this.addAlarm(openAlarms, AlarmType.DISK_IS_MISSING, source, vSwitch, this.msg.toString());
        }
        if (device.isProvisioned(vSwitch)) {
            this.msg = this.getDefaultMessage(source, (VSwitch)vSwitch);
            this.msg.append(" is configured");
            this.addAlarm(openAlarms, AlarmType.DISK_IS_CONFIGURED, source, vSwitch, this.msg.toString());
        }
        if (device.isInvalid(vSwitch)) {
            this.msg = this.getDefaultMessage(source, (VSwitch)vSwitch);
            this.msg.append(" is invalid");
            this.addAlarm(openAlarms, AlarmType.DISK_IS_INVALID, source, vSwitch, this.msg.toString());
        }
        if (device.isUnknown(vSwitch)) {
            this.msg = this.getDefaultMessage(source, (VSwitch)vSwitch);
            this.msg.append(" is unknown");
            this.addAlarm(openAlarms, AlarmType.DISK_UNKNOWN, source, vSwitch, this.msg.toString());
        }
        if (device.isNeedSync(vSwitch)) {
            this.msg = this.getDefaultMessage(source, (VSwitch)vSwitch);
            this.msg.append(" needs to be synchronized");
            this.addAlarm(openAlarms, AlarmType.VOLUME_NEED_SYNC, source, vSwitch, this.msg.toString());
        }
        if (device.isNonFunctional(vSwitch) && !device.isDROfflineLocalCopy()) {
            this.msg = this.getDefaultMessage(source, (VSwitch)vSwitch);
            this.msg.append(" is not functioning");
            this.addAlarm(openAlarms, AlarmType.VOLUME_NON_FUNC, source, vSwitch, this.msg.toString());
        }
        if (device.getCluster().getCopyOperManager().isInvolvedInActiveRestoreOperation((VolumeNodeImpl)device)) {
            this.msg = this.getDefaultMessage((VSwitch)vSwitch);
            this.msg.append("Roll back operation for ");
            this.msg.append(device.getClassId());
            this.msg.append(" ");
            this.msg.append(device.getAlias(vSwitch));
            this.msg.append(" in progress.");
            this.addAlarm(openAlarms, AlarmType.VOLUME_OPER, (GeneralLogicObject)device, vSwitch, this.msg.toString());
        }
        return openAlarms;
    }

    @Override
    public List<AlarmImpl> checkForAlarmsToClose(GeneralLogicObject source, VSwitchImpl vSwitch, List<AlarmImpl> openAlarms) throws RemoteException {
        GeneralSCSIDeviceImpl device = (GeneralSCSIDeviceImpl)source;
        List<AlarmImpl> closeAlarms = super.checkForAlarmsToClose(source, vSwitch, openAlarms);
        for (AlarmImpl alarm : openAlarms) {
            if (alarm.getType().equals(AlarmType.DISK_IS_MISSING)) {
                if (device.isMissing(vSwitch)) continue;
                closeAlarms.add(alarm);
                continue;
            }
            if (alarm.getType().equals(AlarmType.DISK_IS_CONFIGURED)) {
                if (device.isProvisioned(vSwitch)) continue;
                closeAlarms.add(alarm);
                continue;
            }
            if (alarm.getType().equals(AlarmType.DISK_IS_INVALID)) {
                if (device.isInvalid(vSwitch)) continue;
                closeAlarms.add(alarm);
                continue;
            }
            if (alarm.getType().equals(AlarmType.DISK_UNKNOWN)) {
                if (device.isUnknown(vSwitch)) continue;
                closeAlarms.add(alarm);
                continue;
            }
            if (alarm.getType().equals(AlarmType.VOLUME_NEED_SYNC)) {
                if (device.isNeedSync(vSwitch)) continue;
                closeAlarms.add(alarm);
                continue;
            }
            if (alarm.getType().equals(AlarmType.VOLUME_NON_FUNC)) {
                if (device.isNonFunctional(vSwitch)) continue;
                closeAlarms.add(alarm);
                continue;
            }
            if (!alarm.getType().equals(AlarmType.VOLUME_OPER) || device.getCluster().getCopyOperManager().isInvolvedInActiveRestoreOperation((VolumeNodeImpl)device)) continue;
            closeAlarms.add(alarm);
        }
        return closeAlarms;
    }
}

