/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.alarm.dr;

import com.sanrad.nms.server.alarm.AlarmGenerator;
import com.sanrad.nms.server.alarm.AlarmImpl;
import com.sanrad.nms.server.alarm.AlarmType;
import com.sanrad.nms.server.logic.GeneralLogicObject;
import com.sanrad.nms.server.logic.GeneralLogicObjectImpl;
import com.sanrad.nms.server.logic.dr.DRLogicObjectImpl;
import com.sanrad.nms.server.logic.validation.Validator;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public class DrAlarmGenerator
extends AlarmGenerator {
    protected Class m_father = null;

    protected DrAlarmGenerator() {
    }

    protected Class returnFatherIfAlias() {
        return null;
    }

    @Override
    public List<AlarmImpl> checkForAlarmsToOpen(GeneralLogicObject source, VSwitchImpl vSwitch) throws RemoteException {
        ArrayList<AlarmImpl> openAlarms = new ArrayList();
        openAlarms = super.checkForAlarmsToOpen(source, vSwitch);
        openAlarms.addAll(this.checkForAlarmsToOpenInClusters((DRLogicObjectImpl)source, vSwitch, openAlarms));
        if (Boolean.TRUE.equals(Validator.getInstance().validAccordingToParameter((GeneralLogicObjectImpl)source, AlarmType.NON_FUNCTIONAL, vSwitch))) {
            this.addAlarmAndMsg(source, vSwitch, openAlarms, "is not functional ", AlarmType.NON_FUNCTIONAL);
        }
        if (Boolean.TRUE.equals(Validator.getInstance().validAccordingToParameter((GeneralLogicObjectImpl)source, AlarmType.DR_STATE_ERROR, vSwitch))) {
            this.addAlarmAndMsg(source, vSwitch, openAlarms, " has error ", AlarmType.DR_STATE_ERROR);
        }
        if (((DRLogicObjectImpl)source).getActiveElement() != null && ((DRLogicObjectImpl)source).getActiveElement().isCfWaiting((VSwitch)vSwitch)) {
            this.addAlarmAndMsg(source, vSwitch, openAlarms, " action:" + ((DRLogicObjectImpl)source).getActiveElement().getCfAction((VSwitch)vSwitch) + " in process ", AlarmType.CF_WAIT);
        }
        if (((DRLogicObjectImpl)source).getActiveElement() != null && ((DRLogicObjectImpl)source).getActiveElement().isCfFail((VSwitch)vSwitch)) {
            this.addAlarmAndMsg(source, vSwitch, openAlarms, " action: " + ((DRLogicObjectImpl)source).getActiveElement().getCfAction((VSwitch)vSwitch) + " was failed because of " + ((DRLogicObjectImpl)source).getActiveElement().getErrorReason((VSwitch)vSwitch), AlarmType.CF_FAIL);
        }
        return openAlarms;
    }

    @Override
    public List<AlarmImpl> checkForAlarmsToClose(GeneralLogicObject source, VSwitchImpl vSwitch, List<AlarmImpl> openAlarms) throws RemoteException {
        List<Object> closeAlarms = new ArrayList();
        closeAlarms = super.checkForAlarmsToClose(source, vSwitch, openAlarms);
        closeAlarms.addAll(this.checkForAlarmsToCloseInClusters((DRLogicObjectImpl)source, vSwitch, openAlarms));
        for (AlarmImpl alarm : openAlarms) {
            if (Boolean.FALSE.equals(Validator.getInstance().validAccordingToParameter((GeneralLogicObjectImpl)source, alarm.getType(), vSwitch))) {
                closeAlarms.add(alarm);
                continue;
            }
            if (AlarmType.CF_WAIT.equals(alarm.getType()) && (((DRLogicObjectImpl)source).getActiveElement() != null || !((DRLogicObjectImpl)source).getActiveElement().isCfWaiting((VSwitch)vSwitch))) {
                closeAlarms.add(alarm);
                continue;
            }
            if (!AlarmType.CF_FAIL.equals(alarm.getType()) || ((DRLogicObjectImpl)source).getActiveElement() == null && ((DRLogicObjectImpl)source).getActiveElement().isCfFail((VSwitch)vSwitch)) continue;
            closeAlarms.add(alarm);
        }
        return closeAlarms;
    }

    private List<AlarmImpl> checkForAlarmsToOpenInClusters(DRLogicObjectImpl source, VSwitchImpl vSwitch, List<AlarmImpl> openAlarms) throws RemoteException {
        if (source.getLocalElement() != null && vSwitch != null && vSwitch.getCluster().equals((Object)source.getLocalElement().getCluster())) {
            ArrayList<AlarmImpl> openAlarmsLocal = new ArrayList<AlarmImpl>(source.getClusterAlarmGenerator().checkForAlarmsToOpen((GeneralLogicObject)source.getLocalElement(), vSwitch));
            openAlarms.addAll(openAlarmsLocal);
        }
        if (source.getRemoteElement() != null && vSwitch != null && vSwitch.getCluster().equals((Object)source.getRemoteElement().getCluster())) {
            ArrayList<AlarmImpl> openAlarmsRemote = new ArrayList<AlarmImpl>(source.getClusterAlarmGenerator().checkForAlarmsToOpen((GeneralLogicObject)source.getRemoteElement(), vSwitch));
            openAlarms.addAll(openAlarmsRemote);
        }
        return openAlarms;
    }

    private List<AlarmImpl> checkForAlarmsToCloseInClusters(DRLogicObjectImpl source, VSwitchImpl vSwitch, List<AlarmImpl> openAlarms) throws RemoteException {
        ArrayList<AlarmImpl> closeAlarms = new ArrayList<AlarmImpl>();
        if (source.getLocalElement() != null && vSwitch != null && vSwitch.getCluster().equals((Object)source.getLocalElement().getCluster())) {
            ArrayList<AlarmImpl> closeAlarmsLocal = new ArrayList<AlarmImpl>(source.getClusterAlarmGenerator().checkForAlarmsToClose((GeneralLogicObject)source.getLocalElement(), vSwitch, openAlarms));
            closeAlarms.addAll(closeAlarmsLocal);
        }
        if (source.getRemoteElement() != null && vSwitch != null && vSwitch.getCluster().equals((Object)source.getRemoteElement().getCluster())) {
            ArrayList<AlarmImpl> closeAlarmsRemote = new ArrayList<AlarmImpl>(source.getClusterAlarmGenerator().checkForAlarmsToClose((GeneralLogicObject)source.getRemoteElement(), vSwitch, openAlarms));
            closeAlarms.addAll(closeAlarmsRemote);
        }
        return closeAlarms;
    }

    protected DrAlarmGenerator(Class father) {
        this.setFather(father);
    }

    private void setFather(Class father) {
        this.m_father = this.calculateAnacestor(father);
    }
}

